package com.elitesland.tw.tw5.server.prd.pay.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.BkPayDetailRecordPayload;
import com.elitesland.tw.tw5.api.prd.pay.query.BkPayDetailRecordQuery;
import com.elitesland.tw.tw5.api.prd.pay.service.BkPayDetailRecordService;
import com.elitesland.tw.tw5.api.prd.pay.vo.BkPayDetailRecordVO;
import com.elitesland.tw.tw5.server.prd.pay.convert.BkPayDetailRecordConvert;
import com.elitesland.tw.tw5.server.prd.pay.dao.BkPayDetailRecordDAO;
import com.elitesland.tw.tw5.server.prd.pay.entity.BkPayDetailRecordDO;
import com.elitesland.tw.tw5.server.prd.pay.repo.BkPayDetailRecordRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 支付管理-付款发送记录
 *
 * @author wangly
 * @date 2023-12-12
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BkPayDetailRecordServiceImpl extends BaseServiceImpl implements BkPayDetailRecordService {

    private final BkPayDetailRecordRepo bkPayDetailRecordRepo;
    private final BkPayDetailRecordDAO bkPayDetailRecordDAO;

    @Override
    public PagingVO<BkPayDetailRecordVO> queryPaging(BkPayDetailRecordQuery query) {
        return bkPayDetailRecordDAO.queryPaging(query);
    }

    @Override
    public List<BkPayDetailRecordVO> queryListDynamic(BkPayDetailRecordQuery query) {
        return bkPayDetailRecordDAO.queryListDynamic(query);
    }

    @Override
    public BkPayDetailRecordVO queryByKey(Long key) {
        BkPayDetailRecordDO entity = bkPayDetailRecordRepo.findById(key).orElseGet(BkPayDetailRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BkPayDetailRecordVO vo = BkPayDetailRecordConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BkPayDetailRecordVO insert(BkPayDetailRecordPayload payload) {
        BkPayDetailRecordDO entityDo = BkPayDetailRecordConvert.INSTANCE.toDo(payload);
        return BkPayDetailRecordConvert.INSTANCE.toVo(bkPayDetailRecordRepo.save(entityDo));
    }

    @Override
    @Transactional
    public void batchInsert(List<BkPayDetailRecordPayload> payloads) {
        List<BkPayDetailRecordDO> dos = BkPayDetailRecordConvert.INSTANCE.payloads2Dos(payloads);
        bkPayDetailRecordDAO.saveAll(dos);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BkPayDetailRecordVO update(BkPayDetailRecordPayload payload) {
        BkPayDetailRecordDO entity = bkPayDetailRecordRepo.findById(payload.getId()).orElseGet(BkPayDetailRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BkPayDetailRecordDO entityDo = BkPayDetailRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BkPayDetailRecordConvert.INSTANCE.toVo(bkPayDetailRecordRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BkPayDetailRecordPayload payload) {
        BkPayDetailRecordDO entity = bkPayDetailRecordRepo.findById(payload.getId()).orElseGet(BkPayDetailRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = bkPayDetailRecordDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            bkPayDetailRecordDAO.deleteSoft(keys);
        }
    }

}
