package com.elitesland.tw.tw5.server.prd.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 产品管理
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Entity
@Table(name = "prd_product", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_product", comment = "产品管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdProductDO extends BaseModel implements Serializable  {
    /** 产品编号 */
    @Comment("产品编号")
    @Column()
    private String prodNo;
    /** 产品名称 */
    @Comment("产品名称")
    @Column()
    private String prodName;
    /** 产品大类;	表id，非udc */
    @Comment("产品大类;	表id，非udc")
    @Column()
    private Long classId;
    /** 产品小类 */
    @Comment("产品小类")
    @Column()
    private Long subClassId;
    /** 税率 */
    @Comment("税率")
    @Column()
    private BigDecimal taxRate;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 供应主体类别 */
    @Comment("供应主体类别")
    @Column()
    private String prodType;
    /** BU ID */
    @Comment("BU ID")
    @Column()
    private Long buId;
    /** 产品负责人资源ID */
    @Comment("产品负责人资源ID")
    @Column()
    private Long picResId;
    /** 产品供应商ID */
    @Comment("产品供应商ID")
    @Column()
    private Long coopId;
    /** 状态 */
    @Comment("状态")
    @Column()
    private String prodStatus;
    /** 适用行业 */
    @Comment("适用行业")
    @Column()
    private String industry;
    /** 参考当量 */
    @Comment("参考当量")
    @Column()
    private String refEqva;
    /** 参考价格 */
    @Comment("参考价格")
    @Column()
    private String refPrice;
    /** 是否考察中 */
    @Comment("是否考察中")
    @Column()
    private String inspectFlag;
    /** 考察原因描述 */
    @Comment("考察原因描述")
    @Column()
    private String inspectReason;
    /** 标签 */
    @Comment("标签")
    @Column()
    private String tagDesc;
    /** 提成类别 */
    @Comment("提成类别")
    @Column()
    private String royaltyType;
    /** LOGO路径 */
    @Comment("LOGO路径")
    @Column()
    private String logoPath;
    /** 视频路径 */
    @Comment("视频路径")
    @Column()
    private String videoPath;
    /** 软著名称 */
    @Comment("软著名称")
    @Column()
    private String copyrightName;
    /** 软著编号 */
    @Comment("软著编号")
    @Column()
    private String copyrightCode;
    /** 软著附件 */
    @Comment("软著附件")
    @Column()
    private String copyrightFileCodes;
    /** 是否有测试报告 */
    @Comment("是否有测试报告")
    @Column()
    private String reportFlag;
    /** 测试报告附件 */
    @Comment("测试报告附件")
    @Column()
    private String reportFileCodes;
    /** 是否有软件产品登记证 */
    @Comment("是否有软件产品登记证")
    @Column()
    private String sprcFlag;
    /** 软件产品登记证名称 */
    @Comment("软件产品登记证名称")
    @Column()
    private String sprcName;
    /** 件产品登记证编号 */
    @Comment("件产品登记证编号")
    @Column()
    private String sprcCode;
    /** 软著附件 */
    @Comment("软著附件")
    @Column()
    private String sprcFileCodes;
    /** 软件产品登记证书有效日期开始 */
    @Comment("软件产品登记证书有效日期开始")
    @Column()
    private LocalDate startDate;
    /** 软件产品登记证书有效日期开始 */
    @Comment("软件产品登记证书有效日期开始")
    @Column()
    private LocalDate endDate;
    /** 产品简介 */
    @Comment("产品简介")
    @Column()
    private String prodDesc;
    /** 功能模块 */
    @Comment("功能模块")
    @Column()
    private String functionDesc;
    /** 目标客户 */
    @Comment("目标客户")
    @Column()
    private String customerDesc;

    @Comment("4.0产品id")
    @Column()
    private Long productIdV4;

    public void copy(PrdProductDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
