package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitesland.tw.tw5.api.prd.purchase.payload.BillVerDetailPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.BillVerDetailQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.BillVerDetailVO;
import com.elitesland.tw.tw5.api.prd.purchase.service.BillVerDetailService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 预付款收据管理
 *
 * @folder 预付款收据管理
 * @author wangly
 * @date 2024-05-27
 */
@Api(tags = "预付款收据管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/billVerDetail")
@Slf4j
public class BillVerDetailController {

private final BillVerDetailService billVerDetailService;

    /**
     * 预付款收据管理-新增
     *
     * @folder 预付款收据管理
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("预付款收据管理-新增")
    public TwOutputUtil<BillVerDetailVO> insert(@RequestBody BillVerDetailPayload payload){
         return TwOutputUtil.ok(billVerDetailService.insert(payload));
    }

    /**
     * 预付款收据管理-更新
     *
         * @folder 预付款收据管理
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("预付款收据管理-更新")
    public TwOutputUtil<BillVerDetailVO> update(@RequestBody BillVerDetailPayload payload){
        return TwOutputUtil.ok(billVerDetailService.update(payload));
    }

    /**
     * 预付款收据管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 预付款收据管理
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("预付款收据管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BillVerDetailPayload payload){
        return TwOutputUtil.ok(billVerDetailService.updateByKeyDynamic(payload));
    }

    /**
     * 预付款收据管理-主键查询
     *
     * @folder 预付款收据管理
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("预付款收据管理-主键查询")
    public TwOutputUtil<BillVerDetailVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(billVerDetailService.queryByKey(key));
    }

    /**
     * 预付款收据管理-分页
     *
         * @folder 预付款收据管理
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("预付款收据管理-分页")
    public TwOutputUtil<PagingVO<BillVerDetailVO>> paging(BillVerDetailQuery query) {
        return TwOutputUtil.ok(billVerDetailService.queryPaging(query));
    }

    /**
     * 预付款收据管理-查询列表
     *
     * @folder 预付款收据管理
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("预付款收据管理-查询列表")
    public TwOutputUtil<List<BillVerDetailVO>> queryList(BillVerDetailQuery query) {
        return TwOutputUtil.ok(billVerDetailService.queryListDynamic(query));
    }

    /**
     * 预付款收据管理-删除
     *
         * @folder 预付款收据管理
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("预付款收据管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         billVerDetailService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

