package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 费用承担部门
 *
 * @author likunpeng
 * @date 2023-11-07
 */
@Entity
@Table(name = "cost_undertake_department", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "cost_undertake_department", comment = "费用承担部门")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CostUndertakeDepartmentDO extends BaseModel implements Serializable {
    /**
     * 付款申请单id
     */
    @Comment("付款申请单id")
    @Column()
    private Long paymentApplyId;
    /**
     * 费用承担BU_ID
     */
    @Comment("费用承担BU_ID")
    @Column()
    private Long bearBuId;
    /**
     * 费用承担金额
     */
    @Comment("费用承担金额")
    @Column()
    private BigDecimal bearAmt;
    /**
     * 科目说明(pms_acc_mas表id)
     */
    @Comment("科目说明(pms_acc_mas表id)")
    @Column()
    private Long accMasId;

    /**
     * JDE回传标记
     */
    @Comment("JDE回传标记 0:为传 1:已回传")
    @Column()
    private Integer jdeFlag;

    /**
     * 发票号
     */
    @Comment("发票号")
    @Column()
    private String invoiceNo;


    public void copy(CostUndertakeDepartmentDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
