package com.elitesland.tw.tw5.server.prd.purchase.repo;

import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchasePaymentDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.Optional;

/**
 * 付款申请单
 *
 * @author lipengfei
 * @date 2023-05-31
 */
public interface PurchasePaymentRepo extends JpaRepository<PurchasePaymentDO, Long>, JpaSpecificationExecutor<PurchasePaymentDO> {

    /**
     * 根据流程Id查询付款申请单
     * @param procInstId 流程实例Id
     * @param deleteFlag 删除标志
     * @return 付款申请单
     */
    Optional<PurchasePaymentDO> findByProcInstIdAndDeleteFlag(String procInstId, Integer deleteFlag);
}
