package com.elitesland.tw.tw5.server.prd.salecon.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author Lemon
 */
@Entity
@Table(name = "con_recvplan_change_log", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_recvplan_change_log", comment = "收款计划变更日志")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConRecvplanChangeLogDO extends BaseModel implements Serializable {

    /**
     * 收款计划ID
     */
    @Comment("收款计划ID")
    @Column()
    private Long recvplanId;

    /**
     * 旧日期
     */
    @Comment("旧日期")
    @Column()
    private LocalDate oldRecvOrInvDate;

    /**
     * 新日期
     */
    @Comment("新日期")
    @Column()
    private LocalDate recvOrInvDate;

    /**
     * 类型，RECV-收款，INV-开票
     */
    @Comment("类型，RECV-收款，INV-开票")
    @Column()
    private String type;

    /**
     * 原因
     */
    @Comment("原因")
    @Column()
    private String reason;

    private Boolean flag1;

    private Boolean flag2;

    private Boolean flag3;

    /**
     * 变更人用户Id
     */
    @Column()
    private Long applyUserId;

    // 董海峰 2022年06月29日18:44:28  目的:财务的报表查询需求，能追溯到每次流程对应的变更历史。
    /**
     * 收款计划确认单Id   字段意义：通过收款计划确认单 关联到 唯一的一个变更记录
     */
    @Comment("收款计划确认单Id")
    @Column()
    private Long rcvpConfirmId;

    /**
     * 变更前金额
     */
    @Comment("变更前金额")
    @Column()
    private BigDecimal beforeAmt;
    /**
     * 变更后金额
     */
    @Comment("变更后金额")
    @Column()
    private BigDecimal afterAmt;
}
