package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchieveDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConAchieveDService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveDVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConAchieveDConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConAchieveDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConAchieveDDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConAchieveDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConAchieveRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 业绩统计明细
 *
 * @author likunpeng
 * @date 2023-04-24
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConAchieveDServiceImpl extends BaseServiceImpl implements ConAchieveDService {

    private final ConAchieveDRepo conAchieveDRepo;
    private final ConAchieveRepo conAchieveRepo;
    private final ConAchieveDDAO conAchieveDDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgOrganizationService orgService;

    @Override
    public PagingVO<ConAchieveDVO> queryPaging(ConAchieveDQuery query) {
        getPermissionParams(query);
        return conAchieveDDAO.queryPaging(query);
    }


    private void getPermissionParams(ConAchieveDQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        // 获取角色
        List<String> userSystemRoleCodes = cacheUtil.getSystemRoleCodes(loginUserId);
        // 销售副总裁(SALES_VP)、销售合同管理员(SALES_CONTRACT_ADMIN)、系统管理员(SYS)、财务负责人(FIN_PIC)、商务负责人(BUSINESS_MANAGER)、合同归档管理员(CONTRACT_FILING)、平台财务负责人(PLAT_FIN_PIC)、运营总裁(OPERATION_PRESIDENT)、财务核定(FIN_CHECK_PIC)可以看到全部
        List<String> roles = Arrays.asList("SYS", "PLAT_FINANCIAL_PERFORMANCE_STATISTICS");
        if ((!CollectionUtils.isEmpty(userSystemRoleCodes)) && CollectionUtils.containsAny(userSystemRoleCodes, roles)) {
            return;
        }
        // 查看当前登录人是哪个bu的leader
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setManageId(loginUserId);
        orgQuery.setSize(Integer.MAX_VALUE);
        PagingVO<PrdOrgOrganizationVO> paging = orgService.paging(orgQuery);
        List<PrdOrgOrganizationVO> records = paging.getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            List<Long> orgIds = records.stream().map(PrdOrgOrganizationVO::getId).collect(Collectors.toList());
            query.setOrgIdsByPermission(orgIds);
        } else {
            query.setOrgIdsByPermission(new ArrayList<Long>());
        }
        // 设置负责人是当前登录人
        query.setUserIdsByPermission(Collections.singletonList(loginUserId));
    }


    @Override
    public List<ConAchieveDVO> queryListDynamic(ConAchieveDQuery query) {
        return conAchieveDDAO.queryListDynamic(query);
    }

    @Override
    public ConAchieveDVO queryByKey(Long key) {
        ConAchieveDDO entity = conAchieveDRepo.findById(key).orElseGet(ConAchieveDDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConAchieveDVO vo = ConAchieveDConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConAchieveDVO insert(ConAchieveDPayload payload) {
        ConAchieveDDO entityDo = ConAchieveDConvert.INSTANCE.toDo(payload);
        // 为了定时任务需要同步更新时间
        conAchieveRepo.updateRemark(entityDo.getAchieveId());
        return ConAchieveDConvert.INSTANCE.toVo(conAchieveDRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConAchieveDVO update(ConAchieveDPayload payload) {
        ConAchieveDDO entity = conAchieveDRepo.findById(payload.getId()).orElseGet(ConAchieveDDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConAchieveDDO entityDo = ConAchieveDConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        // 为了定时任务需要同步更新时间
        conAchieveRepo.updateRemark(entity.getAchieveId());
        return ConAchieveDConvert.INSTANCE.toVo(conAchieveDRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conAchieveDDAO.deleteSoft(keys);
        }
    }

}
