package com.elitesland.tw.tw5.server.prd.schedule.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author zoey
 * @Description:日历共享成员表
 * @date 2022/4/19 - 20:47
 */
@Entity
@Table(name = "prd_calendar_share",indexes = {@Index(name = "cal_index", columnList = "cal_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_calendar_share", comment = "日历共享成员表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdCalendarShareDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Comment("只读标志")
    @Column(name = "readonly", nullable = false)
    private Integer readonly;

    @Comment("日历id")
    @Column(name = "cal_id", nullable = false)
    private Long calId;

    @Comment("日历共享成员的id")
    @Column(name = "user_id", nullable = false)
    private Long userId;

}
