package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCollaboratePartnerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCollaboratePartnerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.dao.BusinessCollaboratePartnerInfoDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "COLLABORATE_ACTIVE" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class BusinessCollaboratePartnerCallBackController implements WorkflowCallBack {

   private final BusinessCollaboratePartnerInfoDAO dao;
   private final BusinessCollaboratePartnerInfoService service;
    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        BusinessCollaboratePartnerInfoPayload businessCollaboratePartnerInfoPayload = new BusinessCollaboratePartnerInfoPayload();
        businessCollaboratePartnerInfoPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = service.queryByKey(Long.valueOf(businessKey));
        if (businessCollaboratePartnerInfoVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
//                    busiCardApplyPayload.setDetailedStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    businessCollaboratePartnerInfoPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
//                    epibolyCostConDPayload.setDetailedStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    businessCollaboratePartnerInfoPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                case INVALID://先删除流程再删除单据 作废 只是作废流程将之前的数据还原
                    //businessCollaboratePartnerInfoPayload.setDeleteFlag(1);
                    businessCollaboratePartnerInfoPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    businessCollaboratePartnerInfoPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());

                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    businessCollaboratePartnerInfoPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    businessCollaboratePartnerInfoPayload.setApprovedTime(LocalDateTime.now());
                    businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.ACTIVE.getCode());
                    break;
                case APPROVING:
                    businessCollaboratePartnerInfoPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.APPROVING.getCode());
            }
            dao.updateByKeyDynamic(businessCollaboratePartnerInfoPayload);
        }
        return WorkflowResult.success(null);
    }
}
