/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigRulePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigRuleQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigRuleService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigRuleVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypeConfigRuleConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeConfigRuleDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeConfigRuleDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeConfigRuleRepo;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessDocTypeConfigRuleServiceImpl
extends BaseServiceImpl
implements BusinessDocTypeConfigRuleService {
    private static final Logger log = LoggerFactory.getLogger(BusinessDocTypeConfigRuleServiceImpl.class);
    private final BusinessDocTypeConfigRuleRepo businessDocTypeConfigRuleRepo;
    private final BusinessDocTypeConfigRuleDAO businessDocTypeConfigRuleDAO;
    private final YeedocService yeedocService;
    private final BusinessDocTypeConfigService businessDocTypeConfigService;
    private final BusinessTableService businessTableService;
    private final BusinessTableFieldsService businessTableFieldsService;

    public PagingVO<BusinessDocTypeConfigRuleVO> queryPaging(BusinessDocTypeConfigRuleQuery query) {
        this.checkQuery(query);
        return this.businessDocTypeConfigRuleDAO.queryPaging(query);
    }

    private void checkQuery(BusinessDocTypeConfigRuleQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getConfigId())) {
            throw TwException.error("", "configId \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public List<BusinessDocTypeConfigRuleVO> queryListDynamic(BusinessDocTypeConfigRuleQuery query) {
        this.checkQuery(query);
        return this.businessDocTypeConfigRuleDAO.queryListDynamic(query);
    }

    public Long count(BusinessDocTypeConfigRuleQuery query) {
        return this.businessDocTypeConfigRuleDAO.count(query);
    }

    public Long checkUnique(Long configId) {
        return this.businessDocTypeConfigRuleDAO.checkUnique(configId);
    }

    public BusinessDocTypeConfigRuleVO queryByKey(Long key) {
        BusinessDocTypeConfigRuleDO entity = this.businessDocTypeConfigRuleRepo.findById(key).orElseGet(BusinessDocTypeConfigRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u6587\u6863\u7c7b\u578b\u914d\u7f6e\u89c4\u5219\u4e0d\u5b58\u5728");
        BusinessDocTypeConfigRuleVO vo = BusinessDocTypeConfigRuleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessDocTypeConfigRuleVO insert(BusinessDocTypeConfigRulePayload payload) {
        this.check(payload);
        this.initData(payload);
        BusinessDocTypeConfigRuleDO entityDo = BusinessDocTypeConfigRuleConvert.INSTANCE.toDo(payload);
        BusinessDocTypeConfigRuleDO save = (BusinessDocTypeConfigRuleDO)this.businessDocTypeConfigRuleRepo.save(entityDo);
        Object path = save.getPath();
        if (StringUtils.hasText((String)path)) {
            Object data;
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ArrayList<Object> pathArry = new ArrayList<Object>();
            pathArry.add(path);
            hashMap.put("LibraryId", save.getLibraryId());
            hashMap.put("PathArry", pathArry);
            String resultStr = this.yeedocService.createFolder(hashMap);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)resultStr)) {
                throw TwException.error("", "\u6613\u9053\u58f3\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
            try {
                JSONObject resultJson = JSONObject.parseObject((String)resultStr);
                data = resultJson.get((Object)"Data");
            }
            catch (Exception e) {
                log.error("\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!resultStr = {" + resultStr + "}", (Throwable)e);
                throw TwException.error("", "\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!result = {" + resultStr + "}");
            }
            if (ObjectUtils.isEmpty((Object)data)) {
                throw TwException.error("", "\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!result = {" + resultStr + "}");
            }
            JSONArray arrayDate = JSONArray.parseArray((String)data.toString());
            String itemId = "";
            for (int i = 0; i < arrayDate.size(); ++i) {
                JSONObject jsonObject = JSONObject.parseObject((String)arrayDate.get(i).toString());
                itemId = (String)jsonObject.get((Object)"FolderId");
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)itemId)) {
                throw TwException.error("", "\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff0c\u8fd4\u56deitemId\u4e3a\u7a7a!result = {" + resultStr + "}");
            }
            save.setItemId(itemId);
        }
        return BusinessDocTypeConfigRuleConvert.INSTANCE.toVo(save);
    }

    private void initData(BusinessDocTypeConfigRulePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getConditions())) {
            payload.setConditions("=");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSortNo())) {
            payload.setSortNo(Integer.valueOf(0));
        }
        if (!ObjectUtils.isEmpty((Object)payload.getConfigId())) {
            BusinessDocTypeConfigVO businessDocTypeConfigVO = this.businessDocTypeConfigService.queryByKey(payload.getConfigId());
            payload.setConfigCode(businessDocTypeConfigVO.getCode());
            payload.setConfigName(businessDocTypeConfigVO.getName());
            payload.setFunctionId(businessDocTypeConfigVO.getFunctionId());
            payload.setTableId(businessDocTypeConfigVO.getTableId());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getTableId())) {
            BusinessTableVO businessTableVO = this.businessTableService.queryByKey(payload.getTableId());
            payload.setTableName(businessTableVO.getTableName());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getFieldId())) {
            BusinessTableFieldsVO businessTableFieldsVO = this.businessTableFieldsService.queryByKey(payload.getFieldId());
            payload.setFieldShowName(businessTableFieldsVO.getShowName());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getPath()) && !payload.getPath().startsWith("/")) {
            payload.setPath("/" + payload.getPath());
        }
    }

    private void check(BusinessDocTypeConfigRulePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getConfigId())) {
            throw TwException.error("", "configId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!ObjectUtils.isEmpty((Object)payload.getFieldId()) && ObjectUtils.isEmpty((Object)payload.getConditionsValue())) {
            log.error("conditionsValue \u4e0d\u80fd\u4e3a\u7a7a");
            throw TwException.error("", "\u5b58\u50a8\u89c4\u5219\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getLibraryId())) {
            throw TwException.error("", "\u8bf7\u9009\u62e9\u6587\u6863\u5e93");
        }
        if (!ObjectUtils.isEmpty((Object)payload.getFieldId())) {
            BusinessDocTypeConfigRuleQuery query = new BusinessDocTypeConfigRuleQuery();
            query.setConfigId(payload.getConfigId());
            query.setFieldId(payload.getFieldId());
            query.setIdNe(payload.getId());
            query.setConditionsValue(payload.getConditionsValue());
            Long count = this.count(query);
            if (count > 0L) {
                throw TwException.error("", "\u6761\u4ef6\u91cd\u590d\uff0c\u4e0d\u53ef\u65b0\u589e");
            }
        } else {
            Long count = this.checkUnique(payload.getConfigId());
            if (count > 0L) {
                throw TwException.error("", "\u6761\u4ef6\u91cd\u590d\uff0c\u4e0d\u53ef\u65b0\u589e");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessDocTypeConfigRuleVO update(BusinessDocTypeConfigRulePayload payload) {
        BusinessDocTypeConfigRuleDO entity = this.businessDocTypeConfigRuleRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u6587\u6863\u7c7b\u578b\u914d\u7f6e\u89c4\u5219\u4e0d\u5b58\u5728");
        BusinessDocTypeConfigRuleDO entityDo = BusinessDocTypeConfigRuleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessDocTypeConfigRuleConvert.INSTANCE.toVo((BusinessDocTypeConfigRuleDO)this.businessDocTypeConfigRuleRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessDocTypeConfigRulePayload payload) {
        BusinessDocTypeConfigRuleDO entity = this.businessDocTypeConfigRuleRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u6587\u6863\u7c7b\u578b\u914d\u7f6e\u89c4\u5219\u4e0d\u5b58\u5728");
        long result = this.businessDocTypeConfigRuleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessDocTypeConfigRuleDAO.deleteSoft(keys);
        }
    }

    public BusinessDocTypeConfigRuleServiceImpl(BusinessDocTypeConfigRuleRepo businessDocTypeConfigRuleRepo, BusinessDocTypeConfigRuleDAO businessDocTypeConfigRuleDAO, YeedocService yeedocService, BusinessDocTypeConfigService businessDocTypeConfigService, BusinessTableService businessTableService, BusinessTableFieldsService businessTableFieldsService) {
        this.businessDocTypeConfigRuleRepo = businessDocTypeConfigRuleRepo;
        this.businessDocTypeConfigRuleDAO = businessDocTypeConfigRuleDAO;
        this.yeedocService = yeedocService;
        this.businessDocTypeConfigService = businessDocTypeConfigService;
        this.businessTableService = businessTableService;
        this.businessTableFieldsService = businessTableFieldsService;
    }
}

