/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingCheckPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccBusinessItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccBusinessItemService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingContinuousService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingLimitService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingOverdueService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingTitleService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBusinessItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingContinuousVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingLimitVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingTitleVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimSettingTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.MessageNoticeScopeEnum;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AccReimSettingServiceImpl
extends BaseServiceImpl
implements AccReimSettingService {
    private static final Logger log = LoggerFactory.getLogger(AccReimSettingServiceImpl.class);
    private final AccReimSettingRepo accReimSettingRepo;
    private final AccReimSettingDAO accReimSettingDAO;
    private final CacheUtil cacheUtil;
    private final AccBusinessItemService accBusinessItemService;
    private final InvInvoiceService invInvoiceService;
    private final VacationService vacationService;

    public PagingVO<AccReimSettingVO> queryPaging(AccReimSettingQuery query) {
        PagingVO<AccReimSettingVO> accReimSettingVOPagingVO = this.accReimSettingDAO.queryPaging(query);
        List accReimSettingVOS = accReimSettingVOPagingVO.getRecords();
        if (!CollectionUtils.isEmpty((Collection)accReimSettingVOS)) {
            this.translateList(accReimSettingVOS);
        }
        return accReimSettingVOPagingVO;
    }

    public List<AccReimSettingVO> queryListDynamic(AccReimSettingQuery query) {
        List<AccReimSettingVO> accReimSettingVOS = this.accReimSettingDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(accReimSettingVOS)) {
            this.translateList(accReimSettingVOS);
        }
        return accReimSettingVOS;
    }

    public AccReimSettingVO queryByKey(Long key) {
        AccReimSettingDO entity = this.accReimSettingRepo.findById(key).orElseGet(AccReimSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingVO vo = AccReimSettingConvert.INSTANCE.toVo(entity);
        this.translateList(Collections.singletonList(vo));
        return vo;
    }

    private void translateList(List<AccReimSettingVO> voList) {
        for (AccReimSettingVO vo : voList) {
            String name = this.getApplicationSourceName(vo.getId(), vo.getApplicationScope(), vo.getApplicationSource());
            vo.setApplicationSourceName(name);
            if (StringUtils.hasText((String)vo.getExpenseCompany())) {
                ArrayList<String> expenseCompanyNames = new ArrayList<String>();
                for (String expenseCompany : vo.getExpenseCompany().split(",")) {
                    String expenseCompanyName = this.cacheUtil.getCompanyNameByBookId(Long.parseLong(expenseCompany));
                    expenseCompanyNames.add(expenseCompanyName);
                }
                String string = String.join((CharSequence)",", expenseCompanyNames);
                vo.setExpenseCompanyName(string);
            }
            if (StringUtils.hasText((String)vo.getBusAccItemId())) {
                ArrayList busAccItemNames = new ArrayList();
                AccBusinessItemQuery accBusinessItemQuery = new AccBusinessItemQuery();
                List idList = Arrays.stream(vo.getBusAccItemId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                accBusinessItemQuery.setIdList(idList);
                List accBusinessItemVOS = this.accBusinessItemService.queryListDynamic(accBusinessItemQuery);
                if (!CollectionUtils.isEmpty((Collection)accBusinessItemVOS)) {
                    String accItemCodeStr = accBusinessItemVOS.stream().map(AccBusinessItemVO::getBusinessCode).collect(Collectors.joining(","));
                    String accItemNameStr = accBusinessItemVOS.stream().map(AccBusinessItemVO::getBusinessCode).collect(Collectors.joining(","));
                    vo.setBusAccItemCode(accItemCodeStr);
                    vo.setBusAccItemName(accItemNameStr);
                }
            }
            if (StringUtils.hasText((String)vo.getWhiteList())) {
                ArrayList<String> userNames = new ArrayList<String>();
                for (String sourceId : vo.getWhiteList().split(",")) {
                    String userName = this.cacheUtil.getUserName(Long.parseLong(sourceId));
                    userNames.add(userName);
                }
                String string = String.join((CharSequence)",", userNames);
                vo.setWhiteListName(string);
            }
            if (!StringUtils.hasText((String)vo.getReimDocType())) continue;
            ArrayList<String> reimDocTypes = new ArrayList<String>();
            for (String reimDocType : vo.getReimDocType().split(",")) {
                String reimDocTypeName = this.cacheUtil.transferSystemSelection("ACC:REIM_PROC_KEY", reimDocType);
                reimDocTypes.add(reimDocTypeName);
            }
            String string = String.join((CharSequence)",", reimDocTypes);
            vo.setReimDocTypeName(string);
        }
    }

    public String getApplicationSourceName(Long settingId, String applicationScope, String applicationSource) {
        String name = applicationSource;
        if (StringUtils.hasText((String)applicationSource)) {
            if (applicationScope.equals(MessageNoticeScopeEnum.APPOINT_ORG.getCode())) {
                name = this.accReimSettingDAO.getOrgNames(settingId);
            }
            if (applicationScope.equals(MessageNoticeScopeEnum.APPIONT_PEOPLE.getCode())) {
                ArrayList<String> userNames = new ArrayList<String>();
                for (String sourceId : applicationSource.split(",")) {
                    String userName = this.cacheUtil.getUserName(Long.parseLong(sourceId));
                    userNames.add(userName);
                }
                name = String.join((CharSequence)",", userNames);
            }
            if (applicationScope.equals(MessageNoticeScopeEnum.APPOINT_ROLE.getCode())) {
                name = this.accReimSettingDAO.getRoleNames(settingId);
            }
        }
        return name;
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimSettingVO insert(AccReimSettingPayload payload) {
        AccReimSettingDO entityDo = AccReimSettingConvert.INSTANCE.toDo(payload);
        return AccReimSettingConvert.INSTANCE.toVo((AccReimSettingDO)this.accReimSettingRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimSettingVO update(AccReimSettingPayload payload) {
        AccReimSettingDO entity = this.accReimSettingRepo.findById(payload.getId()).orElseGet(AccReimSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingDO entityDo = AccReimSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimSettingConvert.INSTANCE.toVo((AccReimSettingDO)this.accReimSettingRepo.save(entity));
    }

    public void checkRepeat(AccReimSettingPayload payload) {
        Boolean repeatFlag = false;
        block0: for (String reimDocType : payload.getReimDocType().split(",")) {
            int count;
            if (payload.getId() == null) {
                for (String expenseCompany : payload.getExpenseCompany().split(",")) {
                    count = this.accReimSettingRepo.countByReimSettingTypeAndReimDocTypeLikeAndExpenseCompanyLikeAndApplicationScopeAndDeleteFlag(payload.getReimSettingType(), "%" + reimDocType + "%", "%" + expenseCompany + "%", MessageNoticeScopeEnum.WHOLE.getCode(), 0);
                    if (count <= 0) continue;
                    repeatFlag = true;
                    continue block0;
                }
                continue;
            }
            for (String expenseCompany : payload.getExpenseCompany().split(",")) {
                count = this.accReimSettingRepo.countByReimSettingTypeAndReimDocTypeLikeAndExpenseCompanyLikeAndApplicationScopeAndIdNotAndDeleteFlag(payload.getReimSettingType(), "%" + reimDocType + "%", "%" + expenseCompany + "%", MessageNoticeScopeEnum.WHOLE.getCode(), payload.getId(), 0);
                if (count <= 0) continue;
                repeatFlag = true;
                continue block0;
            }
        }
        if (repeatFlag.booleanValue()) {
            throw TwException.error("", "\u914d\u7f6e\u91cd\u590d\uff0c\u76f8\u540c\u5355\u636e\u7c7b\u578b\uff0c\u76f8\u540c\u9002\u7528\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\u9002\u7528\u4e8e\u5168\u5458\u7684\u62a5\u9500\u914d\u7f6e!");
        }
        if (payload.getApplicationSource() != null) {
            for (String reimDocType : payload.getReimDocType().split(",")) {
                block4: for (String source : payload.getApplicationSource().split(",")) {
                    int count;
                    if (payload.getId() == null) {
                        for (String expenseCompany : payload.getExpenseCompany().split(",")) {
                            count = this.accReimSettingRepo.countByReimSettingTypeAndReimDocTypeLikeAndExpenseCompanyLikeAndApplicationScopeAndApplicationSourceLikeAndDeleteFlag(payload.getReimSettingType(), "%" + reimDocType + "%", "%" + expenseCompany + "%", payload.getApplicationScope(), "%" + source + "%", 0);
                            if (count <= 0) continue;
                            repeatFlag = true;
                            continue block4;
                        }
                        continue;
                    }
                    for (String expenseCompany : payload.getExpenseCompany().split(",")) {
                        count = this.accReimSettingRepo.countByReimSettingTypeAndReimDocTypeLikeAndExpenseCompanyLikeAndApplicationScopeAndApplicationSourceLikeAndIdNotAndDeleteFlag(payload.getReimSettingType(), "%" + reimDocType + "%", "%" + expenseCompany + "%", payload.getApplicationScope(), "%" + source + "%", payload.getId(), 0);
                        if (count <= 0) continue;
                        repeatFlag = true;
                        continue block4;
                    }
                }
            }
            if (repeatFlag.booleanValue()) {
                throw TwException.error("", "\u914d\u7f6e\u91cd\u590d\uff0c\u76f8\u540c\u5355\u636e\u7c7b\u578b\uff0c\u76f8\u540c\u9002\u7528\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\u5f53\u524d\u9002\u7528\u4eba\u5458\u7684\u62a5\u9500\u914d\u7f6e!");
            }
        }
    }

    public AccReimSettingVO queryBaseSetting(AccReimSettingQuery query) {
        AccReimSettingVO accReimSettingVO = null;
        query.setApplicationScope(MessageNoticeScopeEnum.WHOLE.getCode());
        query.setApplicationSource(null);
        List<AccReimSettingVO> accReimSettingVOS = this.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(accReimSettingVOS)) {
            accReimSettingVO = accReimSettingVOS.get(0);
        }
        query.setApplicationScope(MessageNoticeScopeEnum.APPOINT_ORG.getCode());
        Long applicationUser = query.getApplicationUser();
        Long applicationUserOrgId = this.cacheUtil.getDefaultOrgIdByUserId(applicationUser);
        if (applicationUserOrgId != null) {
            query.setApplicationSource(applicationUserOrgId.toString());
            accReimSettingVOS = this.queryListDynamic(query);
            if (!CollectionUtils.isEmpty(accReimSettingVOS)) {
                accReimSettingVO = accReimSettingVOS.get(0);
            }
        }
        query.setApplicationScope(MessageNoticeScopeEnum.APPIONT_PEOPLE.getCode());
        query.setApplicationSource(applicationUser.toString());
        accReimSettingVOS = this.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(accReimSettingVOS)) {
            accReimSettingVO = accReimSettingVOS.get(0);
        }
        return accReimSettingVO;
    }

    public Map<String, AccReimSettingVO> queryBaseSettings(AccReimSettingQuery query) {
        HashMap<String, AccReimSettingVO> accReimSettingVOMap = new HashMap<String, AccReimSettingVO>();
        for (AccReimSettingTypeEnum settingType : AccReimSettingTypeEnum.values()) {
            query.setReimSettingType(settingType.getCode());
            AccReimSettingVO accReimSettingVO = this.queryBaseSetting(query);
            accReimSettingVOMap.put(settingType.getCode(), accReimSettingVO);
        }
        return accReimSettingVOMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AccReimSettingPayload payload) {
        AccReimSettingDO entity = this.accReimSettingRepo.findById(payload.getId()).orElseGet(AccReimSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.accReimSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.accReimSettingDAO.deleteSoft(keys);
        }
    }

    public Map<String, Object> ruleCheck(AccReimSettingCheckPayload reimSettingCheckPayload) {
        HashMap<String, Object> checkResult = new HashMap<String, Object>();
        Map keys = reimSettingCheckPayload.getKeys();
        String invoiceNo = reimSettingCheckPayload.getInvoiceNo();
        Long reimUserId = reimSettingCheckPayload.getReimUserId();
        String expenseDate = reimSettingCheckPayload.getExpenseDate();
        BigDecimal reimAmt = reimSettingCheckPayload.getReimAmt();
        String expensePlaceGrade = reimSettingCheckPayload.getExpensePlaceGrade();
        Long expenseCompanyId = reimSettingCheckPayload.getExpenseCompanyId();
        List invInvoiceVOS = new ArrayList();
        if (StringUtils.hasText((String)invoiceNo)) {
            List invNoList = Arrays.stream(invoiceNo.split(",")).collect(Collectors.toList());
            InvInvoiceQuery invInvoiceQuery = new InvInvoiceQuery();
            invInvoiceQuery.setInvoiceNoIn(invNoList);
            invInvoiceVOS = this.invInvoiceService.queryListDynamic(invInvoiceQuery);
        }
        for (String settingType : keys.keySet()) {
            Long key = (Long)keys.get(settingType);
            if (reimUserId == null) {
                throw TwException.error("", "\u62a5\u9500\u4eba\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            switch (AccReimSettingTypeEnum.valueOf(settingType)) {
                case SERIATE: {
                    AccReimSettingContinuousService continuousService = (AccReimSettingContinuousService)SpringUtil.getBean(AccReimSettingContinuousService.class);
                    if (invoiceNo == null) {
                        throw TwException.error("", "\u67e5\u8be2\u8fde\u53f7\u914d\u7f6e\u5fc5\u987b\u6709\u53d1\u7968\uff01");
                    }
                    log.debug("\u8fde\u53f7\u6821\u9a8c\u5f00\u59cb\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a" + LocalDateTime.now());
                    AccReimSettingContinuousVO accReimSettingContinuousVO = continuousService.ruleCheck(key, invInvoiceVOS, reimUserId);
                    log.debug("\u8fde\u53f7\u6821\u9a8c\u7ed3\u675f\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a" + LocalDateTime.now());
                    checkResult.put(settingType, accReimSettingContinuousVO);
                    break;
                }
                case OVERDUE: {
                    AccReimSettingOverdueService overdueService = (AccReimSettingOverdueService)SpringUtil.getBean(AccReimSettingOverdueService.class);
                    AccReimSettingOverdueVO accReimSettingOverdueVO = overdueService.ruleCheck(key, expenseDate, invoiceNo, reimUserId);
                    checkResult.put(settingType, accReimSettingOverdueVO);
                    break;
                }
                case LODGE_OVERAGE: {
                    AccReimSettingLimitService limitService = (AccReimSettingLimitService)SpringUtil.getBean(AccReimSettingLimitService.class);
                    if (reimAmt == null) {
                        throw TwException.error("", "\u67e5\u8be2\u4f4f\u5bbf\u989d\u5ea6\u914d\u7f6e\uff0c\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    AccReimSettingLimitVO accReimSettingLimitVO = limitService.ruleCheck(key, reimUserId, reimAmt, expensePlaceGrade);
                    checkResult.put(settingType, accReimSettingLimitVO);
                    break;
                }
                case INVOICE_TITLE: {
                    AccReimSettingTitleService titleService = (AccReimSettingTitleService)SpringUtil.getBean(AccReimSettingTitleService.class);
                    if (invoiceNo == null) {
                        throw TwException.error("", "\u53d1\u7968\u62ac\u5934\u914d\u7f6e\uff0c\u53d1\u7968\u53f7\u7801\u548c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u90fd\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    log.debug("\u62ac\u5934\u6821\u9a8c\u5f00\u59cb\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a" + LocalDateTime.now());
                    AccReimSettingTitleVO accReimSettingTitleVO = titleService.ruleCheck(key, invInvoiceVOS, reimUserId, expenseCompanyId);
                    log.debug("\u62ac\u5934\u6821\u9a8c\u7ed3\u675f\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a" + LocalDateTime.now());
                    checkResult.put(settingType, accReimSettingTitleVO);
                    break;
                }
                case HOLIDAY_CHECK: {
                    LocalDate compareDate = LocalDate.parse(expenseDate);
                    List vacationDay = this.vacationService.findVacationDay(compareDate, compareDate);
                    if (!CollectionUtils.isEmpty((Collection)vacationDay)) {
                        checkResult.put(settingType, true);
                        break;
                    }
                    checkResult.put(settingType, false);
                }
            }
        }
        return checkResult;
    }

    public AccReimSettingServiceImpl(AccReimSettingRepo accReimSettingRepo, AccReimSettingDAO accReimSettingDAO, CacheUtil cacheUtil, AccBusinessItemService accBusinessItemService, InvInvoiceService invInvoiceService, VacationService vacationService) {
        this.accReimSettingRepo = accReimSettingRepo;
        this.accReimSettingDAO = accReimSettingDAO;
        this.cacheUtil = cacheUtil;
        this.accBusinessItemService = accBusinessItemService;
        this.invInvoiceService = invInvoiceService;
        this.vacationService = vacationService;
    }
}

