/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.service;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.query.ComChangeQuery;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.common.util.TreeListUtil;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccSubjectTemplateService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetChangePayload;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetPayload;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetSubjectDetailPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetQuery;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetSubjectDetailQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetSubjectDetailService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetChangeVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetSubjectDetailVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectActivityPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.budget.common.functionEnum.BudgetControlType;
import com.elitesland.tw.tw5.server.prd.budget.common.functionEnum.BudgetRiskLevel;
import com.elitesland.tw.tw5.server.prd.budget.convert.BudgetConvert;
import com.elitesland.tw.tw5.server.prd.budget.convert.BudgetSubjectDetailConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetChangeTmpDO;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetChangeTmpRepo;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class BudgetServiceImpl
extends BaseServiceImpl
implements BudgetService {
    private static final Logger log = LoggerFactory.getLogger(BudgetServiceImpl.class);
    private final BudgetRepo budgetRepo;
    private final BudgetDAO budgetDAO;
    private final CacheUtil cacheUtil;
    private final ComChangeService changeService;
    private final AccSubjectTemplateService accSubjectTemplateService;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final PrdSystemRoleService roleService;
    private final PmsProjectService pmsProjectService;
    private final WorkflowUtil workflowUtil;
    private final PmsResourcePlanRoleService pmsResourcePlanRoleService;
    private final BudgetSubjectDetailService budgetSubjectDetailService;
    private final BudgetCommonService budgetCommonService;
    private final FileUtil fileUtil;
    private final TransactionUtilService transactionUtilService;
    private final UdcUtil udcUtil;
    private final SaleConExecConditionService saleConExecConditionService;
    private final PrdMessageConfigService messageConfigService;
    private BigDecimal breakfastScale;
    @Value(value="${tw5.budget.approp_ratio:0.3}")
    private BigDecimal appropRatio;
    private final PrdOrgSyncLogDAO daoLog;
    private final BudgetChangeTmpRepo budgetChangeTmpRepo;
    private final PersonPlanService personPlanService;
    private final PrdOrgOrganizationService organizationService;

    public BudgetVO queryBySource(Long sourceId, String sourceType) {
        if (ObjectUtils.isEmpty((Object)sourceId)) {
            throw TwException.error("", "\u9884\u7b97\u7c7b\u578bID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)sourceType)) {
            throw TwException.error("", "\u9884\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        BudgetVO budgetVO = this.budgetCommonService.querySimpleBySource(sourceId, sourceType);
        if (ObjectUtils.isEmpty((Object)budgetVO)) {
            budgetVO = this.budgetCommonService.initBudget(sourceId, sourceType);
        } else {
            this.budgetCommonService.addProjectInfo(budgetVO);
        }
        this.assemblyBudgetInformation(budgetVO);
        return budgetVO;
    }

    public BudgetVO assemblyBudgetInformation(BudgetVO budgetVO) {
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(budgetVO.getSourceType())) {
            PersonPlanVO res;
            List<String> strings = Arrays.asList(WorkFlowStatusEnum.NOTSUBMIT.getCode(), WorkFlowStatusEnum.APPROVING_WORK.getCode(), WorkFlowStatusEnum.CREATE_WORK.getCode(), WorkFlowStatusEnum.REJECTED_WORK.getCode());
            if ((ObjectUtils.isEmpty((Object)budgetVO.getId()) || strings.contains(budgetVO.getBudgetStatus())) && !ObjectUtils.isEmpty((Object)(res = this.personPlanService.getByObjIdAndPlanType(budgetVO.getSourceId(), Arrays.asList(PersonPlanTypeEnum.PROJECT.getCode()))))) {
                res = (PersonPlanVO)this.udcUtil.translate(res);
                budgetVO.setResourcePlanVO(res);
            }
            List activityVOS = this.pmsProjectActivityService.queryActiveList(budgetVO.getSourceId(), 1);
            activityVOS.forEach(v -> {
                if (ObjectUtils.isEmpty((Object)v.getUsedEqva())) {
                    v.setUsedEqva(BigDecimal.ZERO);
                }
                if (ObjectUtils.isEmpty((Object)v.getUsedEqvaProportion())) {
                    v.setUsedEqvaProportion(BigDecimal.ZERO);
                }
            });
            budgetVO.setActivityVOS(activityVOS);
        }
        if (!ObjectUtils.isEmpty((Object)budgetVO.getSubjectTempId())) {
            AccSubjectTemplateVO accSubjectTemplateVO = this.accSubjectTemplateService.queryByKey(budgetVO.getSubjectTempId());
            budgetVO.setSubjectTempName(accSubjectTemplateVO.getTmplName());
        }
        if (ObjectUtils.isEmpty((Object)budgetVO.getId())) {
            if (!ObjectUtils.isEmpty((Object)budgetVO.getSubjectTempId())) {
                subjectDetailVOS = this.budgetCommonService.queryBySubjectTemplateId(budgetVO.getSourceType(), budgetVO.getSubjectTempId());
                budgetVO.setSubjectDetailVOS(subjectDetailVOS);
            }
        } else {
            subjectDetailVOS = this.budgetSubjectDetailService.queryListDyBudgetId(budgetVO.getId());
            budgetVO.setSubjectDetailVOS(subjectDetailVOS);
            this.opertionOccupyAndUsed(budgetVO, null);
            this.budgetCommonService.countTotalChange(budgetVO);
            budgetVO.setCreator(this.cacheUtil.getUserName(budgetVO.getCreateUserId()));
            budgetVO.setBudgetFilesData(this.fileUtil.getFileDatas(budgetVO.getBudgetFiles()));
        }
        this.generateSubjectTree(budgetVO);
        return budgetVO;
    }

    private void generateSubjectTree(BudgetVO budgetVO) {
        List subjectDetailVOS = budgetVO.getSubjectDetailVOS();
        if (!ObjectUtils.isEmpty((Object)subjectDetailVOS)) {
            subjectDetailVOS.sort(Comparator.comparing(BudgetSubjectDetailVO::getAccId));
            TreeListUtil.toTree((List)subjectDetailVOS);
            budgetVO.setSubjectDetailVOSTree(subjectDetailVOS.stream().filter(v -> v.getAccParentId() == null).collect(Collectors.toList()));
        }
    }

    public Long saveFirstBudget(BudgetPayload payload) {
        Long id;
        BudgetVO budgetVO = this.budgetCommonService.querySimpleBySource(payload.getSourceId(), payload.getSourceType());
        if (budgetVO == null) {
            payload.setBudgetCode(this.generateSeqNum("PMS_BUDGET", new String[0]));
            payload.setVersionNo(Integer.valueOf(0));
            payload.setApplyResId(GlobalUtil.getLoginUserId());
            payload.setOccupyAmt(BigDecimal.ZERO);
            payload.setUsedAmt(BigDecimal.ZERO);
            payload.setOccupyEqva(BigDecimal.ZERO);
            payload.setUsedEqva(BigDecimal.ZERO);
        } else {
            payload.setId(budgetVO.getId());
            payload.setProcInstId(budgetVO.getProcInstId());
            if (!WorkFlowStatusEnum.CREATE_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u9884\u7b97\u4fee\u6539");
            }
        }
        this.checkBudgetData(payload, budgetVO, false);
        try {
            this.transactionUtilService.begin();
            id = this.saveData(payload);
            this.transactionUtilService.commit();
        }
        catch (Exception e) {
            this.transactionUtilService.rollback();
            throw e;
        }
        return id;
    }

    private void submitProc(BudgetPayload payload) {
        boolean outerProjectFlag = this.budgetCommonService.isExternalProject(payload.getPlatType());
        HashMap<String, List> variables = new HashMap<String, List>();
        Object procInstName = "";
        String processDefinitionKey = "";
        if (outerProjectFlag) {
            procInstName = "P03.\u5916\u90e8\u9879\u76ee\u9884\u7b97\u7533\u8bf7\u6d41\u7a0b-" + payload.getSourceName();
            processDefinitionKey = PmsProcDefKey.PMS_BUDGET_APPLY_EXTERNAL.name();
            variables.put("Activity_16c9tju", CollUtil.newArrayList((Object[])new Long[]{payload.getPmoResId()}));
            variables.put("Activity_0wvmy6d", CollUtil.newArrayList((Object[])new Long[]{payload.getDeliUserId()}));
            PrdOrgOrganizationVO deliBu = this.cacheUtil.getOrg(payload.getDeliBuId());
            variables.put("Activity_17d046h", CollUtil.newArrayList((Object[])new Long[]{deliBu.getManageId()}));
            variables.put("Activity_1pmrfrd", this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode()));
            variables.put("Activity_1qwwso3", this.roleService.queryUserIdByRoleCode(RoleEnum.OPERATION_PRESIDENT.getCode()));
        } else {
            procInstName = "P09.\u5185\u90e8\u9879\u76ee\u9884\u7b97\u7533\u8bf7\u6d41\u7a0b-" + payload.getSourceName();
            processDefinitionKey = PmsProcDefKey.PMS_BUDGET_APPLY_INTERNAL.name();
            variables.put("Activity_0w72dta", CollUtil.newArrayList((Object[])new Long[]{payload.getDeliUserId()}));
        }
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)processDefinitionKey, (String)procInstName, (String)("" + payload.getId()), variables), new Long[0]);
        this.updateStatus(payload.getId(), (String)procInstName, processInfo, payload.getControlType());
    }

    private void updateStatus(Long id, String procInstName, ProcessInfo processInfo, String controlType) {
        BudgetPayload payload0 = new BudgetPayload();
        payload0.setId(id);
        payload0.setProcInstName(procInstName);
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(Integer.valueOf(processInfo.getProcInstStatus().ordinal()));
        payload0.setApplyDate(LocalDate.now());
        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload0.setBudgetStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload0.setBudgetStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        }
        this.budgetDAO.updateByKeyDynamic(payload0);
    }

    private static void calculateRecursive(BudgetSubjectDetailPayload node, Map<Long, List<BudgetSubjectDetailPayload>> childrenMap, Map<Long, BigDecimal> parentAmounts) {
        BigDecimal nodeAmount = node.getBudgetAmt();
        parentAmounts.put(node.getAccId(), nodeAmount);
        if (childrenMap.containsKey(node.getAccId())) {
            for (BudgetSubjectDetailPayload child : childrenMap.get(node.getAccId())) {
                BudgetServiceImpl.calculateRecursive(child, childrenMap, parentAmounts);
                nodeAmount = nodeAmount.add(parentAmounts.get(child.getAccId()));
            }
        }
        parentAmounts.put(node.getAccId(), nodeAmount);
    }

    void checkBudgetData(BudgetPayload payload, BudgetVO budgetVO, Boolean changeFlag) {
        this.checkNull(payload);
        this.countAmount(payload);
        if (changeFlag.booleanValue()) {
            payload.setOriginalPlanAmt(budgetVO.getOriginalPlanAmt());
            payload.setOriginalPlanEqva(budgetVO.getOriginalPlanEqva());
            payload.setOriginalPlanEqvaAmt(budgetVO.getOriginalPlanEqvaAmt());
            payload.setOriginalTotalAmt(budgetVO.getOriginalTotalAmt());
            Map activityVOMap = budgetVO.getActivityVOS().stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
            Map detailVOMap = budgetVO.getSubjectDetailVOS().stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
            payload.getActivityPayloads().forEach(actPayload -> {
                PmsProjectActivityVO pmsProjectActivityVO;
                if (actPayload.getId() != null && (pmsProjectActivityVO = (PmsProjectActivityVO)activityVOMap.get(actPayload.getId())) != null) {
                    actPayload.setOriginalPlanEqva(pmsProjectActivityVO.getOriginalPlanEqva());
                }
            });
            payload.getSubjectDetailPayloads().forEach(detailPayload -> {
                BudgetSubjectDetailVO budgetSubjectDetailVO;
                if (detailPayload.getId() != null && (budgetSubjectDetailVO = (BudgetSubjectDetailVO)detailVOMap.get(detailPayload.getId())) != null) {
                    detailPayload.setOriginalAmt(budgetSubjectDetailVO.getOriginalAmt());
                }
            });
        } else {
            payload.setOriginalPlanAmt(payload.getPlanAmt());
            payload.setOriginalPlanEqva(payload.getPlanEqva());
            payload.setOriginalPlanEqvaAmt(payload.getPlanEqvaAmt());
            payload.setOriginalTotalAmt(payload.getTotalAmt());
            payload.getSubjectDetailPayloads().forEach(v -> v.setOriginalAmt(v.getBudgetAmt()));
            payload.getActivityPayloads().forEach(v -> v.setOriginalPlanEqva(v.getPlanEqva()));
        }
        if (BudgetControlType.NO.getCode().equals(payload.getControlType()) || BudgetControlType.FLEXIBILITY.getCode().equals(payload.getControlType())) {
            payload.getSubjectDetailPayloads().forEach(v -> v.setDetailControlFlag(Boolean.valueOf(false)));
        }
    }

    void countAmount(BudgetPayload budgetPayload) {
        List subjectDetailPayloads = budgetPayload.getSubjectDetailPayloads();
        Boolean countSubjectFlag = true;
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(budgetPayload.getSourceType()) && this.budgetCommonService.isExternalNoContractProject(budgetPayload.getPlatType(), budgetPayload.getContractStatus()).booleanValue()) {
            countSubjectFlag = false;
            subjectDetailPayloads.forEach(node -> node.setBudgetAmt(BigDecimal.ZERO));
        }
        BigDecimal planAmt = BigDecimal.ZERO;
        if (countSubjectFlag.booleanValue()) {
            Map childrenMap = subjectDetailPayloads.stream().filter(p -> p.getAccParentId() != null).collect(Collectors.groupingBy(BudgetSubjectDetailPayload::getAccParentId, LinkedHashMap::new, Collectors.toList()));
            subjectDetailPayloads.forEach(node -> {
                if (node.getAccParentId() == null && childrenMap.containsKey(node.getAccId()) || childrenMap.containsKey(node.getAccId()) || ObjectUtils.isEmpty((Object)node.getBudgetAmt())) {
                    node.setBudgetAmt(BigDecimal.ZERO);
                }
            });
            HashMap<Long, BigDecimal> parentAmounts = new HashMap<Long, BigDecimal>();
            for (BudgetSubjectDetailPayload node2 : subjectDetailPayloads) {
                if (node2.getAccParentId() != null) continue;
                BudgetServiceImpl.calculateRecursive(node2, childrenMap, parentAmounts);
            }
            for (BudgetSubjectDetailPayload node2 : subjectDetailPayloads) {
                BigDecimal budgetAmt = (BigDecimal)parentAmounts.get(node2.getAccId());
                node2.setBudgetAmt(budgetAmt);
                node2.setAvailableAmt(budgetAmt);
                if (node2.getAccParentId() != null) continue;
                planAmt = planAmt.add(budgetAmt);
            }
        }
        budgetPayload.setPlanAmt(planAmt);
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(budgetPayload.getSourceType())) {
            List activityPayloads = budgetPayload.getActivityPayloads();
            BigDecimal eqvaBudgetCnt = activityPayloads.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getPlanEqva())).map(PmsProjectActivityPayload::getPlanEqva).reduce(BigDecimal.ZERO, BigDecimal::add);
            budgetPayload.setPlanEqva(eqvaBudgetCnt);
            budgetPayload.setPlanEqvaAmt(eqvaBudgetCnt.multiply(budgetPayload.getEqvaPrice()));
        }
        budgetPayload.setTotalAmt(budgetPayload.getPlanEqvaAmt().add(budgetPayload.getPlanAmt()));
    }

    private void checkNull(BudgetPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getSourceType())) {
            throw TwException.error("", "\u8d39\u7528\u5f52\u5c5e\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSourceId())) {
            throw TwException.error("", "\u8d39\u7528\u5f52\u5c5eID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSourceCode())) {
            throw TwException.error("", "\u8d39\u7528\u5f52\u5c5e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSourceName())) {
            throw TwException.error("", "\u8d39\u7528\u5f52\u5c5e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)payload.getDeliBuId())) {
            throw TwException.error("", "\u4ea4\u4ed8BUID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)payload.getBudgetName())) {
            throw TwException.error("", "\u9884\u7b97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)payload.getControlType())) {
            throw TwException.error("", "\u63a7\u5236\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ObjectUtils.isEmpty((Object)payload.getEqvaPrice())) {
            throw TwException.error("", "\u5f53\u91cf\u9884\u4f30\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSubjectTempId())) {
            throw TwException.error("", "subjectTempId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private Long saveData(BudgetPayload payload) {
        List activityPayloads;
        Long budgetId = payload.getId();
        if (ObjectUtils.isEmpty((Object)budgetId)) {
            BudgetDO entityDo = BudgetConvert.INSTANCE.toDo(payload);
            entityDo = (BudgetDO)this.budgetRepo.save(entityDo);
            budgetId = entityDo.getId();
            payload.setId(budgetId);
        } else {
            this.budgetDAO.updateByKeyDynamic(payload);
        }
        List subjectDetailPayloads = payload.getSubjectDetailPayloads();
        if (!ObjectUtils.isEmpty((Object)subjectDetailPayloads)) {
            Long finalBudgetId = budgetId;
            subjectDetailPayloads.forEach(detail -> detail.setBudgetId(finalBudgetId));
            this.budgetSubjectDetailService.batchSave(subjectDetailPayloads);
        }
        if (!ObjectUtils.isEmpty((Object)(activityPayloads = payload.getActivityPayloads()))) {
            activityPayloads.forEach(v -> v.setRemark(null));
            this.pmsProjectActivityService.batchUpdate(activityPayloads);
        }
        return budgetId;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOPPOAndBUTypeBudget(BudgetPayload payload) {
        payload.setControlType(BudgetControlType.NO.getCode());
        this.checkNull(payload);
        List subjectDetailPayloads = payload.getSubjectDetailPayloads();
        if (ObjectUtils.isEmpty((Object)subjectDetailPayloads)) {
            throw TwException.error("", "\u9884\u7b97\u79d1\u76ee\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ObjectUtils.isEmpty((Object)payload.getPlanEqva())) {
            payload.setPlanEqva(BigDecimal.ZERO);
        }
        if (ObjectUtils.isEmpty((Object)payload.getPlanAmt())) {
            payload.setPlanAmt(BigDecimal.ZERO);
        }
        subjectDetailPayloads.forEach(subjectDetailPayload -> subjectDetailPayload.setDetailControlFlag(Boolean.valueOf(false)));
        payload.setBudgetStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        BudgetVO budgetVO = this.budgetCommonService.querySimpleBySource(payload.getSourceId(), payload.getSourceType());
        if (ObjectUtils.isEmpty((Object)budgetVO)) {
            payload.setBudgetCode(this.generateSeqNum("PMS_BUDGET", new String[0]));
            payload.setVersionNo(Integer.valueOf(0));
            payload.setApplyResId(GlobalUtil.getLoginUserId());
            payload.setOriginalPlanAmt(payload.getPlanAmt());
            payload.setOriginalPlanEqva(payload.getPlanEqva());
            payload.setOriginalTotalAmt(payload.getTotalAmt());
            payload.setOccupyAmt(BigDecimal.ZERO);
            payload.setUsedAmt(BigDecimal.ZERO);
            payload.setOccupyEqva(BigDecimal.ZERO);
            payload.setUsedEqva(BigDecimal.ZERO);
            payload.setTotalAmt(payload.getPlanEqva().multiply(payload.getEqvaPrice()).add(payload.getPlanAmt()));
            payload.setOriginalTotalAmt(payload.getTotalAmt());
        } else {
            payload.setId(budgetVO.getId());
            payload.setOriginalPlanAmt(budgetVO.getOriginalPlanAmt());
            payload.setOriginalPlanEqva(budgetVO.getOriginalPlanEqva());
            payload.setOriginalTotalAmt(budgetVO.getOriginalTotalAmt());
            if (budgetVO.getSubjectTempId() != null && payload.getSubjectTempId() != null && budgetVO.getSubjectTempId().longValue() != payload.getSubjectTempId().longValue()) {
                this.budgetSubjectDetailService.deleteSoftByBudgetId(budgetVO.getId());
            }
        }
        this.saveData(payload);
    }

    public BudgetVO queryBudgetByKey(Long key) {
        BudgetVO budgetVO = this.budgetDAO.queryByKey(key);
        this.budgetCommonService.addProjectInfo(budgetVO);
        this.assemblyBudgetInformation(budgetVO);
        return budgetVO;
    }

    public PagingVO<BudgetVO> queryPaging(BudgetQuery query) {
        PagingVO<BudgetVO> pagingVO = this.budgetDAO.queryPaging(query);
        if (pagingVO.getTotal() > 0L) {
            List subjectTempIds = pagingVO.getRecords().stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getSubjectTempId())).map(BudgetVO::getSubjectTempId).distinct().collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(subjectTempIds)) {
                AccSubjectTemplateQuery subjectTemplateQuery = new AccSubjectTemplateQuery();
                subjectTemplateQuery.setInIds(subjectTempIds);
                List subjectTemplateVOS = this.accSubjectTemplateService.queryListDynamic(subjectTemplateQuery);
                if (!ObjectUtils.isEmpty((Object)subjectTemplateVOS)) {
                    Map<Long, String> subjectTemplateMap = subjectTemplateVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, AccSubjectTemplateVO::getTmplName));
                    pagingVO.getRecords().forEach(v -> {
                        if (!ObjectUtils.isEmpty((Object)v.getSubjectTempId())) {
                            v.setSubjectTempName((String)subjectTemplateMap.get(v.getSubjectTempId()));
                        }
                    });
                }
            }
            ArrayList reasonTypes = new ArrayList();
            ArrayList reasonIds = new ArrayList();
            pagingVO.getRecords().forEach(budgetVO -> {
                budgetVO.setCreator(this.cacheUtil.getUserName(budgetVO.getCreateUserId()));
                if (!reasonTypes.contains(budgetVO.getSourceType())) {
                    reasonTypes.add(budgetVO.getSourceType());
                }
                reasonIds.add(budgetVO.getSourceId());
            });
            List commonVOList = this.budgetCommonService.queryBudgetEqvaAndAmts(reasonTypes, reasonIds);
            pagingVO.getRecords().forEach(budgetVO -> {
                Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(budgetVO.getSourceType()) && vo.getReasonId().equals(budgetVO.getSourceId())).findFirst();
                if (first.isPresent()) {
                    BudgetCommonVO commonVO = first.get();
                    this.opertionOccupyAndUsed((BudgetVO)budgetVO, commonVO);
                } else {
                    budgetVO.setOccupyEqva(BigDecimal.ZERO);
                    budgetVO.setUsedEqva(BigDecimal.ZERO);
                    budgetVO.setOccupyAmt(BigDecimal.ZERO);
                    budgetVO.setUsedAmt(BigDecimal.ZERO);
                }
            });
        }
        return pagingVO;
    }

    void opertionOccupyAndUsed(BudgetVO budgetVO, BudgetCommonVO commonVO) {
        List subjectDetailVOS;
        if (commonVO == null) {
            commonVO = new BudgetCommonVO();
            commonVO.setReasonId(budgetVO.getSourceId());
            commonVO.setReasonType(budgetVO.getSourceType());
            commonVO.setContractId(budgetVO.getContractId());
            commonVO = this.budgetCommonService.queryBudgetEqvaAndAmt(commonVO);
        }
        budgetVO.setOccupyEqva(commonVO.getOccupyEqva());
        budgetVO.setOccupyEqvaAmt(budgetVO.getOccupyEqva().multiply(budgetVO.getEqvaPrice()));
        budgetVO.setUsedEqva(commonVO.getUsedEqva());
        budgetVO.setUsedEqvaAmt(commonVO.getUsedEqva().multiply(budgetVO.getEqvaPrice()));
        budgetVO.setOccupyAmt(commonVO.getOccupyAmt());
        budgetVO.setUsedAmt(commonVO.getUsedAmt());
        budgetVO.setOccupyTotalAmt(budgetVO.getOccupyEqvaAmt().add(budgetVO.getOccupyAmt()));
        budgetVO.setUsedTotalAmt(budgetVO.getUsedEqvaAmt().add(budgetVO.getUsedAmt()));
        if (budgetVO.getPlanEqva().compareTo(BigDecimal.ZERO) > 0) {
            budgetVO.setUsedEqvaProportion(budgetVO.getUsedEqva().multiply(BigDecimal.valueOf(100L)).divide(budgetVO.getPlanEqva(), 4, RoundingMode.HALF_UP));
            BigDecimal add = budgetVO.getUsedEqva().add(budgetVO.getOccupyEqva());
            budgetVO.setTotalEqvaProportion(add.multiply(BigDecimal.valueOf(100L)).divide(budgetVO.getPlanEqva(), 4, RoundingMode.HALF_UP));
        } else {
            budgetVO.setUsedEqvaProportion(BigDecimal.ZERO);
        }
        if (budgetVO.getPlanAmt().compareTo(BigDecimal.ZERO) > 0) {
            budgetVO.setUsedAmtProportion(budgetVO.getUsedAmt().multiply(BigDecimal.valueOf(100L)).divide(budgetVO.getPlanAmt(), 4, RoundingMode.HALF_UP));
        } else {
            budgetVO.setUsedAmtProportion(BigDecimal.ZERO);
        }
        if (budgetVO.getPlanAmt().compareTo(BigDecimal.ZERO) > 0) {
            budgetVO.setUsedTotalProportion(budgetVO.getUsedTotalAmt().multiply(BigDecimal.valueOf(100L)).divide(budgetVO.getTotalAmt(), 4, RoundingMode.HALF_UP));
        } else {
            budgetVO.setUsedTotalProportion(BigDecimal.ZERO);
        }
        List activityVOS = budgetVO.getActivityVOS();
        if (activityVOS != null) {
            Map actOccupyEqvaMap = commonVO.getActOccupyEqvaMap();
            Map actUsedEqvaMap = commonVO.getActUsedEqvaMap();
            activityVOS.forEach(activityVO -> {
                activityVO.setOccupyEqva((BigDecimal)actOccupyEqvaMap.get(activityVO.getId()));
                activityVO.setUsedEqva(actUsedEqvaMap.get(activityVO.getId()) == null ? BigDecimal.ZERO : (BigDecimal)actUsedEqvaMap.get(activityVO.getId()));
                if (activityVO.getPlanEqva() == null || activityVO.getPlanEqva().compareTo(BigDecimal.ZERO) == 0) {
                    activityVO.setUsedEqvaProportion(BigDecimal.ZERO);
                } else {
                    activityVO.setUsedEqvaProportion(activityVO.getUsedEqva().multiply(BigDecimal.valueOf(100L)).divide(activityVO.getPlanEqva(), 4, RoundingMode.HALF_DOWN));
                }
            });
        }
        if ((subjectDetailVOS = budgetVO.getSubjectDetailVOS()) != null) {
            Map accOccupyAmtMap = commonVO.getAccOccupyAmtMap();
            Map accUsedAmtMap = commonVO.getAccUsedAmtMap();
            subjectDetailVOS.forEach(detailVO -> {
                if (detailVO.getAccId() != null) {
                    detailVO.setOccupyAmt((BigDecimal)accOccupyAmtMap.get(detailVO.getAccId()));
                    detailVO.setUsedAmt(accUsedAmtMap.get(detailVO.getAccId()) == null ? BigDecimal.ZERO : (BigDecimal)accUsedAmtMap.get(detailVO.getAccId()));
                    if (detailVO.getBudgetAmt() == null || detailVO.getBudgetAmt().compareTo(BigDecimal.ZERO) == 0) {
                        detailVO.setUsedAmtProportion(BigDecimal.ZERO);
                    } else {
                        detailVO.setUsedAmtProportion(detailVO.getUsedAmt().multiply(BigDecimal.valueOf(100L)).divide(detailVO.getBudgetAmt(), 4, RoundingMode.HALF_DOWN));
                    }
                }
            });
        }
    }

    public List<BudgetVO> queryList(BudgetQuery query) {
        return this.budgetDAO.queryListDynamic(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<BudgetVO> list = this.budgetDAO.queryByKeys(keys);
            for (BudgetVO budgetVO : list) {
                if (WorkFlowStatusEnum.CREATE_WORK.getCode().equals(budgetVO.getBudgetStatus())) continue;
                throw TwException.error("", "\u53ea\u6709\u9884\u7b97\u72b6\u6001\u662f\u662f\u65b0\u5efa\u7684\u624d\u53ef\u4ee5\u5220\u9664\uff01");
            }
            this.budgetDAO.deleteSoft(keys);
        }
    }

    public List<PmsProjectVO> queryProjectNoBudget() {
        BudgetQuery budgetQuery = new BudgetQuery();
        budgetQuery.setSourceType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
        List<BudgetVO> budgetVOS = this.budgetDAO.queryListDynamic(budgetQuery);
        List projectIds = budgetVOS.stream().map(v -> v.getSourceId()).collect(Collectors.toList());
        PmsProjectQuery projectQuery = new PmsProjectQuery();
        projectQuery.setNotInIds(projectIds);
        return this.pmsProjectService.queryListDynamic(projectQuery);
    }

    @Transactional(rollbackFor={Exception.class})
    public void synchronizationTemp(List<Long> keys, Long tmplId) {
        if (ObjectUtils.isEmpty(keys)) {
            throw TwException.error("", "\u9884\u7b97\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)tmplId)) {
            throw TwException.error("", "\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List budgetItems = this.accSubjectTemplateService.queryBudgetItemList(tmplId);
        Map budgetItemMap = budgetItems.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity(), (o, n) -> o));
        BudgetSubjectDetailQuery query = new BudgetSubjectDetailQuery();
        query.setBudgetIds(keys);
        List budgetSubjectDetailVOS = this.budgetSubjectDetailService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty((Object)budgetSubjectDetailVOS)) {
            ArrayList subjectDetailPayloads = new ArrayList();
            Map<Long, List<BudgetSubjectDetailVO>> collect = budgetSubjectDetailVOS.stream().collect(Collectors.groupingBy(BudgetSubjectDetailVO::getBudgetId));
            keys.forEach(budgetId -> {
                Set<Long> newMissBudgetItemIds;
                List twBudgetDetailViews = (List)collect.get(budgetId);
                Map<Long, BudgetSubjectDetailVO> budgetDetailItemMap = twBudgetDetailViews.stream().collect(Collectors.toMap(BudgetSubjectDetailVO::getAccId, Function.identity(), (o, n) -> o));
                Set<Long> missBudgetItemIds = budgetItemMap.keySet().stream().filter(accId -> !budgetDetailItemMap.containsKey(accId)).collect(Collectors.toSet());
                if (!ObjectUtils.isEmpty(missBudgetItemIds) && !ObjectUtils.isEmpty(newMissBudgetItemIds = this.addBudgetItemParent(missBudgetItemIds, budgetItemMap, budgetDetailItemMap))) {
                    newMissBudgetItemIds.stream().forEach(budgetItemId -> {
                        BudgetSubjectDetailPayload detail = new BudgetSubjectDetailPayload();
                        detail.setBudgetId(budgetId);
                        detail.setAccId(budgetItemId);
                        detail.setBudgetAmt(BigDecimal.ZERO);
                        detail.setFeeReleasedAmt(BigDecimal.ZERO);
                        detail.setUsedAmt(BigDecimal.ZERO);
                        detail.setOccupyAmt(BigDecimal.ZERO);
                        detail.setDetailControlFlag(Boolean.valueOf(false));
                        subjectDetailPayloads.add(detail);
                    });
                }
            });
            if (subjectDetailPayloads.size() > 0) {
                this.budgetSubjectDetailService.batchSave(subjectDetailPayloads);
            }
        }
    }

    public BudgetVO queryByKey(Long key) {
        return this.budgetDAO.queryByKey(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveBudgetChange(BudgetChangePayload budgetChangePayload) {
        BudgetPayload budgetPayload = budgetChangePayload.getBudgetPayload();
        if (ObjectUtils.isEmpty((Object)budgetPayload)) {
            throw TwException.error("", "\u9884\u7b97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        String changeDocId = String.valueOf(budgetPayload.getId());
        if (ObjectUtils.isEmpty((Object)changeDocId)) {
            throw TwException.error("", "\u9884\u7b97ID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        BudgetVO budgetVO = this.budgetDAO.queryByKey(budgetPayload.getId());
        if (budgetVO == null) {
            throw TwException.error("", "\u9884\u7b97\u6570\u636e\u4e0d\u5b58\u5728");
        }
        GlobalUtil.getLoginUserId();
        if (!ObjectUtils.isEmpty((Object)budgetChangePayload.getId())) {
            ComChangeVO comChangeVO = this.changeService.queryByKey(budgetChangePayload.getId());
            budgetChangePayload.setApprProcInstId(comChangeVO.getApprProcInstId());
            budgetPayload.setVersionNo(comChangeVO.getVersionNo());
        }
        if (budgetChangePayload.getSubmitFlag().booleanValue() && ObjectUtils.isEmpty((Object)budgetChangePayload.getApprProcInstId())) {
            this.budgetCommonService.checkOnlyOneProc(budgetVO);
        }
        this.assemblyBudgetInformation(budgetVO);
        budgetPayload.setProcInstId(null);
        budgetPayload.setProcDefKey(null);
        budgetPayload.setProcInstName(null);
        budgetPayload.setProcInstStatus(null);
        this.checkBudgetData(budgetPayload, budgetVO, true);
        if (ObjectUtils.isEmpty((Object)budgetChangePayload.getId())) {
            BudgetVO budgetOld = this.queryBySource(budgetPayload.getSourceId(), budgetPayload.getSourceType());
            budgetChangePayload.setId(this.changeService.save(ChangeTypeEnum.BUDGET_CHANGE.getCode(), (Object)budgetOld, (Object)budgetPayload, changeDocId));
        } else {
            this.changeService.update(ChangeTypeEnum.BUDGET_CHANGE.getCode(), changeDocId, (Object)budgetPayload);
        }
    }

    public BudgetChangeVO queryBudgetChangeByKey(Long key) {
        List subjectDetailVOS;
        ComChangeVO comChangeVO = this.changeService.queryByKey(key);
        BudgetChangeVO budgetChangeVO = new BudgetChangeVO();
        budgetChangeVO.setId(comChangeVO.getId());
        budgetChangeVO.setChangeStatus(comChangeVO.getChangeStatus());
        budgetChangeVO.setExtString1(comChangeVO.getExtString1());
        budgetChangeVO.setExtString2(comChangeVO.getExtString2());
        budgetChangeVO.setExtString3(comChangeVO.getExtString3());
        budgetChangeVO.setApprProcInstId(comChangeVO.getApprProcInstId());
        String changeDocId = comChangeVO.getChangeDocId();
        BudgetPayload maxPayload = (BudgetPayload)JSON.parseObject((String)comChangeVO.getChangeContent(), BudgetPayload.class);
        BudgetVO currentVersionBudge = BudgetConvert.INSTANCE.toVo(BudgetConvert.INSTANCE.toDo(maxPayload));
        currentVersionBudge.setCreateUserId(comChangeVO.getCreateUserId());
        currentVersionBudge.setCreator(this.cacheUtil.getUserName(currentVersionBudge.getCreateUserId()));
        currentVersionBudge.setCreateTime(comChangeVO.getCreateTime());
        HashMap<String, BudgetSubjectDetailPayload> subjectInfo = new HashMap<String, BudgetSubjectDetailPayload>();
        HashMap<String, BigDecimal> activityInfo = new HashMap<String, BigDecimal>();
        this.countSubject(maxPayload, subjectInfo);
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(maxPayload.getSourceType())) {
            this.budgetCommonService.addProjectInfo(currentVersionBudge);
            currentVersionBudge.setSaleManUserName(this.cacheUtil.getUserName(currentVersionBudge.getSaleManUserId()));
            if (!ObjectUtils.isEmpty((Object)currentVersionBudge.getSubjectTempId())) {
                AccSubjectTemplateVO accSubjectTemplateVO = this.accSubjectTemplateService.queryByKey(currentVersionBudge.getSubjectTempId());
                currentVersionBudge.setSubjectTempName(accSubjectTemplateVO.getTmplName());
            }
            this.countActivity(maxPayload, activityInfo);
        }
        int currentVersionNo = comChangeVO.getVersionNo();
        int previousVersionNo = currentVersionNo - 1;
        ComChangeVO comChangeVOBefore = this.changeService.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(ChangeTypeEnum.BUDGET_CHANGE.getCode(), comChangeVO.getChangeDocId(), Integer.valueOf(previousVersionNo));
        if (previousVersionNo == 0) {
            List activityVOS;
            BudgetVO previousVersionBudge = (BudgetVO)JSON.parseObject((String)comChangeVOBefore.getChangeContent(), BudgetVO.class);
            List subjectDetailVOS2 = previousVersionBudge.getSubjectDetailVOS();
            if (!ObjectUtils.isEmpty((Object)subjectDetailVOS2)) {
                for (Object vo : subjectDetailVOS2) {
                    subjectInfo.put(vo.getId() + "_" + previousVersionNo, BudgetSubjectDetailConvert.INSTANCE.toPayload((BudgetSubjectDetailVO)vo));
                }
            }
            if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(maxPayload.getSourceType()) && !ObjectUtils.isEmpty((Object)(activityVOS = previousVersionBudge.getActivityVOS()))) {
                for (PmsProjectActivityVO vo : activityVOS) {
                    activityInfo.put(vo.getId() + "_" + previousVersionNo, vo.getPlanEqva() == null ? BigDecimal.ZERO : vo.getPlanEqva());
                }
            }
        } else {
            ComChangeVO comChangeVO0 = this.changeService.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(ChangeTypeEnum.BUDGET_CHANGE.getCode(), comChangeVO.getChangeDocId(), Integer.valueOf(previousVersionNo));
            BudgetPayload minPayload = (BudgetPayload)JSON.parseObject((String)comChangeVO0.getChangeContent(), BudgetPayload.class);
            this.countSubject(minPayload, subjectInfo);
            if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(maxPayload.getSourceType())) {
                this.countActivity(minPayload, activityInfo);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(subjectDetailVOS = this.budgetSubjectDetailService.queryListDyBudgetId(Long.valueOf(changeDocId))))) {
            for (Object vo : subjectDetailVOS) {
                vo.setAfterValue(BigDecimal.ZERO);
                vo.setBeforeValue(BigDecimal.ZERO);
                BudgetSubjectDetailPayload newDetailPayload = (BudgetSubjectDetailPayload)subjectInfo.get(vo.getId() + "_" + currentVersionNo);
                BudgetSubjectDetailPayload oldDetailPayload = (BudgetSubjectDetailPayload)subjectInfo.get(vo.getId() + "_" + previousVersionNo);
                if (oldDetailPayload != null) {
                    if (oldDetailPayload.getBudgetAmt() != null) {
                        vo.setBeforeValue(oldDetailPayload.getBudgetAmt());
                    }
                    vo.setRemark(oldDetailPayload.getRemark());
                }
                if (newDetailPayload != null) {
                    if (newDetailPayload.getBudgetAmt() != null) {
                        vo.setAfterValue(newDetailPayload.getBudgetAmt());
                    }
                    vo.setRemark(newDetailPayload.getRemark());
                }
                vo.setDeltaValue(vo.getAfterValue().subtract(vo.getBeforeValue()));
            }
        }
        currentVersionBudge.setSubjectDetailVOS(subjectDetailVOS);
        this.generateSubjectTree(currentVersionBudge);
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(maxPayload.getSourceType())) {
            List activityVOS = this.pmsProjectActivityService.queryActiveList(maxPayload.getSourceId(), 1);
            if (!ObjectUtils.isEmpty((Object)activityVOS)) {
                Map<Long, String> changeRemarks;
                for (Object vo : activityVOS) {
                    vo.setAfterValue(activityInfo.getOrDefault(vo.getId() + "_" + currentVersionNo, BigDecimal.ZERO));
                    vo.setBeforeValue(activityInfo.getOrDefault(vo.getId() + "_" + previousVersionNo, BigDecimal.ZERO));
                    vo.setDeltaValue(vo.getAfterValue().subtract(vo.getBeforeValue()));
                }
                List activityPayloads = maxPayload.getActivityPayloads();
                if (!ObjectUtils.isEmpty((Object)activityPayloads) && !ObjectUtils.isEmpty(changeRemarks = activityPayloads.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getChangeRemark())).collect(Collectors.toMap(TwCommonPayload::getId, PmsProjectActivityPayload::getChangeRemark)))) {
                    activityVOS.forEach(v -> v.setChangeRemark((String)changeRemarks.get(v.getId())));
                }
            }
            currentVersionBudge.setActivityVOS(activityVOS);
        }
        this.opertionOccupyAndUsed(currentVersionBudge, null);
        this.budgetCommonService.countCurrentChange(currentVersionBudge);
        currentVersionBudge.setBudgetFilesData(this.fileUtil.getFileDatas(currentVersionBudge.getBudgetFiles()));
        budgetChangeVO.setBudgetVO((BudgetVO)this.udcUtil.translate(currentVersionBudge));
        return budgetChangeVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(ProcessStatusChangePayload payload) {
        ComChangeVO comChangeVO;
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_APPLY_EXTERNAL.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_APPLY_INTERNAL.getName())) {
            BudgetVO budgetVO = this.budgetDAO.queryByKey(Long.valueOf(businessKey));
            if (budgetVO != null) {
                BudgetPayload budgetPayload = new BudgetPayload();
                budgetPayload.setId(Long.valueOf(businessKey));
                budgetPayload.setProcInstStatus(Integer.valueOf(procInstStatus.ordinal()));
                switch (procInstStatus) {
                    case NOTSUBMIT: {
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        break;
                    }
                    case INTERRUPT: {
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        budgetPayload.setProcInstId(null);
                        budgetPayload.setNullFields(List.of("procInstId"));
                        break;
                    }
                    case INVALID: {
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        budgetPayload.setProcInstId(null);
                        budgetPayload.setNullFields(List.of("procInstId"));
                        budgetPayload.setDeleteFlag(Integer.valueOf(1));
                        break;
                    }
                    case REJECTED: {
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        break;
                    }
                    case APPROVED: {
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                        break;
                    }
                    case APPROVING: {
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                    }
                }
                this.budgetDAO.updateByKeyDynamic(budgetPayload);
            }
        } else if ((payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_CHANGE.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BGCHANGE_OUT_EQV.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BGCHANGE_OUT_AMT.getName())) && (comChangeVO = this.changeService.queryByKey(Long.valueOf(businessKey))) != null) {
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(comChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            changePayload.setApprProcInstId(comChangeVO.getApprProcInstId());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                }
                case INTERRUPT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setApprProcInstId(null);
                    break;
                }
                case INVALID: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setApprProcInstId(null);
                    changePayload.setDeleteFlag(Integer.valueOf(1));
                    break;
                }
                case REJECTED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                }
                case APPROVED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    String taskDefKey = payload.getCommentInfo().getTaskDefKey();
                    if ("Activity_0ihafu5".equals(taskDefKey)) {
                        BudgetPayload budgetPayload = (BudgetPayload)JSONObject.parseObject((String)comChangeVO.getChangeContent(), BudgetPayload.class);
                        String content = "\u9884\u7b97\u540d\u79f0\u4e3a[" + budgetPayload.getBudgetName() + "] \u7684\u5f53\u91cf\u9884\u7b97\u53d8\u66f4\u8d85\u8fc7\u98ce\u66b4\u533a\uff0c\u8bf7\u77e5\u6089";
                        String title = "\u5916\u90e8\u9879\u76ee\u5f53\u91cf\u9884\u7b97\u53d8\u66f4\u63d0\u9192";
                        this.sendMessage(Long.valueOf(businessKey), title, content);
                    }
                    this.changeSuccess(comChangeVO);
                    break;
                }
            }
            this.changeService.updateWorkFlow(changePayload);
        }
    }

    public String queryBudgetRiskLevel(Long sourceId, String sourceType, Long contractId) {
        BudgetVO budgetVO = this.budgetCommonService.querySimpleBySource(sourceId, sourceType);
        SaleConExecConditionVO saleConExecConditionVO = this.saleConExecConditionService.queryByContractId(contractId);
        BigDecimal economicEquiv = saleConExecConditionVO.getEconomicEquiv() == null ? BigDecimal.ZERO : saleConExecConditionVO.getEconomicEquiv();
        BigDecimal calcCheckProjEquiv = saleConExecConditionVO.getCalcCheckProjEquiv() == null ? BigDecimal.ZERO : saleConExecConditionVO.getCalcCheckProjEquiv();
        BigDecimal planEqva = budgetVO.getPlanEqva() == null ? BigDecimal.ZERO : budgetVO.getPlanEqva();
        BigDecimal minEeqCeq = economicEquiv.min(calcCheckProjEquiv);
        BigDecimal maxEeqCeq = economicEquiv.max(calcCheckProjEquiv);
        String riskLevel = "";
        if (planEqva.compareTo(minEeqCeq) <= 0) {
            riskLevel = BudgetRiskLevel.LEVEL1.getCode();
        }
        if (planEqva.compareTo(minEeqCeq) > 0 && planEqva.compareTo(maxEeqCeq) <= 0) {
            riskLevel = BudgetRiskLevel.LEVEL2.getCode();
        }
        if (planEqva.compareTo(maxEeqCeq) > 0) {
            riskLevel = BudgetRiskLevel.LEVEL3.getCode();
        }
        return riskLevel;
    }

    public void updateByKeyDynamic(BudgetPayload payload) {
        this.budgetDAO.updateByKeyDynamic(payload);
    }

    public void changeSuccess(ComChangeVO comChangeVO) {
        BudgetPayload budgetPayload = (BudgetPayload)JSON.parseObject((String)comChangeVO.getChangeContent(), BudgetPayload.class);
        budgetPayload.setVersionNo(comChangeVO.getVersionNo());
        budgetPayload.setProcInstId(null);
        this.saveData(budgetPayload);
    }

    private void countSubject(BudgetPayload budgetPayload, Map<String, BudgetSubjectDetailPayload> subjectInfo) {
        int version = budgetPayload.getVersionNo();
        List subjectDetailPayloads = budgetPayload.getSubjectDetailPayloads();
        if (!ObjectUtils.isEmpty((Object)subjectDetailPayloads)) {
            for (BudgetSubjectDetailPayload payload : subjectDetailPayloads) {
                subjectInfo.put(payload.getId() + "_" + version, payload);
            }
        }
    }

    private void countActivity(BudgetPayload budgetPayload, Map<String, BigDecimal> activityInfo) {
        int version = budgetPayload.getVersionNo();
        List activityPayloads = budgetPayload.getActivityPayloads();
        if (!ObjectUtils.isEmpty((Object)activityPayloads)) {
            for (PmsProjectActivityPayload payload : activityPayloads) {
                activityInfo.put(payload.getId() + "_" + version, payload.getPlanEqva() == null ? BigDecimal.ZERO : payload.getPlanEqva());
            }
        }
    }

    private Set<Long> addBudgetItemParent(Set<Long> missBudgetItemIds, Map<Long, AccBudgetItemVO> budgetItemMap, Map<Long, BudgetSubjectDetailVO> budgetDetailItemMap) {
        HashSet<Long> newMissBudgetItemIds = new HashSet<Long>(missBudgetItemIds);
        for (Long key : missBudgetItemIds) {
            this.addParent(budgetItemMap, key, newMissBudgetItemIds, budgetDetailItemMap);
        }
        return newMissBudgetItemIds;
    }

    private void addParent(Map<Long, AccBudgetItemVO> budgetItemMap, Long key, Set<Long> newMissBudgetItemIds, Map<Long, BudgetSubjectDetailVO> budgetDetailItemMap) {
        Long parentId = budgetItemMap.get(key).getParentId();
        if (parentId == null) {
            return;
        }
        if (budgetDetailItemMap.get(parentId) == null) {
            newMissBudgetItemIds.add(parentId);
        }
        this.addParent(budgetItemMap, parentId, newMissBudgetItemIds, budgetDetailItemMap);
    }

    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(Integer.valueOf(2));
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.systemMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(Integer.valueOf(0));
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(Integer.valueOf(3));
        ado.setMessageContent(content);
        ArrayList list = new ArrayList();
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_PMO.getCode()));
        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            this.messageConfigService.insert(ado);
        }
    }

    @Transactional
    public void syncBudgetChangeTmp() {
        String syncType = "budget_change";
        LocalDateTime localDateTime = this.daoLog.queryOrgSyncLog(syncType);
        localDateTime = localDateTime == null ? LocalDateTime.of(1970, 1, 1, 0, 0) : localDateTime.minusSeconds(180L);
        ComChangeQuery query = new ComChangeQuery();
        query.setChangeType("BUDGET_CHANGE_APPLY");
        query.setModifyTimeStart(localDateTime);
        List budgetChangeList = this.changeService.changeSearch(query);
        for (ComChangeVO comChangeVO : budgetChangeList) {
            BudgetChangeVO budgetChangeVO = this.queryBudgetChangeByKey(comChangeVO.getId());
            BudgetVO budgetVO = budgetChangeVO.getBudgetVO();
            List activityVOS = budgetVO.getActivityVOS();
            BigDecimal deltaEqva = activityVOS.stream().map(PmsProjectActivityVO::getDeltaValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            List subjectDetailVOS = budgetVO.getSubjectDetailVOS();
            BigDecimal deltaAmt = subjectDetailVOS.stream().map(BudgetSubjectDetailVO::getDeltaValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            BudgetChangeTmpDO budgetChangeTmpSave = new BudgetChangeTmpDO();
            budgetChangeTmpSave.setBudgetId(budgetVO.getId());
            budgetChangeTmpSave.setDeleteEqva(deltaEqva);
            budgetChangeTmpSave.setDeleteAmt(deltaAmt);
            budgetChangeTmpSave.setProjectId(budgetVO.getSourceId());
            budgetChangeTmpSave.setApplyTime(comChangeVO.getCreateTime());
            this.budgetChangeTmpRepo.save((Object)budgetChangeTmpSave);
        }
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        this.daoLog.save(logDO);
    }

    public BudgetServiceImpl(BudgetRepo budgetRepo, BudgetDAO budgetDAO, CacheUtil cacheUtil, ComChangeService changeService, AccSubjectTemplateService accSubjectTemplateService, PmsProjectActivityService pmsProjectActivityService, PrdSystemRoleService roleService, PmsProjectService pmsProjectService, WorkflowUtil workflowUtil, PmsResourcePlanRoleService pmsResourcePlanRoleService, BudgetSubjectDetailService budgetSubjectDetailService, BudgetCommonService budgetCommonService, FileUtil fileUtil, TransactionUtilService transactionUtilService, UdcUtil udcUtil, SaleConExecConditionService saleConExecConditionService, PrdMessageConfigService messageConfigService, PrdOrgSyncLogDAO daoLog, BudgetChangeTmpRepo budgetChangeTmpRepo, PersonPlanService personPlanService, PrdOrgOrganizationService organizationService) {
        this.budgetRepo = budgetRepo;
        this.budgetDAO = budgetDAO;
        this.cacheUtil = cacheUtil;
        this.changeService = changeService;
        this.accSubjectTemplateService = accSubjectTemplateService;
        this.pmsProjectActivityService = pmsProjectActivityService;
        this.roleService = roleService;
        this.pmsProjectService = pmsProjectService;
        this.workflowUtil = workflowUtil;
        this.pmsResourcePlanRoleService = pmsResourcePlanRoleService;
        this.budgetSubjectDetailService = budgetSubjectDetailService;
        this.budgetCommonService = budgetCommonService;
        this.fileUtil = fileUtil;
        this.transactionUtilService = transactionUtilService;
        this.udcUtil = udcUtil;
        this.saleConExecConditionService = saleConExecConditionService;
        this.messageConfigService = messageConfigService;
        this.daoLog = daoLog;
        this.budgetChangeTmpRepo = budgetChangeTmpRepo;
        this.personPlanService = personPlanService;
        this.organizationService = organizationService;
    }
}

