/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaIncomeLogPayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaIncomePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaIncomeQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaIncomeLogService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaIncomeService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaIncomeLogVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaIncomeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalEqvaIncomeConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalEqvaIncomeDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalEqvaIncomeDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalEqvaIncomeRepo;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CalEqvaIncomeServiceImpl
extends BaseServiceImpl
implements CalEqvaIncomeService {
    private static final Logger log = LoggerFactory.getLogger(CalEqvaIncomeServiceImpl.class);
    private final CalEqvaIncomeRepo calEqvaIncomeRepo;
    private final CalEqvaIncomeDAO calEqvaIncomeDAO;
    private final CalEqvaIncomeLogService calEqvaIncomeLogService;

    public PagingVO<CalEqvaIncomeVO> queryPaging(CalEqvaIncomeQuery query) {
        PagingVO<CalEqvaIncomeVO> CalEqvaIncomeVOPagingVO = this.calEqvaIncomeDAO.queryPaging(query);
        if (CalEqvaIncomeVOPagingVO.getTotal() > 0L) {
            CalEqvaIncomeVOPagingVO.getRecords().forEach(this::translateData);
        }
        return CalEqvaIncomeVOPagingVO;
    }

    public List<CalEqvaIncomeVO> queryListDynamic(CalEqvaIncomeQuery query) {
        return this.calEqvaIncomeDAO.queryListDynamic(query);
    }

    public CalEqvaIncomeVO queryByKey(Long key) {
        CalEqvaIncomeVO calEqvaIncomeVO = this.calEqvaIncomeDAO.queryByKey(key);
        this.translateData(calEqvaIncomeVO);
        return calEqvaIncomeVO;
    }

    void translateData(CalEqvaIncomeVO CalEqvaIncomeVO2) {
        if (CalEqvaIncomeVO2.getFinYear() != null && CalEqvaIncomeVO2.getFinPeriod() != null) {
            String finPeriodName = CalEqvaIncomeVO2.getFinYear() + "-" + (CalEqvaIncomeVO2.getFinPeriod() > 9 ? "" + CalEqvaIncomeVO2.getFinPeriod() : "0" + CalEqvaIncomeVO2.getFinPeriod());
            CalEqvaIncomeVO2.setFinPeriodName(finPeriodName);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CalEqvaIncomeVO insertOrUpdate(CalEqvaIncomePayload payload) {
        this.checkDate(payload);
        payload.setLineStatus("1");
        payload.setResType("1");
        CalEqvaIncomeDO entityDo = CalEqvaIncomeConvert.INSTANCE.toDo(payload);
        return CalEqvaIncomeConvert.INSTANCE.toVo((CalEqvaIncomeDO)this.calEqvaIncomeRepo.save(entityDo));
    }

    void checkDate(CalEqvaIncomePayload payload) {
        if (payload.getFinPeriod() != null && payload.getFinYear() == null) {
            throw TwException.error("", "\u671f\u95f4\u5b58\u5728\uff0c\u5e74\u5ea6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)payload.getJobType2()) && !StringUtils.hasText((String)payload.getJobType1())) {
            throw TwException.error("", "\u5de5\u79cd\u5b50\u7c7b\u5b58\u5728\uff0c\u5de5\u79cd\u4e0d\u53ef\u4e3a\u7a7a");
        }
        CalEqvaIncomeQuery CalEqvaIncomeQuery2 = CalEqvaIncomeConvert.INSTANCE.toQuery(payload);
        List<Long> longs = this.calEqvaIncomeDAO.queryCheckData(CalEqvaIncomeQuery2);
        if (!(ObjectUtils.isEmpty(longs) || payload.getId() != null && longs.size() <= 1 && longs.get(0).equals(payload.getId()))) {
            throw TwException.error("", "\u5b58\u5728\u76f8\u540c\u6536\u5165\u914d\u7f6e");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            // empty if block
        }
    }

    public CalEqvaIncomeVO getEqvaSalary(CalEqvaIncomeQuery query) {
        return this.calEqvaIncomeDAO.getEqvaIncomePlus(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public CalEqvaIncomeVO queryExternalEqvaIncome(Long userId) {
        CalEqvaIncomeQuery query = new CalEqvaIncomeQuery();
        query.setResId(userId);
        query.setResType("0");
        query.setLineStatus("1");
        List<CalEqvaIncomeVO> calEqvaIncomeVOS = this.calEqvaIncomeDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(calEqvaIncomeVOS)) {
            return calEqvaIncomeVOS.get(0);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CalEqvaIncomeVO saveExterEqvaIncome(CalEqvaIncomePayload payload) {
        if (payload.getResId() == null) {
            throw TwException.error("", "\u5916\u90e8\u8d44\u6e90id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        CalEqvaIncomeVO calEqvaIncomeVO = null;
        if (payload.getId() == null) {
            CalEqvaIncomeQuery query = new CalEqvaIncomeQuery();
            query.setResId(payload.getResId());
            query.setResType("0");
            List<CalEqvaIncomeVO> calEqvaIncomeVOS = this.calEqvaIncomeDAO.queryListDynamic(query);
            if (!CollectionUtils.isEmpty(calEqvaIncomeVOS)) {
                if (calEqvaIncomeVOS.size() > 1) {
                    throw TwException.error("", "\u5916\u90e8\u8d44\u6e90\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                CalEqvaIncomeVO oldCalEqvaIncomeVO = calEqvaIncomeVOS.get(0);
                payload.setId(oldCalEqvaIncomeVO.getId());
                return this.updateExterEqvaIncome(payload);
            }
            CalEqvaIncomeDO entityDo = CalEqvaIncomeConvert.INSTANCE.toDo(payload);
            entityDo.setVersion(1);
            entityDo.setResType("0");
            calEqvaIncomeVO = CalEqvaIncomeConvert.INSTANCE.toVo((CalEqvaIncomeDO)this.calEqvaIncomeRepo.save(entityDo));
            this.savecalEqvaIncomeLog(calEqvaIncomeVO);
            return calEqvaIncomeVO;
        }
        if (payload.getProjId() != null) return this.updateExterEqvaIncome(payload);
        if (StringUtils.hasText((String)payload.getSettleType())) return this.updateExterEqvaIncome(payload);
        if (StringUtils.hasText((String)payload.getLineStatus())) return this.updateExterEqvaIncome(payload);
        if (payload.getPreeqvaAmt() != null) {
            return this.updateExterEqvaIncome(payload);
        }
        this.calEqvaIncomeDAO.updateByKeyDynamic(payload);
        return this.calEqvaIncomeDAO.queryByKey(payload.getId());
    }

    public CalEqvaIncomeVO updateExterEqvaIncome(CalEqvaIncomePayload payload) {
        CalEqvaIncomeVO calEqvaIncomeVO;
        CalEqvaIncomeLogVO calEqvaIncomeLogVO;
        CalEqvaIncomeDO entity = this.calEqvaIncomeRepo.findById(payload.getId()).orElseGet(CalEqvaIncomeDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CalEqvaIncomeDO entityDo = CalEqvaIncomeConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (entity.getVersion() == null) {
            entity.setVersion(1);
        } else {
            entity.setVersion(entity.getVersion() + 1);
        }
        boolean updateFlag = true;
        if (StringUtils.hasText((String)payload.getLineStatus())) {
            if ("1".equals(payload.getLineStatus())) {
                updateFlag = false;
                entity.setEndDate(null);
            } else if (payload.getEndDate() != null) {
                entity.setEndDate(payload.getEndDate());
            } else {
                entity.setEndDate(LocalDate.now());
            }
        }
        if ((calEqvaIncomeLogVO = this.calEqvaIncomeLogService.queryFirstByRelateId((calEqvaIncomeVO = CalEqvaIncomeConvert.INSTANCE.toVo((CalEqvaIncomeDO)this.calEqvaIncomeRepo.save(entity))).getId())) != null && updateFlag) {
            CalEqvaIncomeLogPayload calEqvaIncomeLogUpdatePayload = new CalEqvaIncomeLogPayload();
            calEqvaIncomeLogUpdatePayload.setId(calEqvaIncomeLogVO.getId());
            calEqvaIncomeLogUpdatePayload.setEndDate(LocalDate.now());
            if (payload.getStartDate() != null && !payload.getStartDate().equals(LocalDate.now()) && !updateFlag) {
                calEqvaIncomeLogUpdatePayload.setEndDate(payload.getStartDate().minusDays(1L));
            }
            this.calEqvaIncomeLogService.update(calEqvaIncomeLogUpdatePayload);
        }
        if (!StringUtils.hasText((String)payload.getLineStatus()) || !updateFlag) {
            this.savecalEqvaIncomeLog(calEqvaIncomeVO);
        }
        return calEqvaIncomeVO;
    }

    public void savecalEqvaIncomeLog(CalEqvaIncomeVO calEqvaIncomeVO) {
        CalEqvaIncomeLogPayload calEqvaIncomeLogPayload = new CalEqvaIncomeLogPayload();
        calEqvaIncomeLogPayload.setRemark(calEqvaIncomeVO.getRemark());
        calEqvaIncomeLogPayload.setPreeqvaAmt(calEqvaIncomeVO.getPreeqvaAmt());
        calEqvaIncomeLogPayload.setLineStatus(calEqvaIncomeVO.getLineStatus());
        calEqvaIncomeLogPayload.setProjId(calEqvaIncomeVO.getProjId());
        calEqvaIncomeLogPayload.setProjName(calEqvaIncomeVO.getProjName());
        calEqvaIncomeLogPayload.setResId(calEqvaIncomeVO.getResId());
        calEqvaIncomeLogPayload.setVersion(calEqvaIncomeVO.getVersion());
        calEqvaIncomeLogPayload.setStartDate(calEqvaIncomeVO.getStartDate());
        calEqvaIncomeLogPayload.setSettleType(calEqvaIncomeVO.getSettleType());
        calEqvaIncomeLogPayload.setRelateId(calEqvaIncomeVO.getId());
        this.calEqvaIncomeLogService.insert(calEqvaIncomeLogPayload);
    }

    public CalEqvaIncomeServiceImpl(CalEqvaIncomeRepo calEqvaIncomeRepo, CalEqvaIncomeDAO calEqvaIncomeDAO, CalEqvaIncomeLogService calEqvaIncomeLogService) {
        this.calEqvaIncomeRepo = calEqvaIncomeRepo;
        this.calEqvaIncomeDAO = calEqvaIncomeDAO;
        this.calEqvaIncomeLogService = calEqvaIncomeLogService;
    }
}

