/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.callback;

import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/REWARD_LEAVE_APPLY/callBack"})
@Transactional
public class RewardLeaveApplyWorkFlowCallBack
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(RewardLeaveApplyWorkFlowCallBack.class);
    private final RewardLeaveApplyDAO rewardLeaveApplyDAO;
    private final RewardLeaveApplyDetailDAO rewardLeaveApplyDetailDAO;
    private final TaskInfoService taskInfoService;
    private final UserVacationService userVacationService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        Long applyId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        RewardLeaveApplyPayload rewardLeaveApplyPayload = new RewardLeaveApplyPayload();
        rewardLeaveApplyPayload.setId(applyId);
        RewardLeaveApplyVO applyVO = this.rewardLeaveApplyDAO.queryByKey(applyId);
        switch (procInstStatus) {
            case NOTSUBMIT: {
                rewardLeaveApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                if (!applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) && !applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) break;
                this.taskInfoService.taskOpertionBySource(TaskSourceTypeEnum.REWARD.getCode(), applyVO.getId(), procInstStatus);
                break;
            }
            case INTERRUPT: {
                rewardLeaveApplyPayload.setProcInstStatus(ProcInstStatus.INTERRUPT);
                break;
            }
            case INVALID: {
                rewardLeaveApplyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                rewardLeaveApplyPayload.setDeleteFlag(Integer.valueOf(1));
                if (!applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) && !applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) break;
                this.taskInfoService.taskOpertionBySource(TaskSourceTypeEnum.REWARD.getCode(), applyVO.getId(), procInstStatus);
                break;
            }
            case REJECTED: {
                rewardLeaveApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                if (!applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) && !applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) break;
                this.taskInfoService.taskOpertionBySource(TaskSourceTypeEnum.REWARD.getCode(), applyVO.getId(), procInstStatus);
                break;
            }
            case APPROVED: {
                RewardLeaveApplyDetailQuery rewardLeaveApplyDetailQuery = new RewardLeaveApplyDetailQuery();
                rewardLeaveApplyDetailQuery.setApplyId(applyId);
                List<RewardLeaveApplyDetailVO> detailVOList = this.rewardLeaveApplyDetailDAO.queryListDynamic(rewardLeaveApplyDetailQuery);
                rewardLeaveApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                rewardLeaveApplyPayload.setApprovedTime(LocalDateTime.now());
                if (applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) || applyVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                    this.taskInfoService.taskOpertionBySource(TaskSourceTypeEnum.REWARD.getCode(), applyVO.getId(), procInstStatus);
                }
                for (RewardLeaveApplyDetailVO detailVO : detailVOList) {
                    UserVacationPayload userVacationPayload = new UserVacationPayload();
                    userVacationPayload.setVacationType("REWARD");
                    userVacationPayload.setExpirationDate(applyVO.getPlanEndDate());
                    userVacationPayload.setTotalDays(detailVO.getDays());
                    userVacationPayload.setReasonId(applyVO.getReasonId());
                    userVacationPayload.setReasonType(applyVO.getReasonType());
                    userVacationPayload.setUserId(detailVO.getUserId());
                    userVacationPayload.setVacationYear(Long.valueOf(applyVO.getPlanEndDate().getYear()));
                    userVacationPayload.setTotalDays(detailVO.getDays());
                    userVacationPayload.setStartDate(applyVO.getPlanStartDate());
                    userVacationPayload.setEndDate(applyVO.getPlanEndDate());
                    userVacationPayload.setUsedDays(BigDecimal.ZERO);
                    this.userVacationService.saveRewardLeave(userVacationPayload);
                }
                break;
            }
            case APPROVING: {
                rewardLeaveApplyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
            }
        }
        this.rewardLeaveApplyDAO.updateByKeyDynamic(rewardLeaveApplyPayload);
        return WorkflowResult.success(null);
    }

    public RewardLeaveApplyWorkFlowCallBack(RewardLeaveApplyDAO rewardLeaveApplyDAO, RewardLeaveApplyDetailDAO rewardLeaveApplyDetailDAO, TaskInfoService taskInfoService, UserVacationService userVacationService) {
        this.rewardLeaveApplyDAO = rewardLeaveApplyDAO;
        this.rewardLeaveApplyDetailDAO = rewardLeaveApplyDetailDAO;
        this.taskInfoService = taskInfoService;
        this.userVacationService = userVacationService;
    }
}

