/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceNormalPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceOtherPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRecordPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRemarkPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRulePayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceNormalQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceOtherQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRuleQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceNormalDateSpecialService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceNormalService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceOtherService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRecordService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRemarkService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRuleService;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceLogVO;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceResVO;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceRuleVO;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceVO;
import com.elitesland.tw.tw5.api.prd.my.vo.MobttendanceSiteVO;
import com.elitesland.tw.tw5.api.prd.my.vo.ResAttendanceOtherVO;
import com.elitesland.tw.tw5.api.prd.my.vo.ResAttendanceVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRuleVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceTimeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TwAttendAnceSpecilDate;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.common.util.GeodesyUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceNormalConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceOtherConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceRecordConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceRuleConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceNormalDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceNormalTimeDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceRuleDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceNormalDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceRuleDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceNormalDateRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceRuleRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TAttendanceRuleServiceImpl
extends BaseServiceImpl
implements TAttendanceRuleService {
    private static final Logger log = LoggerFactory.getLogger(TAttendanceRuleServiceImpl.class);
    private final TAttendanceRuleRepo tAttendanceRuleRepo;
    private final TAttendanceRuleDAO tAttendanceRuleDAO;
    private final TAttendanceNormalDateRepo tAttendanceNormalDateRepo;
    private final VacationService vacationService;
    private final TAttendanceNormalDateSpecialService tAttendanceNormalDateSpecialService;
    private final TAttendanceNormalTimeDAO tAttendanceNormalTimeDAO;
    private final TAttendanceOtherService attendanceOtherService;
    private final TAttendanceNormalService attendanceNormalService;
    private final TAttendanceRecordService attendanceRecordService;
    private final TAttendanceNormalDAO attendanceNormalDAO;
    private final UdcUtil udcUtil;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final TAttendanceRemarkService tAttendanceRemarkService;
    private final GeodesyUtil geodesyUtil;

    public PagingVO<TAttendanceRuleVO> queryPaging(TAttendanceRuleQuery query) {
        return this.tAttendanceRuleDAO.queryPaging(query);
    }

    public List<TAttendanceRuleVO> queryListDynamic(TAttendanceRuleQuery query) {
        return this.tAttendanceRuleDAO.queryListDynamic(query);
    }

    public TAttendanceRuleVO queryByKey(Long key) {
        TAttendanceRuleDO entity = this.tAttendanceRuleRepo.findById(key).orElseGet(TAttendanceRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TAttendanceRuleVO vo = TAttendanceRuleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TAttendanceRuleVO insert(TAttendanceRulePayload payload) {
        TAttendanceRuleDO entityDo = TAttendanceRuleConvert.INSTANCE.toDo(payload);
        return TAttendanceRuleConvert.INSTANCE.toVo((TAttendanceRuleDO)((Object)this.tAttendanceRuleRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public TAttendanceRuleVO update(TAttendanceRulePayload payload) {
        TAttendanceRuleDO entity = this.tAttendanceRuleRepo.findById(payload.getId()).orElseGet(TAttendanceRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TAttendanceRuleDO entityDo = TAttendanceRuleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TAttendanceRuleConvert.INSTANCE.toVo((TAttendanceRuleDO)((Object)this.tAttendanceRuleRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TAttendanceRulePayload payload) {
        TAttendanceRuleDO entity = this.tAttendanceRuleRepo.findById(payload.getId()).orElseGet(TAttendanceRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tAttendanceRuleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tAttendanceRuleDAO.deleteSoft(keys);
        }
    }

    public List<MobAttendanceRuleVO> getAttendanceRule(long resId) {
        List<Long> attendanceRuleIds = this.tAttendanceRuleDAO.queryRulesByResId(resId);
        List<MobAttendanceRuleVO> mobs = this.tAttendanceRuleDAO.getAttendanceRuleByResId(attendanceRuleIds);
        for (MobAttendanceRuleVO mobAttendanceRuleVO : mobs) {
            mobAttendanceRuleVO.setAttendanceTimeStart(this.tAttendanceRuleDAO.minAttendanceTimeStart(mobAttendanceRuleVO.getAttendanceRuleId()));
            mobAttendanceRuleVO.setAttendanceTimeEnd(this.tAttendanceRuleDAO.maxAttendanceTimeEnd(mobAttendanceRuleVO.getAttendanceRuleId()));
        }
        String str = this.tAttendanceRuleDAO.cmsContents();
        String otherStr = this.tAttendanceRuleDAO.cmsOtherContents();
        for (MobAttendanceRuleVO info : mobs) {
            List<MobttendanceSiteVO> mobttendanceSiteVOList = this.tAttendanceRuleDAO.getAttendanceRuleSite(info.getAttendanceRuleId());
            info.setSites(mobttendanceSiteVOList);
            if (str != null && !ObjectUtils.isEmpty((Object)str)) {
                info.setCmsContents(str);
            }
            if (otherStr == null || ObjectUtils.isEmpty((Object)otherStr)) continue;
            info.setCmsOtherContents(otherStr);
        }
        return this.isAttendance(mobs);
    }

    public List<TAttendanceRuleVO> getAttendanceRule() {
        TAttendanceRuleQuery query = new TAttendanceRuleQuery();
        List<TAttendanceRuleVO> tAttendanceRuleVOS = this.tAttendanceRuleDAO.queryListDynamic(query);
        return tAttendanceRuleVOS;
    }

    public List<MobAttendanceRuleVO> isAttendance(List<MobAttendanceRuleVO> list) {
        for (MobAttendanceRuleVO info : list) {
            LocalDate today = LocalDate.now();
            double i = this.vacationService.selectWorkHoursByDate(today, today);
            Long t = this.tAttendanceNormalDateSpecialService.isAttendAnceSpecial(today);
            String[][] strArray = new String[][]{{"MONDAY", "ATTENDANCE_DATE_MON"}, {"TUESDAY", "ATTENDANCE_DATE_TUE"}, {"WEDNESDAY", "ATTENDANCE_DATE_WED"}, {"THURSDAY", "ATTENDANCE_DATE_THU"}, {"FRIDAY", "ATTENDANCE_DATE_FRI"}, {"SATURDAY", "ATTENDANCE_DATE_SAT"}, {"SUNDAY", "ATTENDANCE_DATE_SUN"}};
            LocalDate currentDate = LocalDate.now();
            String k = String.valueOf(currentDate.getDayOfWeek());
            for (int o = 0; o < strArray.length; ++o) {
                if (!k.equals(strArray[o][0])) continue;
                k = strArray[o][1];
                break;
            }
            Long ruleId = info.getAttendanceRuleId();
            int n = this.tAttendanceNormalDateRepo.isAttendAnceRule(ruleId, k);
            if (i > 0.0) {
                info.setTodayAttendance(Boolean.valueOf(true));
                info = this.selectTimeView(info, k);
            }
            if (i <= 0.0) {
                if (t > 0L) {
                    Long specilId = this.tAttendanceNormalDateSpecialService.selectAttendAnceSpectalId(info.getAttendanceRuleId(), today);
                    if (specilId != null && specilId.intValue() > 0) {
                        TwAttendAnceSpecilDate specilDate = this.tAttendanceNormalTimeDAO.selectAttendAnceSpectalDate(info.getAttendanceRuleId(), specilId);
                        info.setAttendanceTimeStart(specilDate.getAttendanceTimeStart());
                        info.setAttendanceTimeEnd(specilDate.getAttendanceTimeEnd());
                    }
                    info.setTodayAttendance(Boolean.valueOf(true));
                } else {
                    info.setTodayAttendance(Boolean.valueOf(false));
                }
            }
            if (i != 0.0 || t != 0L) continue;
            info.setTodayAttendance(Boolean.valueOf(false));
        }
        return list;
    }

    public MobAttendanceRuleVO selectTimeView(MobAttendanceRuleVO info, String k) {
        TAttendanceTimeVO timeView = this.tAttendanceNormalDateRepo.selectPunchLimitTime(info.getAttendanceRuleId(), k);
        if (timeView != null) {
            if (timeView.getAttendanceTimeStart() != null) {
                info.setAttendanceTimeStart(timeView.getAttendanceTimeStart());
            }
            if (timeView.getAttendanceTimeEnd() != null) {
                info.setAttendanceTimeEnd(timeView.getAttendanceTimeEnd());
            }
            if (timeView.getPunchLimitStartTime() != null) {
                info.setPunchLimitStartTime(timeView.getPunchLimitStartTime());
            }
            if (timeView.getPunchLimitEndTime() != null) {
                info.setPunchLimitEndTime(timeView.getPunchLimitEndTime());
            }
        }
        return info;
    }

    @Transactional
    public int resAttendanceInfo(MobAttendanceVO payload) {
        LocalDate attendanceDate = LocalDate.now();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        String currentTime = sdf.format(new Date());
        MobAttendanceVO attendanceInfo = new MobAttendanceVO();
        if (!ObjectUtils.isEmpty((Object)payload.getAttendanceRuleId())) {
            attendanceInfo = this.tAttendanceRuleDAO.selectAttTime(payload.getAttendanceRuleId());
        }
        if (!ObjectUtils.isEmpty((Object)attendanceInfo)) {
            LocalTime time;
            if (attendanceInfo.getPunchLimitStartTime() != null) {
                payload.setPunchLimitStartTime(attendanceInfo.getPunchLimitStartTime());
            }
            if (attendanceInfo.getPunchLimitEndTime() != null) {
                payload.setPunchLimitEndTime(attendanceInfo.getPunchLimitEndTime());
            }
            if (attendanceInfo.getPunchLimitStartSecondTime() != null) {
                payload.setPunchLimitStartSecondTime(attendanceInfo.getPunchLimitStartSecondTime());
            }
            if (attendanceInfo.getPunchLimitEndSecondTime() != null) {
                payload.setPunchLimitEndSecondTime(attendanceInfo.getPunchLimitEndSecondTime());
            }
            DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm");
            if (attendanceInfo.getAllowLateTimeNum() > 0) {
                time = LocalTime.parse(payload.getAttendanceTimeStart(), df);
                time = time.plusMinutes(attendanceInfo.getAllowLateTimeNum());
                payload.setAttendanceTimeStart(time.toString());
            }
            if (attendanceInfo.getAllowLeaveTimeNum() > 0) {
                time = LocalTime.parse(payload.getAttendanceTimeEnd(), df);
                time = time.plusMinutes(-attendanceInfo.getAllowLeaveTimeNum());
                payload.setAttendanceTimeEnd(time.toString());
            }
            payload.setAllowLateTimeNum(attendanceInfo.getAllowLateTimeNum());
            payload.setAllowLeaveTimeNum(attendanceInfo.getAllowLeaveTimeNum());
        }
        if (payload.getAttendanceRuleId() == null) {
            TAttendanceOtherPayload attendanceOther = TAttendanceOtherConvert.INSTANCE.mobAttendanceToPayload(payload);
            attendanceOther.setAttendanceDate(LocalDate.now());
            attendanceOther.setAttendanceTimeStart(currentTime);
            attendanceOther.setAttendanceRemark(payload.getSpecialReason());
            this.attendanceOtherService.insert(attendanceOther);
        } else {
            TAttendanceNormalVO attendanceNormalVO;
            TAttendanceNormalPayload attendanceNormal = TAttendanceNormalConvert.INSTANCE.mobAttendanceToPayload(payload);
            String attendanceLocation = payload.getAttendanceLocation();
            if (StringUtils.hasText((String)attendanceLocation)) {
                String cityFromAddress = this.getCityFromAddress(attendanceLocation);
                attendanceNormal.setAttendanceCity(cityFromAddress);
            }
            attendanceNormal.setAttendanceDate(LocalDate.now());
            if (payload.getOffWork().booleanValue()) {
                attendanceNormal.setAttendanceTimeEnd(currentTime);
            } else {
                attendanceNormal.setAttendanceTimeStart(currentTime);
                attendanceNormal.setAttendanceTimeEnd(null);
            }
            List attendanceIds = this.attendanceNormalService.findResAttendanceLog(payload.getAttendanceResId(), attendanceDate);
            if (!(attendanceIds != null && attendanceIds.size() != 0 || payload.getOffWork().booleanValue())) {
                attendanceNormalVO = this.attendanceNormalService.insert(attendanceNormal);
                payload.setAttendanceNormalId(attendanceNormalVO.getId());
            }
            if (attendanceIds.size() > 0 && payload.getOffWork().booleanValue()) {
                Long attendanceId = (Long)attendanceIds.get(0);
                attendanceNormal.setId(attendanceId);
                if (payload.getOffWork().booleanValue()) {
                    String startTime = this.attendanceNormalService.findStartTime(attendanceNormal.getId());
                    attendanceNormal.setAttendanceTimeStart(startTime);
                }
                String status = this.attendanceNormalService.findResAttendanceStatus(attendanceNormal.getId());
                String result = this.attendanceNormalService.findResAttendanceResult(attendanceNormal.getId());
                if ("LEAVE_EARLY".equals(status) && "NORMAL".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("NORMAL");
                    attendanceNormal.setAttendanceResult("YES");
                }
                if ("BE_LATE".equals(status) && "LEAVE_EARLY".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("BELATE_LEAVEEARLY");
                    if ("NO".equals(result)) {
                        attendanceNormal.setAttendanceResult(result);
                    }
                } else if ("BE_LATE".equals(status)) {
                    attendanceNormal.setAttendanceResultDetail(status);
                    if ("NO".equals(result)) {
                        attendanceNormal.setAttendanceResult(result);
                    }
                }
                if ("LEAVE_MISSINGCARD".equals(status) && "LEAVE_EARLY".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("LEAVE_MISSINGCARD");
                    if ("NO".equals(result)) {
                        attendanceNormal.setAttendanceResult(result);
                    }
                }
                if ("LEAVE_MISSINGCARD".equals(status) && "NORMAL".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("MISSING_CARD");
                    if ("NO".equals(result)) {
                        attendanceNormal.setAttendanceResult(result);
                    }
                }
                if ("MISSING_CARD".equals(status)) {
                    attendanceNormal.setAttendanceResultDetail(status);
                    if ("NO".equals(result)) {
                        attendanceNormal.setAttendanceResult(result);
                    }
                }
                this.attendanceNormalService.update(attendanceNormal);
            }
            if ((attendanceIds == null || attendanceIds.size() == 0) && payload.getOffWork().booleanValue()) {
                attendanceNormal.setAttendanceTimeStart(null);
                if ("LEAVE_EARLY".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("LEAVE_MISSINGCARD");
                }
                if ("NORMAL".equals(attendanceNormal.getAttendanceResultDetail())) {
                    attendanceNormal.setAttendanceResultDetail("MISSING_CARD");
                }
                attendanceNormal.setAttendanceResult("NO");
                attendanceNormalVO = this.attendanceNormalService.insert(attendanceNormal);
                payload.setAttendanceNormalId(attendanceNormalVO.getId());
            }
        }
        TAttendanceRecordPayload attendanceRecord = TAttendanceRecordConvert.INSTANCE.mobAttendanceToPayload(payload);
        attendanceRecord.setAttendanceDate(attendanceDate);
        if (payload.getOffWork() != null && payload.getOffWork().booleanValue()) {
            attendanceRecord.setAttendanceTimeStart(null);
            attendanceRecord.setAttendanceTimeEnd(currentTime);
        } else {
            attendanceRecord.setAttendanceTimeStart(currentTime);
            attendanceRecord.setAttendanceTimeEnd(null);
        }
        this.attendanceRecordService.insert(attendanceRecord);
        return 1;
    }

    private String getCityFromAddress(String address) {
        String[] addressParts;
        Object city = "";
        for (String part : addressParts = address.split("[\u7701,\u81ea\u6cbb\u533a,\u5e02,\u533a,\u53bf]")) {
            if (!part.endsWith("\u5e02")) continue;
            city = part + "\u5e02";
            break;
        }
        return city;
    }

    public List<MobAttendanceLogVO> resAttendanceLog(long resId, LocalDate attendanceDateStart, LocalDate attendanceDateEnd) {
        List attendanceOtherList = this.attendanceOtherService.getAttendanceResOther(Long.valueOf(resId), attendanceDateStart, attendanceDateEnd);
        List mobAttendanceLogs = this.attendanceNormalService.getResAttendanceLog(Long.valueOf(resId), attendanceDateStart, attendanceDateEnd);
        if (ObjectUtils.isEmpty((Object)mobAttendanceLogs) && ObjectUtils.isEmpty((Object)attendanceOtherList)) {
            return null;
        }
        for (MobAttendanceLogVO mobAttendanceLogVO : mobAttendanceLogs) {
            TAttendanceNormalVO attendanceNormalVO = this.attendanceNormalDAO.getAttendanceNormal(mobAttendanceLogVO.getId());
            mobAttendanceLogVO.setNormalViews(attendanceNormalVO);
        }
        Map<LocalDate, List<MobAttendanceLogVO>> attendanceLogMap = mobAttendanceLogs.stream().collect(Collectors.groupingBy(MobAttendanceLogVO::getAttendanceDate));
        Map<LocalDate, List<ResAttendanceOtherVO>> attendanceLogOtherMap = attendanceOtherList.stream().collect(Collectors.groupingBy(ResAttendanceOtherVO::getAttendanceDate));
        ArrayList<MobAttendanceLogVO> resAttendanceLogList = new ArrayList<MobAttendanceLogVO>();
        String timeStr = TimeUtil.dateToYmd(attendanceDateStart);
        String yearMonth = timeStr.substring(0, timeStr.lastIndexOf("-"));
        int month = attendanceDateStart.getMonth().getValue();
        int year = attendanceDateStart.getYear();
        Calendar time = Calendar.getInstance();
        time.set(1, year);
        time.set(2, month - 1);
        time.set(5, 1);
        time.roll(5, -1);
        int maxDate = time.get(5);
        for (int i = 1; i <= maxDate; ++i) {
            boolean other;
            String data = yearMonth + "-" + (Serializable)(i < 10 ? "0" + i : Integer.valueOf(i));
            LocalDate key = TimeUtil.dateFromYmd(data);
            List<MobAttendanceLogVO> normalLogs = attendanceLogMap.get(key);
            List<ResAttendanceOtherVO> otherLogs = attendanceLogOtherMap.get(key);
            boolean normal = normalLogs != null && normalLogs.size() > 0;
            boolean bl = other = otherLogs != null && otherLogs.size() > 0;
            if (!normal && !other) continue;
            MobAttendanceLogVO log = new MobAttendanceLogVO();
            log.setAttendanceDate(key);
            log.setResId(Long.valueOf(resId));
            if (normal) {
                TAttendanceNormalVO normalView = normalLogs.get(0).getNormalViews();
                int frozen = normalLogs.get(0).getFrozen();
                normalView = (TAttendanceNormalVO)this.udcUtil.translate(normalView);
                log.setNormalViews(normalView);
                log.setFrozen(frozen);
            } else {
                log.setNormalViews(new TAttendanceNormalVO());
            }
            if (other) {
                log.setOtherViews(otherLogs);
            } else {
                log.setOtherViews(new ArrayList());
            }
            resAttendanceLogList.add(log);
        }
        return resAttendanceLogList;
    }

    public int resAttendanceReason(TAttendanceNormalVO attendanceNormalVO) {
        TAttendanceNormalPayload tAttendanceNormalPayload = new TAttendanceNormalPayload();
        tAttendanceNormalPayload.setId(attendanceNormalVO.getId());
        tAttendanceNormalPayload.setSpecialReason(attendanceNormalVO.getSpecialReason());
        this.attendanceNormalService.updateByKeyDynamic(tAttendanceNormalPayload);
        TAttendanceNormalVO view = this.attendanceNormalService.queryByKey(attendanceNormalVO.getId());
        TAttendanceRemarkPayload remarkPayload = new TAttendanceRemarkPayload();
        remarkPayload.setAttendanceResId(view.getAttendanceResId());
        remarkPayload.setTAttendanceNormalId(attendanceNormalVO.getId());
        remarkPayload.setAttendanceDate(view.getAttendanceDate().toString());
        remarkPayload.setAttendanceAbnormalDesc(view.getSpecialReason());
        remarkPayload.setApplyDatetime(LocalDateTime.now());
        PrdOrgEmployeeRefVO refVO = this.prdOrgEmployeeService.queryEmployeeRef(view.getAttendanceResId());
        remarkPayload.setReportToResId(refVO.getParentId());
        remarkPayload.setApprovalResult("APPROVAL_PENDING");
        Long remarkId = this.tAttendanceRemarkService.queryByAttendanceNormalId(attendanceNormalVO.getId());
        if (ObjectUtils.isEmpty((Object)remarkId)) {
            this.tAttendanceRemarkService.insert(remarkPayload);
        } else {
            TAttendanceRemarkPayload updatePayload = new TAttendanceRemarkPayload();
            updatePayload.setId(remarkId);
            updatePayload.setApprovalResult("APPROVAL_PENDING");
            updatePayload.setAttendanceAbnormalDesc(remarkPayload.getAttendanceAbnormalDesc());
            this.tAttendanceRemarkService.updateByKeyDynamic(updatePayload);
        }
        return 1;
    }

    public MobAttendanceResVO getResAttendanceInfo(Long resId, LocalDate attendanceDate) {
        TAttendanceNormalQuery query = new TAttendanceNormalQuery();
        MobAttendanceResVO mobAttendanceResVO = new MobAttendanceResVO();
        query.setAttendanceResId(resId);
        query.setAttendanceDate(attendanceDate);
        List<TAttendanceNormalVO> attendanceNormalVOList = this.attendanceNormalDAO.queryListDynamic(query);
        ResAttendanceVO resAttendanceVO = new ResAttendanceVO();
        if (!ObjectUtils.isEmpty(attendanceNormalVOList)) {
            TAttendanceNormalVO attendanceNormalVO = attendanceNormalVOList.get(0);
            mobAttendanceResVO.setResId(attendanceNormalVO.getAttendanceResId());
            mobAttendanceResVO.setAttendanceDate(attendanceNormalVO.getAttendanceDate());
            mobAttendanceResVO.setAttendanceTimeStart(this.tAttendanceRuleDAO.minAttendanceTimeStartLatest(attendanceNormalVO.getAttendanceRuleId()));
            mobAttendanceResVO.setAttendanceTimeEnd(this.tAttendanceRuleDAO.maxAttendanceTimeEndEarliest(attendanceNormalVO.getAttendanceRuleId()));
            resAttendanceVO.setAttendanceLocation(attendanceNormalVO.getAttendanceLocation());
            resAttendanceVO.setAttendanceRuleId(attendanceNormalVO.getAttendanceRuleId());
            resAttendanceVO.setAttendanceResult(attendanceNormalVO.getAttendanceResult());
            resAttendanceVO.setAttendanceResultDetail(attendanceNormalVO.getAttendanceResultDetail());
            resAttendanceVO.setAttendanceTimeStart(attendanceNormalVO.getAttendanceTimeStart());
            resAttendanceVO.setAttendanceTimeEnd(attendanceNormalVO.getAttendanceTimeEnd());
            resAttendanceVO.setAttendanceRuleId(attendanceNormalVO.getAttendanceRuleId());
            mobAttendanceResVO.setAttendanceInfo(resAttendanceVO);
            TAttendanceOtherQuery otherQuery = new TAttendanceOtherQuery();
            otherQuery.setAttendanceDate(attendanceDate);
            otherQuery.setAttendanceResId(resId);
            List otherVOList = this.attendanceOtherService.queryListDynamic(otherQuery);
            mobAttendanceResVO.setAttendanceOther(otherVOList);
        }
        return mobAttendanceResVO;
    }

    @Transactional
    public void updateAttendanceInformation(LocalDate date) {
        List<Long> ruleIdList = this.getAttendanceRule().stream().map(BaseViewModel::getId).toList();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("HH:mm");
        boolean todayAttendance = true;
        double i = this.vacationService.selectWorkHoursByDate(date, date);
        Long t = this.tAttendanceNormalDateSpecialService.isAttendAnceSpecial(date);
        if (i > 0.0) {
            todayAttendance = true;
        }
        if (i <= 0.0) {
            todayAttendance = t > 0L;
        }
        if (i == 0.0 && t == 0L) {
            todayAttendance = false;
        }
        if (todayAttendance) {
            ruleIdList.stream().forEach(id -> {
                List<Long> resIds = this.tAttendanceRuleDAO.queryResByRuleId((Long)id);
                TAttendanceNormalQuery attendanceNormalQuery = new TAttendanceNormalQuery();
                attendanceNormalQuery.setAttendanceRuleId(id);
                attendanceNormalQuery.setAttendanceDate(date);
                List<TAttendanceNormalVO> attendanceNormalVOList = this.attendanceNormalDAO.queryListDynamic(attendanceNormalQuery);
                List<Long> resIds1 = attendanceNormalVOList.stream().map(TAttendanceNormalVO::getAttendanceResId).toList();
                resIds.removeAll(resIds1);
                for (int x = 0; x < resIds.size(); ++x) {
                    Long resId = resIds.get(x);
                    this.insertAbsenteeism(date, resId, (Long)id);
                }
                String startRule = this.tAttendanceRuleDAO.minAttendanceTimeStartLatest((Long)id);
                if (StringUtils.isEmpty((Object)startRule)) {
                    return;
                }
                int minA = Math.toIntExact(this.tAttendanceRuleDAO.allowLateMin((Long)id));
                String concat = date.toString().concat(" ").concat(startRule);
                String start = LocalDateTime.parse(concat, dateTimeFormatter).plusMinutes(minA).format(pattern);
                LocalTime allowStartTime = LocalTime.parse(start, pattern);
                String endRule = this.tAttendanceRuleDAO.maxAttendanceTimeEndEarliest((Long)id);
                int minL = Math.toIntExact(this.tAttendanceRuleDAO.allowLeaveMin((Long)id));
                String concatEnd = date.toString().concat(" ").concat(endRule);
                String end = LocalDateTime.parse(concatEnd, dateTimeFormatter).minusMinutes(minL).format(pattern);
                LocalTime allowEndTime = LocalTime.parse(end, pattern);
                for (TAttendanceNormalVO attendanceNormalVO : attendanceNormalVOList) {
                    LocalTime startTime = null;
                    LocalTime endTime = null;
                    if (!ObjectUtils.isEmpty((Object)attendanceNormalVO.getAttendanceTimeStart())) {
                        startTime = LocalTime.parse(attendanceNormalVO.getAttendanceTimeStart(), pattern);
                    }
                    if (!ObjectUtils.isEmpty((Object)attendanceNormalVO.getAttendanceTimeEnd())) {
                        endTime = LocalTime.parse(attendanceNormalVO.getAttendanceTimeEnd(), pattern);
                    }
                    TAttendanceNormalDO normalDO = (TAttendanceNormalDO)((Object)((Object)TAttendanceNormalConvert.INSTANCE.toEntity(attendanceNormalVO)));
                    normalDO.setId(attendanceNormalVO.getId());
                    if (startTime != null && endTime != null) {
                        if (startTime.compareTo(allowStartTime) <= 0 && endTime.compareTo(allowEndTime) >= 0) {
                            normalDO.setAttendanceResult("YES");
                            normalDO.setAttendanceResultDetail("NORMAL");
                        }
                        if (startTime.isAfter(allowStartTime) && startTime.isBefore(allowEndTime) && endTime.isAfter(allowEndTime)) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("BE_LATE");
                        }
                        if (startTime.compareTo(allowStartTime) <= 0 && endTime.isAfter(allowStartTime) && endTime.isBefore(allowEndTime)) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("LEAVE_EARLY");
                        }
                        if (startTime.isAfter(allowStartTime) && endTime.isBefore(endTime)) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("BELATE_LEAVEEARLY");
                        }
                    }
                    if (startTime == null && endTime != null && endTime.compareTo(allowEndTime) >= 0) {
                        normalDO.setAttendanceResult("NO");
                        normalDO.setAttendanceResultDetail("MISSING_CARD");
                    }
                    if (startTime != null && endTime == null) {
                        if (startTime.compareTo(allowStartTime) <= 0) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("MISSING_CARD");
                        }
                        if (startTime.isAfter(allowStartTime)) {
                            normalDO.setAttendanceResult("NO");
                            normalDO.setAttendanceResultDetail("BELATE_MISSINGCARD");
                        }
                    }
                    this.attendanceNormalDAO.save(normalDO);
                }
            });
        }
    }

    @Transactional
    public void insertAbsenteeism(LocalDate date, Long resId, Long ruleId) {
        TAttendanceNormalDO attendanceNormalDO = new TAttendanceNormalDO();
        attendanceNormalDO.setAttendanceRuleId(ruleId);
        attendanceNormalDO.setAttendanceResId(resId);
        attendanceNormalDO.setAttendanceResult("NO");
        attendanceNormalDO.setAttendanceResultDetail("ABSENTEEISM");
        attendanceNormalDO.setAttendanceDate(date);
        this.attendanceNormalDAO.save(attendanceNormalDO);
    }

    public TAttendanceRuleServiceImpl(TAttendanceRuleRepo tAttendanceRuleRepo, TAttendanceRuleDAO tAttendanceRuleDAO, TAttendanceNormalDateRepo tAttendanceNormalDateRepo, VacationService vacationService, TAttendanceNormalDateSpecialService tAttendanceNormalDateSpecialService, TAttendanceNormalTimeDAO tAttendanceNormalTimeDAO, TAttendanceOtherService attendanceOtherService, TAttendanceNormalService attendanceNormalService, TAttendanceRecordService attendanceRecordService, TAttendanceNormalDAO attendanceNormalDAO, UdcUtil udcUtil, CacheUtil cacheUtil, PrdOrgEmployeeService prdOrgEmployeeService, TAttendanceRemarkService tAttendanceRemarkService, GeodesyUtil geodesyUtil) {
        this.tAttendanceRuleRepo = tAttendanceRuleRepo;
        this.tAttendanceRuleDAO = tAttendanceRuleDAO;
        this.tAttendanceNormalDateRepo = tAttendanceNormalDateRepo;
        this.vacationService = vacationService;
        this.tAttendanceNormalDateSpecialService = tAttendanceNormalDateSpecialService;
        this.tAttendanceNormalTimeDAO = tAttendanceNormalTimeDAO;
        this.attendanceOtherService = attendanceOtherService;
        this.attendanceNormalService = attendanceNormalService;
        this.attendanceRecordService = attendanceRecordService;
        this.attendanceNormalDAO = attendanceNormalDAO;
        this.udcUtil = udcUtil;
        this.cacheUtil = cacheUtil;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.tAttendanceRemarkService = tAttendanceRemarkService;
        this.geodesyUtil = geodesyUtil;
    }
}

