/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.common.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAccountPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookAccountPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAccountQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BookAccountConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookAccountDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookAccountDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookAccountRepo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BookAccountServiceImpl
extends BaseServiceImpl
implements BookAccountService {
    private static final Logger log = LoggerFactory.getLogger(BookAccountServiceImpl.class);
    private final BookAccountRepo bookAccountRepo;
    private final BookAccountDAO bookAccountDAO;
    private final PrdSystemLogService logService;

    public PagingVO<BookAccountVO> queryPaging(BookAccountQuery query) {
        return this.bookAccountDAO.queryPaging(query);
    }

    public List<BookAccountVO> queryListDynamic(BookAccountQuery query) {
        return this.bookAccountDAO.queryListDynamic(query);
    }

    public BookAccountVO queryByKey(Long key) {
        BookAccountVO bookAccountVO = this.bookAccountDAO.queryByKey(key);
        if (bookAccountVO == null) {
            throw TwException.error("", "\u94f6\u884c\u8d26\u53f7\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        return bookAccountVO;
    }

    public BookAccountVO queryDefaultByBookId(Long bookId) {
        return this.bookAccountDAO.queryDefaultByBookId(bookId);
    }

    public List<PrdAbAccountPayload> queryTwBookAccountListByBookId(List<Long> bookIdList) {
        return this.bookAccountDAO.queryTwBookAccountListByBookId(bookIdList);
    }

    @Transactional(rollbackFor={Exception.class})
    public BookAccountVO insert(BookAccountPayload payload, Boolean logFlag) {
        BookAccountDO defaultDO = this.bookAccountRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
        if (payload.getIsDefault() != null && payload.getIsDefault().booleanValue() && defaultDO != null) {
            defaultDO.setIsDefault(false);
            this.bookAccountRepo.save(defaultDO);
        }
        if (defaultDO == null) {
            payload.setIsDefault(Boolean.valueOf(true));
        }
        BookAccountDO entityDo = BookAccountConvert.INSTANCE.toDo(payload);
        if (logFlag.booleanValue() && payload.getPartnerId() != null) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u65b0\u589e\u4e86\u4e00\u6761\u8d26\u6237\u4fe1\u606f");
        }
        BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(payload.getBookId()));
        return BookAccountConvert.INSTANCE.toVo((BookAccountDO)this.bookAccountRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchInsert(List<BookAccountVO> voList) {
        if (!CollectionUtils.isEmpty(voList)) {
            List collect = voList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                voList.get(0).setIsDefault(Boolean.valueOf(true));
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "\u94f6\u884c\u4fe1\u606f\u4e0d\u80fd\u63d0\u4ea4\u591a\u6761\u9ed8\u8ba4\u7684\u6570\u636e");
                }
                List collectFalse = voList.stream().filter(p -> p.getIsDefault() == null || p.getIsDefault() == false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                }
            }
            List bookAccountDOS = BookAccountConvert.INSTANCE.toEntity(voList);
            this.bookAccountRepo.saveAll(bookAccountDOS);
            BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(voList.get(0).getBookId()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BookAccountVO update(BookAccountPayload payload, Boolean logFlag) {
        BookAccountDO defaultDO;
        BookAccountDO entity = this.bookAccountRepo.findById(payload.getId()).orElseGet(BookAccountDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (payload.getIsDefault() != null && payload.getIsDefault().booleanValue() && (defaultDO = this.bookAccountRepo.findByBookIdAndIsDefault(payload.getBookId(), true)) != null && !defaultDO.getId().equals(payload.getId())) {
            defaultDO.setIsDefault(false);
            this.bookAccountRepo.save(defaultDO);
        }
        BookAccountDO entityDo = BookAccountConvert.INSTANCE.toDo(payload);
        entityDo.setId(entity.getId());
        BookAccountDO save = (BookAccountDO)this.bookAccountRepo.save(entityDo);
        if (logFlag.booleanValue() && null != payload.getPartnerId()) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u4fee\u6539\u4e86\u4e00\u6761\u8d26\u6237\u4fe1\u606f");
        }
        BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(entity.getBookId()));
        return BookAccountConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys, Long bookId, Long partnerId, Boolean logFlag) {
        if (!keys.isEmpty()) {
            this.bookAccountDAO.deleteSoft(keys);
            List<BookAccountDO> bookAccountDOS = this.bookAccountDAO.queryByBookId(bookId);
            if (bookAccountDOS != null && bookAccountDOS.size() == 1) {
                BookAccountDO bookAccountDO = bookAccountDOS.get(0);
                bookAccountDO.setIsDefault(true);
                this.bookAccountRepo.save(bookAccountDO);
            }
            if (logFlag.booleanValue()) {
                this.logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u5220\u9664\u4e86 " + keys.size() + " \u6761\u8d26\u6237\u4fe1\u606f");
            }
            BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }
    }

    @Transactional
    public void deleteSoftBykeys(List<Long> keys, Long bookId, Long partnerId) {
        if (!keys.isEmpty()) {
            this.bookAccountDAO.deleteSoft(keys);
            this.logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u5220\u9664\u4e86 " + keys.size() + " \u6761\u94f6\u884c\u8d26\u6237\u4fe1\u606f");
            BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }
    }

    public Long count(BookAccountQuery query) {
        return this.bookAccountDAO.count(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByBookId(Long bookId) {
        this.bookAccountDAO.deleteByBookId(bookId);
        BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
    }

    public Map<Long, List<BookAccountVO>> queryByBookIdList(List<Long> bookIdList) {
        List<BookAccountVO> bookAccountVOS = this.bookAccountDAO.queryByBookIdList(bookIdList);
        return bookAccountVOS.stream().collect(Collectors.groupingBy(BookAccountVO::getBookId));
    }

    public Map<Long, List<BookAccountVO>> queryByIdList(List<Long> idList) {
        List<BookAccountVO> bookAccountVOS = this.bookAccountDAO.queryByIdList(idList);
        return bookAccountVOS.stream().collect(Collectors.groupingBy(BaseViewModel::getId));
    }

    public List<BookAccountVO> queryInternalList(BookAccountQuery bookAccountQuery) {
        return this.bookAccountDAO.queryInternalList(bookAccountQuery);
    }

    @Transactional
    public void saveAll(List<BookAccountVO> bookAccountVOList) {
        this.bookAccountDAO.saveAll(BookAccountConvert.INSTANCE.toEntity(bookAccountVOList));
    }

    public BookAccountServiceImpl(BookAccountRepo bookAccountRepo, BookAccountDAO bookAccountDAO, PrdSystemLogService logService) {
        this.bookAccountRepo = bookAccountRepo;
        this.bookAccountDAO = bookAccountDAO;
        this.logService = logService;
    }
}

