/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.personcare.service;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

class MarkImageUtils {
    private static final Logger log = LoggerFactory.getLogger(MarkImageUtils.class);

    private MarkImageUtils() {
    }

    public static File markMain(String username) {
        String[] source = new String[10];
        for (int i = 0; i < source.length; ++i) {
            source[i] = File.separator + "src" + File.separator + "birthday_background_images" + File.separator + "template" + i + ".jpg";
        }
        String imageName = username + "_image";
        String imageType = "jpg";
        String[] waterMarkWord = new String[]{"   \u613f\u4f60\u53bb\u5f80\u4e4b\u5730\u7686\u4e3a\u70ed\u571f\uff0c\u613f\u4f60\u6240\u9047\u4e4b\u4eba\u7686\u4e3a\u631a\u53cb\u3002\u751f\u65e5\u5feb\u4e50\uff01", "   \u613f\u4ee5\u540e\u6709\u4eba\u966a\u4f60\u70e7\u70e4\u706b\u9505\u7116\u5927\u867e\uff0c\u4e5f\u6709\u4eba\u966a\u4f60\u7d20\u7434\u8c03\u5f26\u54c1\u9999\u8336\u3002\u751f\u65e5\u5feb\u4e50\uff01", "   \u613f\u65f6\u5149\u80fd\u7f13\uff0c\u613f\u6545\u4eba\u4e0d\u6563\uff1b\u613f\u4f60\u60e6\u5ff5\u7684\u4eba\u80fd\u548c\u4f60\u9053\u665a\u5b89\uff0c\u613f\u4f60\u72ec\u95ef\u7684\u65e5\u5b50\u91cc\u4e0d\u89c9\u5f97\u5b64\u5355\u3002\u751f\u65e5\u5feb\u4e50\uff01", "   \u613f\u4f60\u4e09\u51ac\u6696\uff0c\u613f\u4f60\u6625\u4e0d\u5bd2\uff0c\u613f\u4f60\u5929\u9ed1\u6709\u706f\uff0c\u4e0b\u96e8\u6709\u4f1e\uff0c\u613f\u4f60\u4e00\u8def\u4e0a\uff0c\u6709\u826f\u4eba\u76f8\u4f34\u3002\u751f\u65e5\u5feb\u4e50\uff01", "   \u76f8\u89c1\u4ea6\u65e0\u4e8b\uff0c\u522b\u540e\u5e38\u5fc6\u541b\u3002\u751f\u65e5\u5feb\u4e50\uff01", "   \u83ab\u5931\u83ab\u5fd8\uff0c\u4ed9\u5bff\u6052\u660c\uff1b\u4e0d\u79bb\u4e0d\u5f03\uff0c\u82b3\u9f84\u6c38\u7ee7\u3002\u751f\u65e5\u5feb\u4e50\uff01", "   \u795d\u4f60\u5403\u996d\u5927\u9c7c\u5927\u8089\uff1b\u5531\u6b4c\u5e05\u54e5\u7f8e\u5973\u4f34\u594f;\u65e5\u8fdb\u6597\u91d1\u4e0d\u591f\uff1b\u6562\u4e0e\u4e4c\u9f9f\u6bd4\u957f\u5bff\u3002\u751f\u65e5\u5feb\u4e50\uff01", "   \u5f69\u8679\u662f\u592a\u9633\u7684\u82b1\u8fb9\uff0c\u88c5\u9970\u7740\u6674\u6717\u7684\u6bcf\u4e00\u5929\uff0c\u661f\u661f\u662f\u6708\u4eae\u7684\u857e\u4e1d\uff0c\u70b9\u7f00\u7740\u6d6a\u6f2b\u7684\u6bcf\u4e00\u665a\uff0c\u5feb\u4e50\u662f\u751f\u65e5\u7684\u795d\u798f\uff0c\u5e0c\u671b\u4f60\u62e5\u6709\u7f8e\u5999\u7684\u6bcf\u4e00\u523b\uff0c\u4eb2\u7231\u7684\uff0c\u751f\u65e5\u5feb\u4e50\uff01", "   \u613f\u4f60\u6b64\u540e\u6bcf\u4e00\u5929\uff0c\u773c\u91cc\u662f\u9633\u5149\uff0c\u7b11\u91cc\u662f\u5766\u8361\u3002\u751f\u65e5\u5feb\u4e50\uff01", "   \u613f\u4f60\u6210\u4e3a\u81ea\u5df1\u559c\u6b22\u7684\u6837\u5b50\uff1a\u4e0d\u62b1\u6028\uff0c\u4e0d\u5c06\u5c31\uff0c\u6709\u81ea\u7531\uff0c\u6709\u5149\u8292\u3002\u751f\u65e5\u5feb\u4e50\uff01", "   \u613f\u4f60\u6709\u524d\u8fdb\u4e00\u5bf8\u7684\u52c7\u6c14\uff0c\u4ea6\u6709\u540e\u9000\u4e00\u5c3a\u7684\u4ece\u5bb9\u3002\u751f\u65e5\u5feb\u4e50\uff01", "   \u53cb\u8c0a\u5176\u5b9e\u662f\u4e00\u79cd\u611f\u89c9\uff1a\u4e00\u79cd\u7a81\u7136\u5c31\u4f1a\u60f3\u8d77\u7684\u611f\u89c9\uff0c\u4e00\u79cd\u7ecf\u5e38\u7275\u6302\u7684\u611f\u89c9\uff0c\u4e00\u79cd\u5931\u843d\u53ef\u4ee5\u4f9d\u9760\u7684\u611f\u89c9\uff0c\u4e00\u79cd\u5feb\u4e50\u53ef\u4ee5\u5206\u4eab\u7684\u611f\u89c9\u3002\u670b\u53cb\uff0c\u795d\u798f\u4f60\u751f\u65e5\u5feb\u4e50\uff01"};
        Integer degree = 0;
        File result = MarkImageUtils.markImageBySingleText(username, source, imageName, imageType, waterMarkWord, new Color(0.0f, 0.0f, 0.0f, 0.8f), 20, degree);
        return result;
    }

    private static File markImageBySingleText(String username, String[] source, String imageName, String imageType, String[] waterMarkWord, Color color, int fontSize, Integer degree) {
        try {
            int wordIndex = (int)(Math.random() * (double)waterMarkWord.length);
            int imgIndex = (int)(Math.random() * (double)source.length);
            File file = ResourceUtils.getFile((String)("classpath:static" + source[imgIndex]));
            if (!file.isFile()) {
                return null;
            }
            BufferedImage img = ImageIO.read(file);
            int width = ((Image)img).getWidth(null);
            int height = ((Image)img).getHeight(null);
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics2D g = bi.createGraphics();
            g.drawImage(img, 0, 0, width, height, null);
            String typefaceRoute = "classpath:static" + File.separator + "ttf" + File.separator + "WenQuanYi Micro Hei Mono.ttf";
            File fontFile = ResourceUtils.getFile((String)typefaceRoute);
            Font customFont = Font.createFont(0, fontFile);
            Font font = customFont.deriveFont(0, fontSize);
            g.setColor(color);
            g.setFont(font);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)bi.getWidth() / 2.0, (double)bi.getHeight() / 2.0);
            }
            Object text = "\u4eb2\u7231\u7684";
            text = (String)text + username + "\uff1a";
            MarkImageUtils.drawStringWithFontStyleLineFeed(g, (String)text, 150, height / 2 - 50, width - 280);
            MarkImageUtils.drawStringWithFontStyleLineFeed(g, waterMarkWord[wordIndex], 150, height / 2, width - 280);
            g.dispose();
            File temp2 = File.createTempFile(imageName, "." + imageType, null);
            ImageIO.write((RenderedImage)bi, imageType, temp2);
            return temp2;
        }
        catch (Exception e) {
            log.error("\u751f\u65e5\u795d\u798f\u6a21\u677f\u6dfb\u52a0\u6587\u5b57\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static int getStringLength(Graphics g, String waterMarkWord) {
        char[] strcha = waterMarkWord.toCharArray();
        int strWidth = g.getFontMetrics().charsWidth(strcha, 0, waterMarkWord.length());
        log.debug("\u6c34\u5370\u6587\u5b57\u603b\u5bbd\u5ea6:" + strWidth);
        return strWidth;
    }

    private static int getCharLen(char c, Graphics g) {
        return g.getFontMetrics(g.getFont()).charWidth(c);
    }

    private static int getStringHeight(Graphics g) {
        int height = g.getFontMetrics().getHeight();
        log.debug("\u5b57\u7b26\u9ad8\u5ea6:" + height);
        return height;
    }

    private static void drawStringWithFontStyleLineFeed(Graphics g, String waterMarkWord, int locX, int locY, int width) {
        int strContentWidth = MarkImageUtils.getStringLength(g, waterMarkWord);
        int imgWidth = width;
        log.debug("\u6bcf\u884c\u6587\u5b57|\u56fe\u7247\u5bbd\u5ea6:" + imgWidth);
        int strHeight = MarkImageUtils.getStringHeight(g);
        int strLength = waterMarkWord.length();
        log.debug("\u5b57\u7b26\u4e32\u603b\u4e2a\u6570:" + strLength);
        int tempX = locX;
        int tempY = locY;
        if (strContentWidth > imgWidth) {
            int tempCharLen = 0;
            int tempLineLen = 0;
            int basicCharLen = MarkImageUtils.getCharLen('\u4e00', g);
            StringBuilder stringBuffer = new StringBuilder();
            for (int i = 0; i < waterMarkWord.length(); ++i) {
                char tempChar = waterMarkWord.charAt(i);
                tempCharLen = MarkImageUtils.getCharLen(tempChar, g);
                if (tempLineLen + 2 * basicCharLen >= imgWidth) {
                    g.drawString(stringBuffer.toString(), tempX, tempY);
                    stringBuffer.delete(0, stringBuffer.length());
                    tempY = tempY + strHeight + 30;
                    tempLineLen = 0;
                }
                tempLineLen += tempCharLen;
                stringBuffer.append(tempChar);
            }
            g.drawString(stringBuffer.toString(), tempX, tempY);
        } else {
            g.drawString(waterMarkWord, tempX, tempY);
        }
    }
}

