package com.elitesland.tw.tw5.server.common.change.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.change.payload.PrdSystemBusinessChangePayload;
import com.elitesland.tw.tw5.api.common.change.query.PrdSystemBusinessChangeQuery;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;
import com.elitesland.tw.tw5.server.common.change.entity.PrdSystemBusinessChangeDO;
import com.elitesland.tw.tw5.server.common.change.entity.QPrdSystemBusinessChangeDO;
import com.elitesland.tw.tw5.server.common.change.repo.PrdSystemBusinessChangeRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/8/29 - 8:44
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemBusinessChangeDAO {
    private final JPAQueryFactory jpaQueryFactory;

    private final PrdSystemBusinessChangeRepo repo;
    private final QPrdSystemBusinessChangeDO qdo = QPrdSystemBusinessChangeDO.prdSystemBusinessChangeDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemBusinessChangeVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemBusinessChangeVO.class,
                qdo.id,
                qdo.changeType,
                qdo.changeDocId,
                qdo.changeContent,
                qdo.versionContent,
                qdo.versionNo,
                qdo.versionStatus,
                qdo.createUserId,
                qdo.createTime,
                qdo.procInstId
        )).from(qdo);
    }


    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemBusinessChangeVO> getJpaQueryWhere(PrdSystemBusinessChangeQuery query) {
        JPAQuery<PrdSystemBusinessChangeVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getChangeType())) {
            jpaQuery.where(qdo.changeType.eq(query.getChangeType()));
        }
        if (!ObjectUtils.isEmpty(query.getChangeDocId())) {
            jpaQuery.where(qdo.changeDocId.eq(query.getChangeDocId()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionNo())) {
            jpaQuery.where(qdo.versionNo.eq(query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty(query.getParentChangeDocId())) {
            jpaQuery.where(qdo.parentChangeDocId.eq(query.getParentChangeDocId()));
        }
        if (!ObjectUtils.isEmpty(query.getParentChangeType())) {
            jpaQuery.where(qdo.parentChangeType.eq(query.getParentChangeType()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionStatus())) {
            jpaQuery.where(qdo.versionStatus.eq(query.getVersionStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionNo())) {
            jpaQuery.where(qdo.versionNo.eq(query.getVersionNo()));
        }

        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemBusinessChangeVO queryByKey(Long id) {
        JPAQuery<PrdSystemBusinessChangeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdSystemBusinessChangeVO> queryListDynamic(PrdSystemBusinessChangeQuery query) {
        JPAQuery<PrdSystemBusinessChangeVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemBusinessChangeVO> queryPaging(PrdSystemBusinessChangeQuery query) {
        JPAQuery<PrdSystemBusinessChangeVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdSystemBusinessChangeVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdSystemBusinessChangeVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }


    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemBusinessChangeDO save(PrdSystemBusinessChangeDO ado) {
        return repo.save(ado);
    }


    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdSystemBusinessChangeDO> saveAll(List<PrdSystemBusinessChangeDO> dos) {
        return repo.saveAll(dos);
    }


    /**
     * 按主键动态修改
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PrdSystemBusinessChangePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getChangeType() != null) {
            update.set(qdo.changeType, payload.getChangeType());
        }
        if (payload.getChangeDocId() != null) {
            update.set(qdo.changeDocId, payload.getChangeDocId());
        }
        if (payload.getChangeContent() != null) {
            update.set(qdo.changeContent, payload.getChangeContent());
        }
        if (payload.getVersionContent() != null) {
            update.set(qdo.versionContent, payload.getVersionContent());
        }
//        if (payload.getVersionNo() != null) {
//            update.set(qdo.versionNo, payload.getVersionNo());
//        }
        if (payload.getVersionStatus() != null) {
            update.set(qdo.versionStatus, payload.getVersionStatus());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("versionContent")) {
                update.setNull(qdo.versionContent);
            }
            if (nullFields.contains("changeContent")) {
                update.setNull(qdo.changeContent);
            }
            if (nullFields.contains("versionNo")) {
                update.setNull(qdo.versionNo);
            }
            if (nullFields.contains("versionStatus")) {
                update.setNull(qdo.versionStatus);
            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 根据类型、单据id查询
     *
     * @param changType 类型,docId 单据id
     * @return 结果
     */
    public PrdSystemBusinessChangeVO queryByChangeTypeAndDocId(String changType, String docId) {
        JPAQuery<PrdSystemBusinessChangeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.changeType.eq(changType));
        jpaQuery.where(qdo.changeDocId.eq(docId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdo.versionStatus.eq(1));
//        jpaQuery.orderBy(qdo.versionNo.desc());
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据类型、单据id修改内容
     *
     * @param payload
     * @return 结果
     */
    @Transactional
    public void updateVersionContent(PrdSystemBusinessChangePayload payload) {
        jpaQueryFactory.update(qdo)
                .set(qdo.versionContent, payload.getVersionContent())
                .set(qdo.changeContent, payload.getChangeContent())
                .where(qdo.changeType.eq(payload.getChangeType()))
                .where(qdo.changeDocId.eq(payload.getChangeDocId()))
                .where(qdo.versionStatus.eq(1))
                .where(qdo.deleteFlag.eq(0))
                .execute();
    }

    /**
     * 根据类型、单据id修改内容
     *
     * @param changeType
     * @param docId
     * @param versionStatus
     * @return 结果
     */
    @Transactional
    public void updateVersionStatus(String changeType, String docId, Integer versionStatus) {
        jpaQueryFactory.update(qdo)
                .set(qdo.versionStatus, versionStatus)
                .where(qdo.changeType.eq(changeType))
                .where(qdo.changeDocId.eq(docId))
                .where(qdo.deleteFlag.eq(0))
                .execute();
    }

    /**
     * 根据类型、单据id修改内容
     *
     * @param changeType
     * @param docId
     * @param procInstId
     * @return 结果
     */
    @Transactional
    public PrdSystemBusinessChangeVO getChangeLog(String changeType, String docId, String procInstId) {
        JPAQuery<PrdSystemBusinessChangeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.changeType.eq(changeType));
        jpaQuery.where(qdo.changeDocId.eq(docId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdo.procInstId.eq(procInstId));
        return jpaQuery.fetchFirst();
    }

}
