package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeRefQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeRefService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeRefVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 易稻壳yeedoc通用文档类型配置与业务关系表
 *
 * @author duwh
 * @date 2023-12-08
 */
@Api(tags = "易稻壳yeedoc通用文档类型配置与业务关系表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/businessDocTypeRef")
@Slf4j
public class BusinessDocTypeRefController {

private final BusinessDocTypeRefService businessDocTypeRefService;
    //
    // /**
    //  * 易稻壳yeedoc通用文档类型配置与业务关系表-新增
    //  *
    //  * @param payload 有效载荷
    //  * @return {@link TwOutputUtil}
    //  */
    // @PostMapping
    // @ApiOperation("易稻壳yeedoc通用文档类型配置与业务关系表-新增")
    // public TwOutputUtil<BusinessDocTypeRefVO> insert(@RequestBody BusinessDocTypeRefPayload payload){
    //      return TwOutputUtil.ok(businessDocTypeRefService.insert(payload));
    // }
    //
    // /**
    //  * 易稻壳yeedoc通用文档类型配置与业务关系表-更新
    //  *
    //  * @param payload 有效载荷
    //  * @return {@link TwOutputUtil}
    //  */
    // @PutMapping
    // @ApiOperation("易稻壳yeedoc通用文档类型配置与业务关系表-更新")
    // public TwOutputUtil<BusinessDocTypeRefVO> update(@RequestBody BusinessDocTypeRefPayload payload){
    //     return TwOutputUtil.ok(businessDocTypeRefService.update(payload));
    // }
    //
    // /**
    //  * 易稻壳yeedoc通用文档类型配置与业务关系表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
    //  *
    //  * @param payload 有效载荷
    //  * @return {@link TwOutputUtil}
    //  */
    // @PutMapping("update")
    // @ApiOperation("易稻壳yeedoc通用文档类型配置与业务关系表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    // public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessDocTypeRefPayload payload){
    //     return TwOutputUtil.ok(businessDocTypeRefService.updateByKeyDynamic(payload));
    // }

    /**
     * 易稻壳yeedoc通用文档类型配置与业务关系表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("易稻壳yeedoc通用文档类型配置与业务关系表-主键查询")
    public TwOutputUtil<BusinessDocTypeRefVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessDocTypeRefService.queryByKey(key));
    }

    /**
     * 易稻壳yeedoc通用文档类型配置与业务关系表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("易稻壳yeedoc通用文档类型配置与业务关系表-分页")
    public TwOutputUtil<PagingVO<BusinessDocTypeRefVO>> paging(BusinessDocTypeRefQuery query) {
        return TwOutputUtil.ok(businessDocTypeRefService.queryPaging(query));
    }

    /**
     * 易稻壳yeedoc通用文档类型配置与业务关系表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("易稻壳yeedoc通用文档类型配置与业务关系表-查询列表")
    public TwOutputUtil<List<BusinessDocTypeRefVO>> queryList(BusinessDocTypeRefQuery query) {
        return TwOutputUtil.ok(businessDocTypeRefService.queryListDynamic(query));
    }

    // /**
    //  * 易稻壳yeedoc通用文档类型配置与业务关系表-删除
    //  *
    //  * @param keys 主键id
    //  * @return result
    //  */
    // @DeleteMapping("/deleteSoft")
    // @ApiOperation("易稻壳yeedoc通用文档类型配置与业务关系表-删除")
    // public TwOutputUtil deleteSoft(Long[] keys) {
    //      businessDocTypeRefService.deleteSoft(Arrays.asList(keys));
    //     return TwOutputUtil.ok();
    // }

}

