package com.elitesland.tw.tw5.server.prd.acc.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingLimitRulePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingLimitRuleQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingLimitRuleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingLimitRuleDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimSettingLimitRuleDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingLimitRuleRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 报销额度配置
 *
 * @author zoey
 * @date 2024-05-14
 */
@Repository
@RequiredArgsConstructor
public class AccReimSettingLimitRuleDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccReimSettingLimitRuleRepo repo;
    private final QAccReimSettingLimitRuleDO qdo = QAccReimSettingLimitRuleDO.accReimSettingLimitRuleDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimSettingLimitRuleVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccReimSettingLimitRuleVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 报销配置主表id
                qdo.reimSettingLimitId,
                // 专业级别
                qdo.professionalGrade,
                // 管理级别
                qdo.manageGrade,
                // 特大城市额度
                qdo.megacitiesLimit,
                // 一线城市额度
                qdo.firstTierCityLimit,
                // 其它城市额度
                qdo.otherLimit
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimSettingLimitRuleVO> getJpaQueryWhere(AccReimSettingLimitRuleQuery query) {
        JPAQuery<AccReimSettingLimitRuleVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccReimSettingLimitRuleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccReimSettingLimitRuleQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 报销配置主表id 精确 */
        if (!ObjectUtils.isEmpty(query.getReimSettingLimitId())) {
            list.add(qdo.reimSettingLimitId.eq(query.getReimSettingLimitId()));
        }
        /** 专业级别 精确 */
        if (!ObjectUtils.isEmpty(query.getProfessionalGrade())) {
            list.add(qdo.professionalGrade.eq(query.getProfessionalGrade()));
        }
        /** 管理级别 精确 */
        if (!ObjectUtils.isEmpty(query.getManageGrade())) {
            list.add(qdo.manageGrade.eq(query.getManageGrade()));
        }
        /** 特大城市额度 精确 */
        if (!ObjectUtils.isEmpty(query.getMegacitiesLimit())) {
            list.add(qdo.megacitiesLimit.eq(query.getMegacitiesLimit()));
        }
        /** 一线城市额度 精确 */
        if (!ObjectUtils.isEmpty(query.getFirstTierCityLimit())) {
            list.add(qdo.firstTierCityLimit.eq(query.getFirstTierCityLimit()));
        }
        /** 其它城市额度 精确 */
        if (!ObjectUtils.isEmpty(query.getOtherLimit())) {
            list.add(qdo.otherLimit.eq(query.getOtherLimit()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccReimSettingLimitRuleVO queryByKey(Long id) {
        JPAQuery<AccReimSettingLimitRuleVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccReimSettingLimitRuleVO> queryListDynamic(AccReimSettingLimitRuleQuery query) {
        JPAQuery<AccReimSettingLimitRuleVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccReimSettingLimitRuleVO> queryPaging(AccReimSettingLimitRuleQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<AccReimSettingLimitRuleVO> jpaQuery = getJpaQueryWhere(query);
        List<AccReimSettingLimitRuleVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccReimSettingLimitRuleVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccReimSettingLimitRuleDO save(AccReimSettingLimitRuleDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccReimSettingLimitRuleDO> saveAll(List<AccReimSettingLimitRuleDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccReimSettingLimitRulePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 报销配置主表id
        if (payload.getReimSettingLimitId() != null) {
            update.set(qdo.reimSettingLimitId, payload.getReimSettingLimitId());
        }
        // 专业级别
        if (payload.getProfessionalGrade() != null) {
            update.set(qdo.professionalGrade, payload.getProfessionalGrade());
        }
        // 管理级别
        if (payload.getManageGrade() != null) {
            update.set(qdo.manageGrade, payload.getManageGrade());
        }
        // 特大城市额度
        if (payload.getMegacitiesLimit() != null) {
            update.set(qdo.megacitiesLimit, payload.getMegacitiesLimit());
        }
        // 一线城市额度
        if (payload.getFirstTierCityLimit() != null) {
            update.set(qdo.firstTierCityLimit, payload.getFirstTierCityLimit());
        }
        // 其它城市额度
        if (payload.getOtherLimit() != null) {
            update.set(qdo.otherLimit, payload.getOtherLimit());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 报销配置主表id
            if (nullFields.contains("reimSettingLimitId")) {
                update.setNull(qdo.reimSettingLimitId);
            }
            // 专业级别
            if (nullFields.contains("professionalGrade")) {
                update.setNull(qdo.professionalGrade);
            }
            // 管理级别
            if (nullFields.contains("manageGrade")) {
                update.setNull(qdo.manageGrade);
            }
            // 特大城市额度
            if (nullFields.contains("megacitiesLimit")) {
                update.setNull(qdo.megacitiesLimit);
            }
            // 一线城市额度
            if (nullFields.contains("firstTierCityLimit")) {
                update.setNull(qdo.firstTierCityLimit);
            }
            // 其它城市额度
            if (nullFields.contains("otherLimit")) {
                update.setNull(qdo.otherLimit);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

