package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author sunxw
 * @description
 * @Date 2023/11/22
 */
@Entity
@Table(name = "acc_reim_rule", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_rule", comment = "费用报销规则")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimRuleDO extends BaseModel implements Serializable {

    @Comment("规则编号")
    @Column()
    private String ruleNo;

    @Comment("规则名称")
    @Column()
    private String ruleName;

    @Comment("核算项目编码(对多个生效时，可以,分割)")
    @Column()
    private String busAccItemCodes;

    @Comment("费用发生日期")
    @Column()
    private LocalDate expenseDate;

    @Comment("发票日期")
    @Column()
    private LocalDate invDate;

    @Comment("额度控制")
    @Column()
    private BigDecimal limitAmt;

    @Comment("规则类型 NORMAL-通用  ACC_TRIP-差旅 等(与单据类型一致)")
    @Column()
    private String ruleType;

    @Comment("检查范围 ALL-当前报销单所有明细 SELF-仅自己/单条")
    @Column()
    private String checkRange;

    @Comment("是否支持动态配置 0-否 1-是")
    @Column()
    private Integer dynamicFlag;

    @Comment("规则开关标识 0-关闭 1-开启 ")
    @Column()
    private Integer ruleFlag;

    @Comment("规则提示信息")
    @Column()
    private String noticeMsg;

    @Comment("规则提示登记 WARN-存在警告 ILLEGAL-不符合规范")
    @Column()
    private String noticeLevel;

    @Comment("扩展字段1 作为出发地")
    @Column()
    private String extString1;

    @Comment("扩展字段2 作为目的地")
    @Column()
    private String extString2;

    @Comment("扩展字段3 作为日期起")
    @Column()
    private String extString3;

    @Comment("扩展字段4 作为日期止")
    @Column()
    private String extString4;

    @Comment("扩展字段5")
    @Column()
    private String extString5;

    public void copy(AccReimRuleDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
