package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author sunxw
 * @description 报销金额来源记录
 * @Date 2023/12/4
 */
@Entity
@Table(name = "acc_reim_source_record", indexes = {
        @Index(name = "idx_reim_id", columnList = "reim_id"),
        @Index(name = "idx_reim_dtl_id", columnList = "reim_dtl_id")
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_source_record", comment = "报销金额来源记录")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimSourceRecordDO extends BaseModel implements Serializable {

    @Comment("报销主表ID")
    @Column(name = "reim_id")
    private Long reimId;

    @Comment("报销明细ID")
    @Column(name = "reim_dtl_id")
    private Long reimDtlId;

    @Comment("报销规则ID")
    @Column()
    private Long ruleId;

    @Comment("报销内容详情(JSON)")
    @Column(columnDefinition = "text")
    private String content;

    public void copy(AccReimSourceRecordDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
