package com.elitesland.tw.tw5.server.prd.administration.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.administration.payload.CertificationLicensePayload;
import com.elitesland.tw.tw5.api.prd.administration.query.CertificationLicenseQuery;
import com.elitesland.tw.tw5.api.prd.administration.service.CertificationLicenseService;
import com.elitesland.tw.tw5.api.prd.administration.vo.CertificationLicenseVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.server.prd.administration.convert.CertificationLicenseConvert;
import com.elitesland.tw.tw5.server.prd.administration.dao.CertificationLicenseDAO;
import com.elitesland.tw.tw5.server.prd.administration.entity.CertificationLicenseDO;
import com.elitesland.tw.tw5.server.prd.administration.repo.CertificationLicenseRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdMessageConfigConvert;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

/**
 * 资质证照
 *
 * @author wangly
 * @date 2023-09-20
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CertificationLicenseServiceImpl extends BaseServiceImpl implements CertificationLicenseService {

    private final CertificationLicenseRepo certificationLicenseRepo;
    private final CertificationLicenseDAO certificationLicenseDAO;
    private final PrdMessageConfigService messageConfigService;
    private final PrdMessageConfigRepo repoMessage;
    private final FileUtil fileUtil;

    @Override
    public PagingVO<CertificationLicenseVO> queryPaging(CertificationLicenseQuery query) {
        PagingVO<CertificationLicenseVO> certificationLicenseVOPagingVO = certificationLicenseDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty(certificationLicenseVOPagingVO.getRecords())) {
            certificationLicenseVOPagingVO.stream().forEach(p -> translate(p));
        }
        return certificationLicenseVOPagingVO;
    }

    @Override
    public List<CertificationLicenseVO> queryListDynamic(CertificationLicenseQuery query) {
        List<CertificationLicenseVO> certificationLicenseVOS = certificationLicenseDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(certificationLicenseVOS)) {
            certificationLicenseVOS.stream().forEach(p -> translate(p));
        }
        return certificationLicenseVOS;
    }

    @Override
    public CertificationLicenseVO queryByKey(Long key) {
        CertificationLicenseDO entity = certificationLicenseRepo.findById(key).orElseGet(CertificationLicenseDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CertificationLicenseVO vo = CertificationLicenseConvert.INSTANCE.toVo(entity);
        translate(vo);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CertificationLicenseVO insert(CertificationLicensePayload payload) {
        CertificationLicenseDO entityDo = CertificationLicenseConvert.INSTANCE.toDo(payload);
        return CertificationLicenseConvert.INSTANCE.toVo(certificationLicenseRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CertificationLicenseVO update(CertificationLicensePayload payload) {
        CertificationLicenseDO entity = certificationLicenseRepo.findById(payload.getId()).orElseGet(CertificationLicenseDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CertificationLicenseDO entityDo = CertificationLicenseConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CertificationLicenseConvert.INSTANCE.toVo(certificationLicenseRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(CertificationLicensePayload payload) {
        CertificationLicenseDO entity = certificationLicenseRepo.findById(payload.getId()).orElseGet(CertificationLicenseDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = certificationLicenseDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            certificationLicenseDAO.deleteSoft(keys);
        }
    }

    //翻译某些字段
    private void translate(CertificationLicenseVO vo) {
        vo.setFileData(fileUtil.getFileDatas(vo.getFileCode()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void certificationLicenseInvaildAlter() {
        LocalDateTime time = LocalDateTime.now();

        XxlJobLogger.log("资质证照过期提醒开始...");
        XxlJobLogger.log("certificationLicenseInvaild localDateTime：" + time);

        CertificationLicenseQuery query = new CertificationLicenseQuery();
        query.setValidDateEnd(LocalDate.now().plusMonths(1));
        List<CertificationLicenseVO> certificationLicenseVOS = queryListDynamic(query);
        if (!CollectionUtils.isEmpty(certificationLicenseVOS)) {
            certificationLicenseVOS.forEach(p -> {
                PrdMessageConfigDO ado = new PrdMessageConfigDO();  //要发送的消息
                ado.setContentBigType("businessMessage");
                ado.setContentType("systemMessage");
                ado.setCreateSource("定时任务");
                String code = generateSeqNum("MESSAGE_CONFIG_NO");
                ado.setMessageCode(code);
                ado.setIsEnable(0);
                ado.setObjectId(p.getId());  //业务数据
                ado.setMessageType(2);
                ado.setNoticeScope("appoint_people");
                ado.setNoticeWay("instation");
                ado.setTriggerWay("timing");
                ado.setTenantId(p.getTenantId());
                ado.setReleaseSource("profileMessage");
                ado.setReleaseStatus(3);
                String content = "";
                ado.setMessageTitle("资质证书过期提醒");
                ado.setMessageContent(content);
                ado.setTriggerTime(LocalDateTime.now());
                ado.setNoticeSource(p.getCreateUserId().toString());
                //保存消息
                PrdMessageConfigDO save1 = repoMessage.save(ado);
                //发送消息
                messageConfigService.releaseMessage(Arrays.asList(PrdMessageConfigConvert.INSTANCE.toVo(save1)));

            });
        }

        XxlJobLogger.log("资质证照过期提醒结束...");

    }

}
