package com.elitesland.tw.tw5.server.prd.borrow.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.BorrowMoneyQuery;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowMoneyService;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 借款管理
 *
 * @folder 借款管理
 * @author wangly
 * @date 2024-07-15
 */
@Api(tags = "借款管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/borrowMoney")
@Slf4j
public class BorrowMoneyController {

    private final BorrowMoneyService borrowMoneyService;

    /**
     * 借款管理-新增
     *
     * @folder 借款管理
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("借款管理-新增")
    public TwOutputUtil<BorrowMoneyVO> insert(@RequestBody BorrowMoneyPayload payload){
         return TwOutputUtil.ok(borrowMoneyService.insert(payload));
    }

    /**
     * 借款管理-更新
     *
         * @folder 借款管理
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("借款管理-更新")
    public TwOutputUtil<BorrowMoneyVO> update(@RequestBody BorrowMoneyPayload payload){
        return TwOutputUtil.ok(borrowMoneyService.update(payload));
    }

    /**
     * 借款管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 借款管理
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("借款管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BorrowMoneyPayload payload){
        return TwOutputUtil.ok(borrowMoneyService.updateByKeyDynamic(payload));
    }

    /**
     * 借款管理-主键查询
     *
     * @folder 借款管理
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("借款管理-主键查询")
    public TwOutputUtil<BorrowMoneyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(borrowMoneyService.queryByKey(key));
    }

    /**
     * 借款管理-分页
     *
         * @folder 借款管理
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("借款管理-分页")
    public TwOutputUtil<PagingVO<BorrowMoneyVO>> paging(BorrowMoneyQuery query) {
        return TwOutputUtil.ok(borrowMoneyService.queryPaging(query));
    }

    /**
     * 借款管理-查询列表
     *
     * @folder 借款管理
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("借款管理-查询列表")
    public TwOutputUtil<List<BorrowMoneyVO>> queryList(BorrowMoneyQuery query) {
        return TwOutputUtil.ok(borrowMoneyService.queryListDynamic(query));
    }

    /**
     * 借款管理-删除
     *
         * @folder 借款管理
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("借款管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         borrowMoneyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

