package com.elitesland.tw.tw5.server.prd.borrow.dao;

import com.elitesland.tw.tw5.api.prd.borrow.payload.TransferApplyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.TransferApplyQuery;
import com.elitesland.tw.tw5.api.prd.borrow.vo.TransferApplyVO;
import com.elitesland.tw.tw5.server.prd.borrow.entity.TransferApplyDO;
import com.elitesland.tw.tw5.server.prd.borrow.entity.QTransferApplyDO;
import com.elitesland.tw.tw5.server.prd.borrow.repo.TransferApplyRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 出让申请
 *
 * @author wangly
 * @date 2024-07-15
 */
@Repository
@RequiredArgsConstructor
public class TransferApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TransferApplyRepo repo;
    private final QTransferApplyDO qdo = QTransferApplyDO.transferApplyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TransferApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TransferApplyVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 借款ID
                qdo.borrowId,
                // 出让名称
                qdo.transferName,
                // 出让人ID
                qdo.transferUserId,
                // 出让日期
                qdo.transferDate,
                // 出让人所属bu
                qdo.transferBuId,
                // 受让人ID
                qdo.receiveUserId,
                // 受让人所属bu
                qdo.receiveBuId,
                // 出让原因
                qdo.transferReason,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime,
                // 扩展字段1
                qdo.ext1,
                // 扩展字段2
                qdo.ext2,
                // 扩展字段3
                qdo.ext3,
                // 扩展字4
                qdo.ext4,
                // 扩展字5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TransferApplyVO> getJpaQueryWhere(TransferApplyQuery query) {
        JPAQuery<TransferApplyVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TransferApplyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TransferApplyQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 借款ID 精确 */
        if (!ObjectUtils.isEmpty(query.getBorrowId())) {
            list.add(qdo.borrowId.eq(query.getBorrowId()));
        }
        /** 借款ID集合 精确 */
        if (!CollectionUtils.isEmpty(query.getBorrowIdList())) {
            list.add(qdo.borrowId.in(query.getBorrowIdList()));
        }
        /** 出让名称 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferName())) {
            list.add(qdo.transferName.eq(query.getTransferName()));
        }
        /** 出让人ID 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferUserId())) {
            list.add(qdo.transferUserId.eq(query.getTransferUserId()));
        }
        /** 出让日期 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferDate())) {
            list.add(qdo.transferDate.eq(query.getTransferDate()));
        }
        /** 出让人所属bu 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferBuId())) {
            list.add(qdo.transferBuId.eq(query.getTransferBuId()));
        }
        /** 受让人ID 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiveUserId())) {
            list.add(qdo.receiveUserId.eq(query.getReceiveUserId()));
        }
        /** 受让人所属bu 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiveBuId())) {
            list.add(qdo.receiveBuId.eq(query.getReceiveBuId()));
        }
        /** 出让原因 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferReason())) {
            list.add(qdo.transferReason.eq(query.getTransferReason()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        /** 扩展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 扩展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 扩展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 扩展字4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 扩展字5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TransferApplyVO queryByKey(Long id) {
        JPAQuery<TransferApplyVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TransferApplyVO> queryListDynamic(TransferApplyQuery query) {
        JPAQuery<TransferApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TransferApplyVO> queryPaging(TransferApplyQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<TransferApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<TransferApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TransferApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TransferApplyDO save(TransferApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TransferApplyDO> saveAll(List<TransferApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TransferApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 借款ID
        if (payload.getBorrowId() != null) {
            update.set(qdo.borrowId, payload.getBorrowId());
        }
        // 出让名称
        if (payload.getTransferName() != null) {
            update.set(qdo.transferName, payload.getTransferName());
        }
        // 出让人ID
        if (payload.getTransferUserId() != null) {
            update.set(qdo.transferUserId, payload.getTransferUserId());
        }
        // 出让日期
        if (payload.getTransferDate() != null) {
            update.set(qdo.transferDate, payload.getTransferDate());
        }
        // 出让人所属bu
        if (payload.getTransferBuId() != null) {
            update.set(qdo.transferBuId, payload.getTransferBuId());
        }
        // 受让人ID
        if (payload.getReceiveUserId() != null) {
            update.set(qdo.receiveUserId, payload.getReceiveUserId());
        }
        // 受让人所属bu
        if (payload.getReceiveBuId() != null) {
            update.set(qdo.receiveBuId, payload.getReceiveBuId());
        }
        // 出让原因
        if (payload.getTransferReason() != null) {
            update.set(qdo.transferReason, payload.getTransferReason());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 扩展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 扩展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 扩展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 扩展字4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 扩展字5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 借款ID
            if (nullFields.contains("borrowId")) {
                update.setNull(qdo.borrowId);
            }
            // 出让名称
            if (nullFields.contains("transferName")) {
                update.setNull(qdo.transferName);
            }
            // 出让人ID
            if (nullFields.contains("transferUserId")) {
                update.setNull(qdo.transferUserId);
            }
            // 出让日期
            if (nullFields.contains("transferDate")) {
                update.setNull(qdo.transferDate);
            }
            // 出让人所属bu
            if (nullFields.contains("transferBuId")) {
                update.setNull(qdo.transferBuId);
            }
            // 受让人ID
            if (nullFields.contains("receiveUserId")) {
                update.setNull(qdo.receiveUserId);
            }
            // 受让人所属bu
            if (nullFields.contains("receiveBuId")) {
                update.setNull(qdo.receiveBuId);
            }
            // 出让原因
            if (nullFields.contains("transferReason")) {
                update.setNull(qdo.transferReason);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            // 扩展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 扩展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 扩展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 扩展字4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 扩展字5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

