package com.elitesland.tw.tw5.server.prd.borrow.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * 借款管理
 *
 * @author wangly
 * @date 2024-07-15
 */
@Entity
@Table(name = "borrow_money", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "borrow_money", comment = "借款管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BorrowMoneyDO extends BaseModel implements Serializable  {
    /** 借款编号 */
    @Comment("借款编号")
    @Column()
    private String borrowNo;
    /** 借款名称 */
    @Comment("借款名称")
    @Column()
    private String borrowName;
    /** 申请人 */
    @Comment("申请人")
    @Column()
    private Long applicantUserId;
    /** 出让日期 */
    @Comment("出让日期")
    @Column()
    private LocalDate transferDate;
    /** 受让人ID */
    @Comment("受让人ID")
    @Column()
    private Long receiveUserId;
    /** 受让人所属bu */
    @Comment("受让人所属bu")
    @Column()
    private Long receiveBuId;
    /** 申请日期 */
    @Comment("申请日期")
    @Column()
    private LocalDate applicantTime;
    /** 申请人所属bu */
    @Comment("申请人所属bu")
    @Column()
    private Long applicantBuId;
    /** 单据状态 udc[BORROW_MONEY:STATUS] */
    @Comment("单据状态 udc[BORROW_MONEY:STATUS]")
    @Column()
    private String apprStatus;
    /** 业务类型 udc[BORROW_MONEY:BUSINESS_TYPE] */
    @Comment("业务类型 udc[BORROW_MONEY:BUSINESS_TYPE]")
    @Column()
    private String businessType;
    /** 是否出让 */
    @Comment("是否出让")
    @Column()
    private Boolean transferFlag;
    /** 还款人ID */
    @Comment("还款人ID")
    @Column()
    private Long repaymentUserId;
    /** 借款金额 */
    @Comment("借款金额")
    @Column()
    private BigDecimal borrowAmt;
    /** 已核销金额 */
    @Comment("已核销金额")
    @Column()
    private BigDecimal alreadyWriteOffAmt;
    /** 未核销金额 */
    @Comment("未核销金额")
    @Column()
    private BigDecimal unwriteOffAmt;
    /** 预计核销日期 */
    @Comment("预计核销日期")
    @Column()
    private LocalDate preWriteOffDate;
    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCodes;
    /** 收款账户 */
    @Comment("收款账户")
    @Column()
    private String accountNo;
    /** 户名 */
    @Comment("户名")
    @Column()
    private String holderName;
    /** 收款银行 */
    @Comment("收款银行")
    @Column()
    private String bankName;
    /** 扩展字段1 */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /** 扩展字段2 */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /** 扩展字段3 */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /** 扩展字4 */
    @Comment("扩展字4")
    @Column()
    private String ext4;
    /** 扩展字5 */
    @Comment("扩展字5")
    @Column()
    private String ext5;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(BorrowMoneyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
