package com.elitesland.tw.tw5.server.prd.borrow.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.payload.TransferApplyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.TransferApplyQuery;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowMoneyService;
import com.elitesland.tw.tw5.api.prd.borrow.service.TransferApplyService;
import com.elitesland.tw.tw5.api.prd.borrow.vo.TransferApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.borrow.convert.TransferApplyConvert;
import com.elitesland.tw.tw5.server.prd.borrow.dao.TransferApplyDAO;
import com.elitesland.tw.tw5.server.prd.borrow.entity.TransferApplyDO;
import com.elitesland.tw.tw5.server.prd.borrow.repo.TransferApplyRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * 出让申请
 *
 * @author wangly
 * @date 2024-07-15
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TransferApplyServiceImpl extends BaseServiceImpl implements TransferApplyService {

    private final TransferApplyRepo transferApplyRepo;
    private final TransferApplyDAO transferApplyDAO;
    @Autowired
    @Lazy
    private BorrowMoneyService borrowMoneyService;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;

    private final CacheUtil cacheUtil;
    @Override
    public PagingVO<TransferApplyVO> queryPaging(TransferApplyQuery query){
        return transferApplyDAO.queryPaging(query);
    }

    @Override
    public List<TransferApplyVO> queryListDynamic(TransferApplyQuery query){
        return transferApplyDAO.queryListDynamic(query);
    }

    @Override
    public TransferApplyVO queryByKey(Long key) {
        TransferApplyDO entity = transferApplyRepo.findById(key).orElseGet(TransferApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        return TransferApplyConvert.INSTANCE.toVo(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TransferApplyVO insert(TransferApplyPayload payload) {
        TransferApplyDO entityDo = TransferApplyConvert.INSTANCE.toDo(payload);
//        TransferApplyDO transferApplyDO = transactionUtilService.executeWithCallable(() -> transferApplyRepo.save(entityDo));
        TransferApplyDO transferApplyDO = transferApplyRepo.save(entityDo);
        TransferApplyVO transferApplyVO = TransferApplyConvert.INSTANCE.toVo(transferApplyDO);
        // 发起流程
        activeTransferApplyProc(transferApplyVO);
        return transferApplyVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TransferApplyVO update(TransferApplyPayload payload) {
        TransferApplyDO entity = transferApplyRepo.findById(payload.getId()).orElseGet(TransferApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TransferApplyDO entityDo = TransferApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TransferApplyConvert.INSTANCE.toVo(transferApplyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TransferApplyPayload payload) {
        TransferApplyDO entity = transferApplyRepo.findById(payload.getId()).orElseGet(TransferApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        return transferApplyDAO.updateByKeyDynamic(payload);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            transferApplyDAO.deleteSoft(keys);
        }
    }
    private void activeTransferApplyProc(TransferApplyVO transferApplyVO){
        HashMap<String, Object> variables = new HashMap<>();
        String procInstName = transferApplyVO.getTransferName() + "-出让流程";
        // 收让人所属一级BU
        PrdOrgOrganizationRefVO firstBuByBuId = cacheUtil.getBULevel1ByOrgId(transferApplyVO.getReceiveBuId());
        if (firstBuByBuId != null) {
            transferApplyVO.setReceiveFirstBuId(firstBuByBuId.getOrgId());
        }
        // 发起流程
        ProcessInfo processInfo;
        processInfo = workflowUtil.simpleStartProcess(StartProcessPayload.of(
                ProcDefKey.DIB_BORROW_MONEY_TRANSFER.name(),
                procInstName,
                transferApplyVO.getId() + "",
                variables), transferApplyVO);
        TransferApplyPayload payload = new TransferApplyPayload();
        payload.setId(transferApplyVO.getId());
        BorrowMoneyPayload borrowMoneyPayload = new BorrowMoneyPayload();
        borrowMoneyPayload.setId(transferApplyVO.getBorrowId());
        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            borrowMoneyPayload.setTransferFlag(true);
        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload.setProcInstStatus(ProcInstStatus.APPROVED);
            payload.setApprovedTime(LocalDateTime.now());
            // 更新借款表的受让人 受让人BU
            borrowMoneyPayload.setId(transferApplyVO.getBorrowId());
            borrowMoneyPayload.setReceiveUserId(transferApplyVO.getReceiveUserId());
            borrowMoneyPayload.setReceiveBuId(transferApplyVO.getReceiveBuId());
            borrowMoneyPayload.setTransferDate(transferApplyVO.getTransferDate());
            borrowMoneyPayload.setTransferFlag(false);
            borrowMoneyPayload.setRepaymentUserId(transferApplyVO.getReceiveUserId());
        }
        transferApplyDAO.updateByKeyDynamic(payload);
        borrowMoneyService.updateByKeyDynamic(borrowMoneyPayload);

    }
}
