package com.elitesland.tw.tw5.server.prd.borrow.workflow;

import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.payload.TransferApplyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowMoneyService;
import com.elitesland.tw.tw5.api.prd.borrow.service.TransferApplyService;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;
import com.elitesland.tw.tw5.api.prd.borrow.vo.TransferApplyVO;
import com.elitesland.tw.tw5.server.common.workFlow.CommonWorkflowCallbackController;
import com.elitesland.tw.tw5.server.prd.borrow.constant.BorrowStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

@Slf4j
@Service(CommonWorkflowCallbackController.SERVICE_NAME_PREFIX + "TRANSFER_APPLY")
public class TransferApplyWorkflowCallBackController implements WorkflowCallBack {

    @Autowired
    private BorrowMoneyService borrowMoneyService;
    @Autowired
    private TransferApplyService service;
    @Override
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        log.info("customer taskAssignee:{}", payload);
        return WorkflowResult.success(null);
    }

    @Override
    public WorkflowResult<Void> taskCreated(TaskCreatedPayload payload) {
        log.info("customer taskCreated:{}", payload);
        return WorkflowResult.success(null);
    }

    @Override
    public WorkflowResult<Void> taskCompleted(TaskCompletedPayload payload) {
        log.info("customer taskCompleted:{}", payload);
        return WorkflowResult.success(null);
    }

    @Override
    public WorkflowResult<Void> processStatusChange(ProcessStatusChangePayload payload) {
        log.info("customer processStatusChange:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        TransferApplyPayload transferApplyPayload = new TransferApplyPayload();
        transferApplyPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        TransferApplyVO transferApplyVO = service.queryByKey(Long.valueOf(businessKey));
        if (transferApplyVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
//                    busiCardApplyPayload.setDetailedStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    transferApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
//                    epibolyCostConDPayload.setDetailedStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    transferApplyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                case INVALID://先删除流程再删除单据
                    transferApplyPayload.setDeleteFlag(1);
                    transferApplyPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    transferApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    transferApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    transferApplyPayload.setApprovedTime(LocalDateTime.now());
                    // 更新借款表的出让人 出让bu 出让日期
                    BorrowMoneyPayload borrowMoneyPayload = new BorrowMoneyPayload();
                    borrowMoneyPayload.setId(transferApplyVO.getBorrowId());
                    borrowMoneyPayload.setReceiveUserId(transferApplyVO.getReceiveUserId());
                    borrowMoneyPayload.setReceiveBuId(transferApplyVO.getReceiveBuId());
                    borrowMoneyPayload.setTransferDate(transferApplyVO.getTransferDate());
                    borrowMoneyPayload.setRepaymentUserId(transferApplyVO.getReceiveUserId());
                    borrowMoneyPayload.setTransferFlag(false);
                    borrowMoneyService.updateByKeyDynamic(borrowMoneyPayload);
                    break;
                case APPROVING:
                    transferApplyPayload.setProcInstStatus(ProcInstStatus.APPROVING);

            }
            service.updateByKeyDynamic(transferApplyPayload);
        }
        return WorkflowResult.success(null);
    }
}
