package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountFreezeQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountFreezeService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountFreezeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核算-账户冻结记录管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Api(tags = "核算-账户冻结记录管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cal/calAccountFreeze")
@Slf4j
public class CalAccountFreezeController {

    private final CalAccountFreezeService calAccountFreezeService;

    /**
     * 核算-账户冻结记录管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("核算-账户冻结记录管理-分页")
    public TwOutputUtil<PagingVO<CalAccountFreezeVO>> paging(CalAccountFreezeQuery query) {
        return TwOutputUtil.ok(calAccountFreezeService.queryPaging(query));
    }
//    /**
//     * 核算-账户冻结记录管理-新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("核算-账户冻结记录管理-新增")
//    public TwOutputUtil<CalAccountFreezeVO> insert(@RequestBody CalAccountFreezePayload payload) {
//        return TwOutputUtil.ok(calAccountFreezeService.insert(payload));
//    }

//    /**
//     * 核算-账户冻结记录管理-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("核算-账户冻结记录管理-更新")
//    public TwOutputUtil<CalAccountFreezeVO> update(@RequestBody CalAccountFreezePayload payload) {
//        return TwOutputUtil.ok(calAccountFreezeService.update(payload));
//    }

//    /**
//     * 核算-账户冻结记录管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("核算-账户冻结记录管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CalAccountFreezePayload payload) {
//        return TwOutputUtil.ok(calAccountFreezeService.updateByKeyDynamic(payload));
//    }
//
//    /**
//     * 核算-账户冻结记录管理-主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("核算-账户冻结记录管理-主键查询")
//    public TwOutputUtil<CalAccountFreezeVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(calAccountFreezeService.queryByKey(key));
//    }


//    /**
//     * 核算-账户冻结记录管理-查询列表
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("核算-账户冻结记录管理-查询列表")
//    public TwOutputUtil<List<CalAccountFreezeVO>> queryList(CalAccountFreezeQuery query) {
//        return TwOutputUtil.ok(calAccountFreezeService.queryListDynamic(query));
//    }
//
//    /**
//     * 核算-账户冻结记录管理-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("核算-账户冻结记录管理-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        calAccountFreezeService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}

