package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalWideSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalWideSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalWideSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalWideSettleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 泛用当量结算单管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Api(tags = "泛用当量结算单管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cal/calWideSettle")
@Slf4j
public class CalWideSettleController {

    private final CalWideSettleService calWideSettleService;

    /**
     * 泛用当量结算单管理-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("泛用当量结算单管理-新增或修改")
    public TwOutputUtil<CalWideSettleVO> insertOrUpdate(@RequestBody CalWideSettlePayload payload) {
        return TwOutputUtil.ok(calWideSettleService.insertOrUpdate(payload));
    }
//

    /**
     * 泛用当量结算单管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("泛用当量结算单管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CalWideSettlePayload payload) {
        return TwOutputUtil.ok(calWideSettleService.updateByKeyDynamic(payload));
    }

    /**
     * 泛用当量结算单管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("泛用当量结算单管理-主键查询")
    public TwOutputUtil<CalWideSettleVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(calWideSettleService.queryByKey(key));
    }

    /**
     * 泛用当量结算单管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("泛用当量结算单管理-分页")
    public TwOutputUtil<PagingVO<CalWideSettleVO>> paging(CalWideSettleQuery query) {
        return TwOutputUtil.ok(calWideSettleService.queryPaging(query));
    }

    /**
     * 泛用当量结算单管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("泛用当量结算单管理-查询列表")
    public TwOutputUtil<List<CalWideSettleVO>> queryList(CalWideSettleQuery query) {
        return TwOutputUtil.ok(calWideSettleService.queryListDynamic(query));
    }

    /**
     * 泛用当量结算单管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("泛用当量结算单管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        calWideSettleService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

//    /**
//     * 泛用当量结算单管理-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("泛用当量结算单管理-更新")
//    public TwOutputUtil<CalWideSettleVO> update(@RequestBody CalWideSettlePayload payload) {
//        return TwOutputUtil.ok(calWideSettleService.update(payload));
//    }
}

