package com.elitesland.tw.tw5.server.prd.cal.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 当量收入配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Entity
@Table(name = "cal_eqva_income", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "cal_eqva_income", comment = "当量收入配置管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CalEqvaIncomeDO extends BaseModel implements Serializable {

    /**
     * buid
     */
    @Comment("buid")
    @Column()
    private Long buId;
    /**
     * 核算年度
     */
    @Comment("核算年度")
    @Column()
    private Integer finYear;
    /**
     * 核算期间
     */
    @Comment("核算期间")
    @Column()
    private Integer finPeriod;
    /**
     * 工种
     */
    @Comment("工种")
    @Column()
    private String jobType1;
    /**
     * 工种子类
     */
    @Comment("工种子类")
    @Column()
    private String jobType2;
    /**
     * 合作方式
     */
    @Comment("合作方式")
    @Column()
    private String coopType;
    /**
     * 城市级别
     */
    @Comment("城市级别")
    @Column()
    private String cityLevel;
    /**
     * 单位当量收入
     */
    @Comment("单位当量收入")
    @Column()
    private BigDecimal preeqvaAmt;
    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String lineStatus;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projId;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column()
    private String projName;
    /**
     * 资源id
     */
    @Comment("资源id")
    @Column()
    private Long resId;
    /**
     * 资源类型1内部，0外部
     */
    @Comment("资源类型1内部，0外部")
    @Column()
    private String resType;

    /**
     * 起始时间
     */
    @Comment("起始时间")
    @Column()
    private LocalDate startDate;

    /**
     * 失效时间
     */
    @Comment("失效时间")
    @Column()
    private LocalDate endDate;
    /**
     * 版本号
     */
    @Comment("版本号")
    @Column()
    private Integer version;

    /**
     * 结算方式 udc[org:employee:withdrawSettleMethod]
     */
    @Comment("结算方式 udc[org:employee:withdrawSettleMethod]")
    @Column()
    private String settleType;

    public void copy(CalEqvaIncomeDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
