package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * @author wangly
 * @date 2023/9/27
 *
 * 印章类型
 *
 */
public enum SignetTypeEnum {

    PERSONNEL("PERSONNEL", "人事"),
    SALES_CONTRACT("SALES_CONTRACT", "销售合同"),
    PURCHASE_CONTRACT("PURCHASE_CONTRACT", "采购合同"),
    PROJECT("PROJECT", "项目"),
    ADMINISTRATION("ADMINISTRATION", "行政"),
    FINANCE("FINANCE", "财务"),
    MARKETPLACE("MARKETPLACE", "市场"),
    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    SignetTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SignetTypeEnum toType(String value) {
        return Stream.of(SignetTypeEnum.values()) .filter(p -> p.code.equals(value)) .findAny() .orElse(null); }

}
