package com.elitesland.tw.tw5.server.prd.copartner.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigDetailPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigDetailQuery;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigDetailService;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigDetailVO;
import com.elitesland.tw.tw5.server.prd.copartner.convert.PerformanceReadmeConfigDetailConvert;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeConfigDetailDAO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeConfigDetailDO;
import com.elitesland.tw.tw5.server.prd.copartner.repo.PerformanceReadmeConfigDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 合伙人绩效考核点维护
 *
 * @author carl
 * @date 2024-06-24
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PerformanceReadmeConfigDetailServiceImpl extends BaseServiceImpl implements PerformanceReadmeConfigDetailService {

    private final PerformanceReadmeConfigDetailRepo performanceReadmeConfigDetailRepo;
    private final PerformanceReadmeConfigDetailDAO performanceReadmeConfigDetailDAO;

    @Override
    public PagingVO<PerformanceReadmeConfigDetailVO> queryPaging(PerformanceReadmeConfigDetailQuery query) {
        return performanceReadmeConfigDetailDAO.queryPaging(query);
    }

    @Override
    public List<PerformanceReadmeConfigDetailVO> queryListDynamic(PerformanceReadmeConfigDetailQuery query) {
        return performanceReadmeConfigDetailDAO.queryListDynamic(query);
    }

    @Override
    public PerformanceReadmeConfigDetailVO queryByKey(Long key) {
        PerformanceReadmeConfigDetailDO entity = performanceReadmeConfigDetailRepo.findById(key).orElseGet(PerformanceReadmeConfigDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PerformanceReadmeConfigDetailVO vo = PerformanceReadmeConfigDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PerformanceReadmeConfigDetailVO insert(PerformanceReadmeConfigDetailPayload payload) {
        PerformanceReadmeConfigDetailDO entityDo = PerformanceReadmeConfigDetailConvert.INSTANCE.toDo(payload);
        return PerformanceReadmeConfigDetailConvert.INSTANCE.toVo(performanceReadmeConfigDetailRepo.save(entityDo));
    }

    @Override
    public List<PerformanceReadmeConfigDetailVO> batchInsert(List<PerformanceReadmeConfigDetailPayload> payloads) {
        List<PerformanceReadmeConfigDetailDO> entityDos = payloads.stream().map(payload -> {
            PerformanceReadmeConfigDetailDO entityDo = PerformanceReadmeConfigDetailConvert.INSTANCE.toDo(payload);
            return entityDo;
        }).collect(Collectors.toList());
        List<PerformanceReadmeConfigDetailDO> performanceReadmeConfigDetailDOS = performanceReadmeConfigDetailDAO.saveAll(entityDos);

        List<PerformanceReadmeConfigDetailVO> vos = performanceReadmeConfigDetailDOS.stream().map(entity -> {
            PerformanceReadmeConfigDetailVO vo = PerformanceReadmeConfigDetailConvert.INSTANCE.toVo(entity);
            return vo;
        }).collect(Collectors.toList());
        return vos;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PerformanceReadmeConfigDetailPayload payload) {
        long result = performanceReadmeConfigDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            performanceReadmeConfigDetailDAO.deleteSoft(keys);
        }
    }

    @Override
    public void deleteSoftByConfigId(Long configId) {
        performanceReadmeConfigDetailDAO.deleteSoftByConfigId(configId);
    }

}
