package com.elitesland.tw.tw5.server.prd.copartner.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeUserDetailPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeUserDetailQuery;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeUserDetailService;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeUserDetailVO;
import com.elitesland.tw.tw5.server.prd.copartner.convert.PerformanceReadmeUserDetailConvert;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeUserDetailDAO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeUserDetailDO;
import com.elitesland.tw.tw5.server.prd.copartner.repo.PerformanceReadmeUserDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 合伙人绩效自述表
 *
 * @author carl
 * @date 2024-06-24
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PerformanceReadmeUserDetailServiceImpl extends BaseServiceImpl implements PerformanceReadmeUserDetailService {

    private final PerformanceReadmeUserDetailRepo performanceReadmeUserDetailRepo;
    private final PerformanceReadmeUserDetailDAO performanceReadmeUserDetailDAO;

    @Override
    public PagingVO<PerformanceReadmeUserDetailVO> queryPaging(PerformanceReadmeUserDetailQuery query) {
        return performanceReadmeUserDetailDAO.queryPaging(query);
    }

    @Override
    public List<PerformanceReadmeUserDetailVO> queryListDynamic(PerformanceReadmeUserDetailQuery query) {
        return performanceReadmeUserDetailDAO.queryListDynamic(query);
    }

    @Override
    public PerformanceReadmeUserDetailVO queryByKey(Long key) {
        PerformanceReadmeUserDetailDO entity = performanceReadmeUserDetailRepo.findById(key).orElseGet(PerformanceReadmeUserDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PerformanceReadmeUserDetailVO vo = PerformanceReadmeUserDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PerformanceReadmeUserDetailVO insert(PerformanceReadmeUserDetailPayload payload) {
        PerformanceReadmeUserDetailDO entityDo = PerformanceReadmeUserDetailConvert.INSTANCE.toDo(payload);
        return PerformanceReadmeUserDetailConvert.INSTANCE.toVo(performanceReadmeUserDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PerformanceReadmeUserDetailVO update(PerformanceReadmeUserDetailPayload payload) {
        PerformanceReadmeUserDetailDO entity = performanceReadmeUserDetailRepo.findById(payload.getId()).orElseGet(PerformanceReadmeUserDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PerformanceReadmeUserDetailDO entityDo = PerformanceReadmeUserDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PerformanceReadmeUserDetailConvert.INSTANCE.toVo(performanceReadmeUserDetailRepo.save(entity));
    }

//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public long updateByKeyDynamic(PerformanceReadmeUserDetailPayload payload) {
//        PerformanceReadmeUserDetailDO entity = performanceReadmeUserDetailRepo.findById(payload.getId()).orElseGet(PerformanceReadmeUserDetailDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        long result = performanceReadmeUserDetailDAO.updateByKeyDynamic(payload);
//        return result;
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void deleteSoft(List<Long> keys) {
//        if (!keys.isEmpty()) {
//            performanceReadmeUserDetailDAO.deleteSoft(keys);
//        }
//    }

    @Override
    public void deleteSoftByConfigUserId(Long configUserId) {
        performanceReadmeUserDetailDAO.deleteSoftByConfigUserId(configUserId);
    }

}
