package com.elitesland.tw.tw5.server.prd.crm.amap.service;


import com.elitesland.tw.tw5.api.prd.crm.amap.query.AmapAroundQuery;
import com.elitesland.tw.tw5.api.prd.crm.amap.query.AmapTextQuery;
import com.elitesland.tw.tw5.api.prd.crm.amap.serivce.AmapSerivce;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.server.common.dto.gaode.GaoDeRoot;
import com.elitesland.tw.tw5.server.common.dto.gaode.Pois;
import com.elitesland.tw.tw5.server.common.util.GeodesyUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 高德接口
 *
 * @author duwh
 * @date 2023/05/22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AmapSerivceImpl implements AmapSerivce {

    private final GeodesyUtil geodesyUtil;
    @Autowired
    private BusinessPartnerService businessPartnerService;

    /**
     * 附近的客户
     *
     * 周边搜索 (POI 高德)
     *
     * https://lbs.amap.com/api/webservice/guide/api/search/#around
     *
     * @param query 查询
     * @return {@link Object}
     */
    @Override
    public Object around(AmapAroundQuery query) {
        String location = query.getLocation();
        if (StringUtils.hasText(location)) {
            if (ObjectUtils.isEmpty(query.getTypes())) {
                query.setTypes("公司企业|知名企业|公司|广告装饰|建筑公司|医药公司|机械电子|冶金化工|网络科技|商业贸易|电信公司|矿产公司|工厂");
            }
            if (ObjectUtils.isEmpty(query.getRadius())) {
                query.setRadius(1000);
            }
//            String[] locationArr = location.split(",");
            // 行业筛选 关键字模糊匹配
            GaoDeRoot around = geodesyUtil.around(location, query.getKeywords(), query.getCity(), query.getSortrule(), query.getOffset(), query.getPage(), query.getRadius(), query.getTypes());
            if (around.getStatus().equals("1")) {
                List<Pois> pois = around.getPois();
                List<BusinessPartnerSimpleVO> businessPartnerSimpleVOS = businessPartnerService.queryNearCustomerList();
                pois.forEach(poi -> {
//                    String targetLocation = poi.getLocation();
//                    String[] targetLocationArr = targetLocation.split(",");
//                    // 计算距离
//                    double distanceDiff = geodesyUtil.getDistance(Double.parseDouble(locationArr[0]), Double.parseDouble(locationArr[1]), Double.parseDouble(targetLocationArr[0]), Double.parseDouble(targetLocationArr[1]));
//                    poi.setDistanceDifference(distanceDiff + "");

                    // 根据名称 匹配是否是客户
                    long count = businessPartnerSimpleVOS.stream().filter(businessPartnerVO -> StringUtils.hasText(businessPartnerVO.getPartnerName())&&businessPartnerVO.getPartnerName().trim().equals(poi.getName().trim())).count();
                    if (count > 0) {
                        poi.setCustomerFlag(true);
                    }
                });
            }
            return around;
        }
        return null;
    }

    /**
     * 关键字搜索
     *
     * @param query 查询
     * @return {@link Object}
     */
    @Override
    public Object text(AmapTextQuery query) {
        if (ObjectUtils.isEmpty(query.getTypes())) {
            query.setTypes("公司企业|知名企业|公司|广告装饰|建筑公司|医药公司|机械电子|冶金化工|网络科技|商业贸易|电信公司|矿产公司|工厂");
        }
        // 行业筛选 关键字模糊匹配
        GaoDeRoot text = geodesyUtil.text(query.getKeywords(), query.getCity(), query.getCitylimit(),query.getChildren(), query.getOffset(), query.getPage(),  query.getTypes());
        return text;
    }


}
