package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmGiftListPayload;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmGiftListVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmGiftListService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 礼品单
 *
 * @author xxb
 * @date 2023-08-31
 */
@Api(tags = "礼品单")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/crmGiftList")
@Slf4j
public class CrmGiftListController {

    private final CrmGiftListService crmGiftListService;

    /**
     * 礼品单流程-新增
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("create")
    @UdcNameClass
    @ApiOperation("礼品单流程-新增")
    public TwOutputUtil<CrmGiftListVO> create() {
        return TwOutputUtil.ok(crmGiftListService.create());
    }

    /**
     * 礼品单-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @UdcNameClass
    @ApiOperation("礼品单-新增")
    public TwOutputUtil<CrmGiftListVO> insert(@RequestBody CrmGiftListPayload payload) {
        return TwOutputUtil.ok(crmGiftListService.insert(payload));
    }

    /**
     * 礼品单-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("礼品单-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CrmGiftListPayload payload) {
        return TwOutputUtil.ok(crmGiftListService.updateByKeyDynamic(payload));
    }

    /**
     * 礼品单-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("礼品单-主键查询")
    public TwOutputUtil<CrmGiftListVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(crmGiftListService.queryByKey(key));
    }

    /**
     * 获取可以礼品申请的用户
     * @return
     */
    @GetMapping("/queryUserByGiftRole")
    @ApiOperation("获取可以礼品申请的用户")
    public TwOutputUtil queryUserByGiftRole() {
        return TwOutputUtil.ok(crmGiftListService.queryUserByGiftRole());
    }


//    /**
//     * 礼品单-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("礼品单-更新")
//    public TwOutputUtil<CrmGiftListVO> update(@RequestBody CrmGiftListPayload payload){
//        return TwOutputUtil.ok(crmGiftListService.update(payload));
//    }

//    /**
//     * 礼品单-分页
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("礼品单-分页")
//    public TwOutputUtil<PagingVO<CrmGiftListVO>> paging(CrmGiftListQuery query) {
//        return TwOutputUtil.ok(crmGiftListService.queryPaging(query));
//    }
//
//    /**
//     * 礼品单-查询列表
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("礼品单-查询列表")
//    public TwOutputUtil<List<CrmGiftListVO>> queryList(CrmGiftListQuery query) {
//        return TwOutputUtil.ok(crmGiftListService.queryListDynamic(query));
//    }
//
//    /**
//     * 礼品单-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("礼品单-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        crmGiftListService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}
