package com.elitesland.tw.tw5.server.prd.crm.controller;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityReviewPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityReviewQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityReviewService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityReviewVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 商机review
 *
 * @author zoey
 * @date 2023-11-01
 */
@Api(tags = "商机review")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/crmOpportunityReview")
@Slf4j
public class CrmOpportunityReviewController {

    private final CrmOpportunityReviewService crmOpportunityReviewService;

    /**
     * 商机review-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("商机review-新增")
    public TwOutputUtil<CrmOpportunityReviewVO> insert(@RequestBody CrmOpportunityReviewPayload payload){
        return TwOutputUtil.ok(crmOpportunityReviewService.insert(payload));
    }

    /**
     * 商机review-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("商机review-更新")
    public TwOutputUtil<CrmOpportunityReviewVO> update(@RequestBody CrmOpportunityReviewPayload payload){
        return TwOutputUtil.ok(crmOpportunityReviewService.update(payload));
    }

    /**
     * 商机review-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("商机review-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CrmOpportunityReviewPayload payload){
        return TwOutputUtil.ok(crmOpportunityReviewService.updateByKeyDynamic(payload));
    }

    /**
     * 商机review-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("商机review-主键查询")
    public TwOutputUtil<CrmOpportunityReviewVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(crmOpportunityReviewService.queryByKey(key));
    }

    /**
     * 商机review-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("商机review-分页")
    public TwOutputUtil<PagingVO<CrmOpportunityReviewVO>> paging(CrmOpportunityReviewQuery query) {
        return TwOutputUtil.ok(crmOpportunityReviewService.queryPaging(query));
    }

    /**
     * 商机review-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("商机review-查询列表")
    public TwOutputUtil<List<CrmOpportunityReviewVO>> queryList(CrmOpportunityReviewQuery query) {
        return TwOutputUtil.ok(crmOpportunityReviewService.queryListDynamic(query));
    }

    /**
     * 商机review-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("商机review-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        crmOpportunityReviewService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
