package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Author carl.wang
 * @Description 市场计划表
 * @Date
 **/
@Entity
@Table(name = "crm_opportunity_competitor", indexes = {
        @Index(name = "oppo_index", columnList = "oppo_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_competitor", comment = "商机竞争对手表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityCompetitorDO extends BaseModel {

    @Comment("商机ID")
    @Column(name = "oppo_id", nullable = false)
    private Long oppoId;

    @Comment("tw4.0商机竞争对手ID")
    @Column(name = "competitor_id_v4")
    private Long competitorIdV4;

    @Comment("对手名称")
    @Column()
    private String competitorName;

    @Comment("产品名称")
    @Column()
    private String productName;

    @Comment("分析")
    @Column()
    private String analyse;

    @Comment("对策")
    @Column()
    private String treatment;

}
