package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.tw.tw5.api.udc.UdcName;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Author carl.wang
 * @Description 商机表
 * @Date
 **/
@Entity
@Table(name = "crm_opportunity", indexes = {
        @Index(name = "project_index", columnList = "project_id"),
        @Index(name = "leads_index", columnList = "leads_id"),
        @Index(name = "formal_customer_index", columnList = "formal_customer_id"),

})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity", comment = "商机表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityDO extends BaseModel {

    @Comment("项目id")
    @Column(name = "project_id", nullable = false)
    private Long projectId;

    @Comment("活动id")
    @Column(name = "act_id")
    private Long actId;

    @Comment("线索id")
    @Column(name = "leads_id")
    private Long leadsId;

    @Comment("tw4.0商机ID")
    @Column(name = "oppo_id_v4")
    private Long oppoIdV4;

    @FieldUpdateLog(fieldName = "销售产品")
    @Comment("销售产品")
    @Column()
    private String saleProduct;

    @FieldUpdateLog(fieldName = "客户区域", selectionKey = "crm:customer_region")
    @Comment("客户区域")
    @Column()
    private String custRegion;

    @FieldUpdateLog(fieldName = "是否老客户", selectionKey = "crm:oppo:yn")
    @Comment("是否老客户[crm:oppo:yn]")//0:Y,1:N
    @Column()
    private Integer isOldCust;

    @Comment("客户id")//是老客户才会选择
    @Column()
    private Long custBookId;

    @FieldUpdateLog(fieldName = "客户名称")
    @Comment("客户名称")
    @Column()
    private String custBookName;

    @FieldUpdateLog(fieldName = "客户项目")
    @Comment("客户项目")
    @Column()
    private String custProject;

    @FieldUpdateLog(fieldName = "客户联系人")
    @Comment("客户联系人")
    @Column()
    private String contactName;

    @FieldUpdateLog(fieldName = "客户联系人电话")
    @Comment("客户联系人电话")
    @Column()
    private String contactPhone;

    @FieldUpdateLog(fieldName = "客户联系人部门")
    @Comment("客户联系人部门")
    @Column()
    private String contactDept;

    @FieldUpdateLog(fieldName = "客户联系人岗位")
    @Comment("客户联系人岗位")
    @Column()
    private String contactPosition;

    @FieldUpdateLog(fieldName = "企业主页")
    @Comment("企业主页")
    @Column()
    private String contactWebsite;

    @FieldUpdateLog(fieldName = "客户性质", selectionKey = "crm:company_nature")
    @Comment("客户性质")
    @Column()
    private String custProp;

    @FieldUpdateLog(fieldName = "客户行业", selectionKey = "crm:leads_customer_industry")
    @Comment("客户行业")
    @Column()
    private String custIdst;

    @FieldUpdateLog(fieldName = "预计签单时间")
    @Comment("预计签单时间")
    @Column()
    private LocalDate forecastWinDate;

    @FieldUpdateLog(fieldName = "预计签单金额")
    @Comment("预计签单金额")
    @Column()
    private BigDecimal forecastAmount;

    @FieldUpdateLog(fieldName = "成单概率", selectionKey = "crm:oppo:trans_proba")
    @Comment("成单概率")
    @Column()
    private String probability;

    @FieldUpdateLog(fieldName = "成单概率不清楚原因")
    @Comment("成单概率不清楚原因")
    @Column()
    private String probabilityHint;

    @Comment("币种")
    @Column()
    private String currCode;

    @FieldUpdateLog(fieldName = "销售阶段", selectionKey = "crm:oppo:sale_stage")
    @Comment("销售阶段")
    @Column()
    private String salePhase;

    @FieldUpdateLog(fieldName = "交付地点")
    @Comment("交付地点")
    @Column()
    private String deliveryAddress;

    @FieldUpdateLog(fieldName = "商机级别", selectionKey = "crm:oppo:level")
    @Comment("商机级别")
    @Column()
    private String oppoLevel;

    @FieldUpdateLog(fieldName = "是否需要合作伙伴", selectionKey = "crm:oppo:yn")
    @Comment("是否需要合作伙伴")//0:Y,1:N
    @Column()
    private Integer isNeedPartner;

    @Comment("关联合作伙伴Id")//
    @Column()
    private Long coopBookId;

    @Comment("关联合作伙伴名称")//
    @Column()
    private String coopBookName;

    @Comment("合作伙伴描述")
    @Column()
    private String partnerDesc;

    @FieldUpdateLog(fieldName = "售前bu", selectionKey = "BU")
    @Comment("售前bu")
    @Column()
    private Long preSaleOrgId;

    @FieldUpdateLog(fieldName = "售前负责人", selectionKey = "USER")
    @Comment("售前负责人")
    @Column()
    private Long preSaleUserId;

    @FieldUpdateLog(fieldName = "项目难度", selectionKey = "crm:oppo:difficulty_level")
    @Comment("项目难度")
    @Column()
    private String projectDifficult;

    @FieldUpdateLog(fieldName = "项目重要度", selectionKey = "crm:oppo:Importance")
    @Comment("项目重要度")
    @Column()
    private String projectImportance;

    @FieldUpdateLog(fieldName = "交付部门", selectionKey = "BU")
    @Comment("交付BU_ID")
    @Column()
    private Long deliOrgId;

    @FieldUpdateLog(fieldName = "交付负责人", selectionKey = "USER")
    @Comment("交付负责人ID")
    @Column()
    private Long deliUserId;

    @FieldUpdateLog(fieldName = "方案难度", selectionKey = "crm:oppo:difficulty_level")
    @Comment("方案难度")
    @Column()
    private String solutionDifficulty;

    @FieldUpdateLog(fieldName = "方案重要度", selectionKey = "crm:oppo:Importance")
    @Comment("方案重要度")
    @Column()
    private String solutionImportance;

    @FieldUpdateLog(fieldName = "副签单部门", selectionKey = "BU")
    @Comment("合作(副)签单BU_ID")
    @Column()
    private Long coOrgId;

    @FieldUpdateLog(fieldName = "副签单负责人", selectionKey = "USER")
    @Comment("合作(副)签单负责人ID")
    @Column()
    private Long coUserId;

    @FieldUpdateLog(fieldName = "副交付部门", selectionKey = "BU")
    @Comment("合作(副)交付BU_ID")
    @Column()
    private Long codeliOrgId;

    @FieldUpdateLog(fieldName = "副交付负责人", selectionKey = "USER")
    @Comment("合作(副)交付负责人ID")
    @Column()
    private Long codeliUserId;

    @Comment("来源类型")
    @Column()
    private String sourceType;

    @Comment("内部来源BU_ID")
    @Column()
    private Long internalOrgId;

    @Comment("内部来源人ID")
    @Column()
    private Long internalUserId;

    @Comment("外部线索来源")
    @Column()
    private String externalIden;

    @Comment("外部来源人")
    @Column()
    private String externalName;

    @Comment("外部来源电话")
    @Column()
    private String externalPhone;

    @FieldUpdateLog(fieldName = "利益承诺")
    @Comment("利益承诺")
    @Column()
    private String profitDesc;

    @Comment("关联正式客户id")
    @Column(name = "formal_customer_id")
    private Long formalCustomerId;

    /**
     * 易稻壳对应itemId
     */
    @Comment("易稻壳对应itemId")
    @Column()
    private String itemId;

    @FieldUpdateLog(fieldName = "验证状态", selectionKey = "crm:oppo:check_status")
    @Comment("验证状态[crm:oppo:check_status]")
    @Column(length = 40)
    private String checkStatus;

    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;

    //==============补充字段==============

    /**
     * 是否实施过本公司产品
     */
    @Comment("是否实施过本公司产品")
    @Column()
    private Long isImplementation;
    /**
     * 实施情况
     */
    @Comment("实施情况")
    @Column()
    private String implementCondition;
    /**
     * 上线要求
     */
    @Comment("上线要求")
    @Column()
    private String onboarding;
    /**
     * 项目预算情况
     */
    @Comment("项目预算情况")
    @Column()
    private String proResource;
    /**
     * 项目发起原因
     */
    @Comment("项目发起原因")
    @Column()
    private String proInitiateReason;
    /**
     * 项目关键决策人描述
     */
    @Comment("项目关键决策人描述")
    @Column()
    private String proPolicymakerDesc;
    /**
     * 接触部门描述
     */
    @Comment("接触部门描述")
    @Column()
    private String contactBUDesc;
    /**
     * 涉及本公司产品与服务
     */
    @Comment("涉及本公司产品与服务")
    @Column()
    private String productServe;
    /**
     * 对标客户
     */
    @Comment("对标客户")
    @Column()
    private String benchmarkingCust;
    /**
     * 客户年营业额（万元）
     */
    @Comment("客户年营业额（万元）")
    @Column()
    private String custTurnoverYear;
    /**
     * 是否是上市公司
     */
    @Comment("是否是上市公司")
    @Column()
    private Long isListedCompany;
    /**
     * 方案情况(UDC)
     */
    @Comment("方案情况(UDC)")
    @Column()
    private String programSituation;
    /**
     * 团队资源(UDC)
     */
    @Comment("团队资源(UDC)")
    @Column()
    private String teamResources;
    /**
     * 商务资源(UDC)
     */
    @Comment("商务资源(UDC)")
    @Column()
    private String businessResources;
    /**
     * 副售前负责人
     */
    @Comment("副售前负责人")
    @Column()
    private Long  codePreSaleUserId;

    @Comment("上级主管部门")
    @Column()
    private String parentManageBu;

}
