package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 成单率分值配置
 *
 * @author likunpeng
 * @date 2023-11-02
 */
@Entity
@Table(name = "crm_opportunity_score_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_score_config", comment = "成单率分值配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityScoreConfigDO extends BaseModel implements Serializable  {
    /** 承担率 */
    @Comment("承担率")
    @Column()
    private String probabilityName;
    /** 分值区间1 */
    @Comment("分值区间1")
    @Column()
    private BigDecimal scoreMin;
    /** 分值区间2 */
    @Comment("分值区间2")
    @Column()
    private BigDecimal scoreMax;
    /** 说明 */
    @Comment("说明")
    @Column()
    private String imply;

    public void copy(CrmOpportunityScoreConfigDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
