package com.elitesland.tw.tw5.server.prd.crm.repo;

import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsOffshoreDO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.*;
import org.springframework.lang.Nullable;

import javax.transaction.Transactional;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/6/1 - 0:07
 */
public interface CrmLeadsOffshoreRepo extends JpaRepository<CrmLeadsOffshoreDO,Long>, JpaSpecificationExecutor<CrmLeadsOffshoreDO> {

    int countByOffshore_Id(Long offshoreId);

    List<CrmLeadsOffshoreDO> findByOffshore_Id(Long offshoreId);


    @Override
    @EntityGraph(value = "leadsoffshore.list")
    List<CrmLeadsOffshoreDO> findAll(@Nullable Specification<CrmLeadsOffshoreDO> spec);

    @Override
    @EntityGraph(value = "leadsoffshore.list")
    long count(@Nullable Specification<CrmLeadsOffshoreDO> spec);

    @Override
    @EntityGraph(value = "leadsoffshore.list")
    Page<CrmLeadsOffshoreDO> findAll(@Nullable Specification<CrmLeadsOffshoreDO> spec, Pageable pageable);


    @Transactional
    @Modifying
    @Query(value = "update crm_leads_offshore lo set lo.leads_offshores_order = ?2 where lo.id = ?1",nativeQuery = true)
    void saveIndex(Long id, int index);


    @Query(value = "select count(od.id) from CrmLeadsOffshoreDO od where od.leads.id=?1 and od.offshore.id=?2")
    int getExistNum(Long leadsId, Long offshoreId);

}
