package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeopleWorkPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleWorkQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleWorkService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleWorkVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmPeopleWorkConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPeopleDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPeopleWorkDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPeopleWorkDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleWorkRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 人脉-工作经历
 *
 * @author carl
 * @date 2022/12/07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmPeopleWorkServiceImpl implements CrmPeopleWorkService {

    private final CrmPeopleWorkRepo repo;

    private final CrmPeopleWorkDAO dao;

    private final CrmPeopleDAO daoPeople;

    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CrmPeopleWorkVO insertOrUpdate(CrmPeopleWorkPayload payload) {
        //核验数据
        check(payload);
        CrmPeopleWorkDO peopleWorkDO = CrmPeopleWorkConvert.INSTANCE.toDo(payload);
        String name = PrdSystemLogEnum.CREATE.getDesc();
        if (!ObjectUtils.isEmpty(payload.getId())) {
            //更新
            name = PrdSystemLogEnum.UPDATE.getDesc();
            if (!"1".equals(peopleWorkDO.getWorkStatus())) {
                CrmPeopleWorkVO peopleWorkVO = dao.queryByKey(payload.getId());
                if ("1".equals(peopleWorkVO.getWorkStatus())) {
                    //如果是在职工作变为离职，要把人脉关联的客户和客户经营设为null
                    repo.updataPeopleClearRefById(payload.getPeopleId());
                }
            }
        }
        if (ObjectUtils.isEmpty(payload.getIsInitia()) || !payload.getIsInitia()) {
            //首先判断工作状态是否为在职
            if ("1".equals(peopleWorkDO.getWorkStatus())) {
                if (peopleWorkDO.getCustomerId() == null) {
                    CrmPeopleVO peopleVO = daoPeople.queryByKey(payload.getPeopleId());
                    Long operId = peopleVO.getOperId();
                    if (peopleVO.getOperId() != null && !peopleVO.getOperationName().equals(peopleWorkDO.getCompanyName())) {
                        operId = null;
                    }
                    //把人脉的关联的客户赋值
                    repo.updataPeopleCustomerAndOperById(payload.getPeopleId(), peopleWorkDO.getCustomerId(), operId, peopleWorkDO.getCompanyName(), peopleWorkDO.getJobs());
                }
                //把人脉的关联的客户赋值
                repo.updataPeopleCustomerById(payload.getPeopleId(), peopleWorkDO.getCustomerId(), peopleWorkDO.getCompanyName(), peopleWorkDO.getJobs());
            }
        }
        peopleWorkDO = repo.save(peopleWorkDO);
        //保存日志
        logService.saveNewLog(peopleWorkDO.getPeopleId(),
                PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(),
                name + PrdSystemObjectEnum.CRM_PEOPLE_WORK.getDesc());
        return null;
    }

    @Override
    public CrmPeopleWorkVO queryByKey(Long key) {
        CrmPeopleWorkVO peopleWorkVO = dao.queryByKey(key);
        transferData(peopleWorkVO);

        return peopleWorkVO;
    }

    @Override
    public List<CrmPeopleWorkVO> queryList(CrmPeopleWorkQuery query) {

        List<CrmPeopleWorkVO> peopleWorkVOS = dao.queryList(query);
        peopleWorkVOS.forEach(peopleWorkVO -> transferData(peopleWorkVO));
        return peopleWorkVOS;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteSoft(List<Long> keys) {

        CrmPeopleWorkVO educateVO = dao.queryByKey(keys.get(0));
        if (!ObjectUtils.isEmpty(educateVO)) {
            if ("1".equals(educateVO.getWorkStatus())) {
                throw TwException.error("", "在职工作不可删除，请核验！");
            }
            dao.deleteSoft(keys);
            logService.saveNewLog(educateVO.getPeopleId(),
                    PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(),
                    PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.CRM_PEOPLE_WORK.getDesc());

        }
    }

    /**
     * 数据翻译
     *
     * @param vo
     */
    void transferData(CrmPeopleWorkVO vo) {
        if (StringUtils.hasText(vo.getCustomerName())) {
            vo.setCompanyName(vo.getCustomerName());
        }
    }

    /**
     * 核验工作经历数据
     *
     * @param payload
     */
    void check(CrmPeopleWorkPayload payload) {
        if (ObjectUtils.isEmpty(payload.getPeopleId())) {
            throw TwException.error("", "关联人脉不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getCustomerId()) && ObjectUtils.isEmpty(payload.getCompanyName())) {
            throw TwException.error("", "关联客户不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getCustType())) {
            throw TwException.error("", "类型不能为空，请核验！");
        }
        //2023/11/10 沟通后 校验去掉 因为商机/线索新增客户可能会新增联系人 同时会新增新增人脉
//        if (ObjectUtils.isEmpty(payload.getJobs())) {
//            throw TwException.error("", "职位不能为空，请核验！");
//        }
        if (ObjectUtils.isEmpty(payload.getWorkStatus())) {
            throw TwException.error("", "状态不能为空，请核验！");
        }

        //校验是否不存在重名公司
        CrmPeopleWorkQuery workQuery = CrmPeopleWorkConvert.INSTANCE.toQuery(payload);
        workQuery.setWorkStatus(null);
        List<CrmPeopleWorkVO> peopleWorkVOS = dao.queryList(workQuery);
        if (!ObjectUtils.isEmpty(peopleWorkVOS)) {
            throw TwException.error("", "该工作经历已存在，请核验！");
        }
        //校验是否已经存在在职工作
        if ("1".equals(payload.getWorkStatus())) {
            CrmPeopleWorkQuery workQuery0 = new CrmPeopleWorkQuery();
            workQuery0.setId(payload.getId());
            workQuery0.setPeopleId(payload.getPeopleId());
            workQuery0.setWorkStatus("1");
            List<CrmPeopleWorkVO> peopleWorkVOS0 = dao.queryList(workQuery0);
            if (!ObjectUtils.isEmpty(peopleWorkVOS0)) {
                throw TwException.error("", "已存在在职工作，请核验！");
            }
        }
    }

}
