package com.elitesland.tw.tw5.server.prd.file.controller;

import com.elitesland.tw.tw5.api.prd.file.payload.PrdFileFolderPayload;
import com.elitesland.tw.tw5.api.prd.file.query.PrdFileFolderQuery;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileFolderService;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileFolderVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 附件-文件夹
 *
 * @author duwh
 * @date 2022/09/22
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/file")
@Slf4j
public class PrdFileFolderController {

    private final PrdFileFolderService service;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/folder")
    public TwOutputUtil insert(PrdFileFolderPayload payload) {
        return TwOutputUtil.ok(service.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/folder")
    public TwOutputUtil update(PrdFileFolderPayload payload) {
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/folder/{key}")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        PrdFileFolderVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/folder/paging")
    public TwOutputUtil paging(PrdFileFolderQuery query) {
        PagingVO<PrdFileFolderVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/folder/list")
    public TwOutputUtil queryList(PrdFileFolderQuery query) {
        List<PrdFileFolderVO> vos = service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/folder/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
