package com.elitesland.tw.tw5.server.prd.file.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

/**
 * 附件 文件单据关联表
 *
 * @author duwh
 * @date 2022/09/23
 */
@Entity
@Table(name = "prd_file_ref")
@org.hibernate.annotations.Table(appliesTo = "prd_file_ref", comment = "附件-文件单据关联表")
@Getter
@Setter
@ToString
@Where(clause = "delete_flag = 0")
public class PrdFileRefDO extends BaseModel implements Serializable {

    @Serial
    private static final long serialVersionUID = 1982168960995188114L;

    @Comment("文件主键")
    @Column()
    private Long fileId;

    @Comment("单据主键")
    @Column()
    private Long docId;

    @Comment("单据类型")
    @Column()
    private String docType;

    @Comment("业务类型")
    @Column()
    private String businessType;


    public PrdFileRefDO() {
    }

    public void copy(PrdFileRefDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
