package com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity;

import com.elitesland.tw.tw5.server.prd.humanresources.base.WorkflowBaseDO;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

import org.hibernate.annotations.Where;


/**
 * @author : WWW
 * @date : 2023-11-3
 * @desc : baseBu变更
 */

@Entity
@Table(name = "prd_base_bu_change")
@org.hibernate.annotations.Table(appliesTo = "prd_base_bu_change", comment = "baseBu变更")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdBaseBuChangeDO extends WorkflowBaseDO {


    /**
     * 用户id
     */
    @Column(name = "user_id", columnDefinition = "bigint(20) comment '用户id'")
    private Long userId;

    /**
     * 员工id
     */
    @Column(name = "emp_id", columnDefinition = "bigint(20) comment '员工id'")
    private Long empId;

    /**
     * 员工名称
     */
    @Column(name = "emp_name", columnDefinition = "varchar(255) comment '员工名称'")
    private String empName;

    /**
     * 原上级id
     */
    @Column(name = "old_p_emp_id", columnDefinition = "bigint(20) comment '原上级id'")
    private Long oldPEmpId;

    /**
     * 原上级用户Id
     */
    @Column(name = "old_p_user_id", columnDefinition = "bigint(20) comment '原上级用户Id'")
    private Long oldPUserId;

    /**
     * 原上级名称
     */
    @Column(name = "old_p_emp_name", columnDefinition = "varchar(255) comment '原上级名称'")
    private String oldPEmpName;

    /**
     * 新上级id
     */
    @Column(name = "new_p_emp_id", columnDefinition = "bigint(20) comment '新上级id'")
    private Long newPEmpId;

    /**
     * 新上级用户Id
     */
    @Column(name = "new_p_user_id", columnDefinition = "bigint(20) comment '新上级用户Id'")
    private Long newPUserId;

    /**
     * 新上级名称
     */
    @Column(name = "new_p_emp_name", columnDefinition = "varchar(255) comment '新上级名称'")
    private String newPEmpName;

    /**
     * 主能力
     */
    @Column(name = "main_ability", columnDefinition = "varchar(255) comment '主能力'")
    private String mainAbility;

    /**
     * 次能力
     */
    @Column(name = "aux_ability", columnDefinition = "varchar(255) comment '次能力'")
    private String auxAbility;

    /**
     * 当量系数
     */
    @Column(name = "dl_ratio", columnDefinition = "decimal(20,2) comment '当量系数'")
    private BigDecimal dlRatio;

    /**
     * 入职日期
     */
    @Column(name = "entry_date", columnDefinition = "date comment '入职日期'")
    private LocalDate entryDate;

    /**
     * 原加入日期
     */
    @Column(name = "old_join_date", columnDefinition = "date comment '原加入日期'")
    private LocalDate oldJoinDate;

    /**
     * 新加入日期
     */
    @Column(name = "new_join_date", columnDefinition = "date comment '新加入日期'")
    private LocalDate newJoinDate;

    /**
     * 合作方式
     */
    @Column(name = "cooperate_type", columnDefinition = "varchar(255) comment '合作方式'")
    private String cooperateType;

    /**
     * 职级
     */
    @Column(name = "job_grade", columnDefinition = "varchar(50) comment '职级'")
    private String jobGrade;

    /**
     * 职级生效日期
     */
    @Column(name = "job_grade_active_date", columnDefinition = "date comment '职级生效日期'")
    private LocalDate jobGradeActiveDate;

    /**
     * 发薪方式
     */
    @Column(name = "salary_type", columnDefinition = "varchar(255) comment '发薪方式'")
    private String salaryType;

    /**
     * 发薪周期
     */
    @Column(name = "salary_cycle", columnDefinition = "varchar(255) comment '发薪周期'")
    private String salaryCycle;

    /**
     * 原buId
     */
    @Column(name = "old_bu_id", columnDefinition = "bigint(20) comment '原buId'")
    private Long oldBuId;

    /**
     * 原bu名称
     */
    @Column(name = "old_bu_name", columnDefinition = "varchar(255) comment '原bu名称'")
    private String oldBuName;

    /**
     * 新buid
     */
    @Column(name = "new_bu_id", columnDefinition = "bigint(20) comment '新buid'")
    private Long newBuId;

    /**
     * 新bu名称
     */
    @Column(name = "new_bu_name", columnDefinition = "varchar(255) comment '新bu名称'")
    private String newBuName;

    /**
     * 原角色id
     */
    @Column(name = "old_role_id", columnDefinition = "bigint(20) comment '原角色id'")
    private Long oldRoleId;

    /**
     * 原角色编码
     */
    @Column(name = "old_role_code", columnDefinition = "varchar(255) comment '原角色编码'")
    private String oldRoleCode;

    /**
     * 原角色名称
     */
    @Column(name = "old_role_name", columnDefinition = "varchar(255) comment '原角色名称'")
    private String oldRoleName;

    /**
     * 新角色id
     */
    @Column(name = "new_role_id", columnDefinition = "varchar(1000) comment '新角色id'")
    private String newRoleId;

    /**
     * 新角色编码
     */
    @Column(name = "new_role_code", columnDefinition = "varchar(255) comment '新角色编码'")
    private String newRoleCode;

    /**
     * 新角色名称
     */
    @Column(name = "new_role_name", columnDefinition = "varchar(255) comment '新角色名称'")
    private String newRoleName;

    /**
     * 变更说明
     */
    @Column(name = "change_desc", columnDefinition = "varchar(255) comment '变更说明'")
    private String changeDesc;

    /**
     * 申请人id
     */
    @Column(name = "apply_user_id", columnDefinition = "bigint(20) comment '申请人id'")
    private Long applyUserId;

    /**
     * 申请人
     */
    @Column(name = "apply_user_name", columnDefinition = "varchar(255) comment '申请人'")
    private String applyUserName;

    /**
     * 申请日期
     */
    @Column(name = "apply_date", columnDefinition = "date comment '申请日期'")
    private LocalDate applyDate;

    /**
     * 原当量系数
     */
    @Column(name = "old_dl_ratio", columnDefinition = "decimal(20,2) comment '原当量系数'")
    private BigDecimal oldDlRatio;
}

