package com.elitesland.tw.tw5.server.prd.humanresources.eval.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigDtlVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置明细表
 */

@RestController
@RequestMapping("/api/prdEvaluateConfigDtl")
@RequiredArgsConstructor
@Api(value = "评价配置明细表", tags = {"评价配置明细表"})
public class PrdEvaluateConfigDtlController {

    private final PrdEvaluateConfigDtlService prdEvaluateConfigDtlService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-评价配置明细表")
    public TwOutputUtil<PrdEvaluateConfigDtlVO> get(@PathVariable Long id) {

        PrdEvaluateConfigDtlVO res = prdEvaluateConfigDtlService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-评价配置明细表")
    public TwOutputUtil<Long> save(@RequestBody PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload) {

        PrdEvaluateConfigDtlVO res = prdEvaluateConfigDtlService.save(prdEvaluateConfigDtlPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-评价配置明细表")
    public TwOutputUtil<Long> update(@RequestBody PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload) {

        PrdEvaluateConfigDtlVO res = prdEvaluateConfigDtlService.update(prdEvaluateConfigDtlPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-评价配置明细表")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdEvaluateConfigDtlService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-评价配置明细表")
    public TwOutputUtil<PagingVO<PrdEvaluateConfigDtlVO>> page(PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery) {

        PagingVO<PrdEvaluateConfigDtlVO> res = prdEvaluateConfigDtlService.page(prdEvaluateConfigDtlQuery);
        return TwOutputUtil.ok(res);

    }


}

