package com.elitesland.tw.tw5.server.prd.humanresources.eval.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置表
 */

@Entity
@Table(name = "prd_evaluate_config")
@org.hibernate.annotations.Table(appliesTo = "prd_evaluate_config", comment = "评价配置表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdEvaluateConfigDO extends BaseModel {


    /**
     * 类别
     */
    @Column(name = "cate", columnDefinition = "varchar(255) comment '类别'")
    private String cate;

    /**
     * 类型
     */
    @Column(name = "type", columnDefinition = "varchar(255) comment '类型'")
    private String type;

    /**
     * 标准说明
     */
    @Column(name = "standard_desc", columnDefinition = "varchar(255) comment '标准说明'")
    private String standardDesc;


}

