package com.elitesland.tw.tw5.server.prd.humanresources.examination.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核范围
 */

@Entity
@Table(name = "prd_performance_exam_range")
@org.hibernate.annotations.Table(appliesTo = "prd_performance_exam_range", comment = "绩效考核范围")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdPerformanceExamRangeDO extends BaseModel {


    /**
     * 绩效考核id
     */
    @Column(name = "exam_id", columnDefinition = "bigint(20) comment '绩效考核id'")
    private Long examId;

    /**
     * 用户id
     */
    @Column(name = "user_id", columnDefinition = "bigint(20) comment '用户id'")
    private Long userId;

    /**
     * 资源id
     */
    @Column(name = "res_id", columnDefinition = "bigint(20) comment '资源id'")
    private Long resId;

    /**
     * buid
     */
    @Column(name = "bu_id", columnDefinition = "bigint(20) comment 'buid'")
    private Long buId;

    /**
     * bu名称
     */
    @Column(name = "bu_name", columnDefinition = "varchar(255) comment 'bu名称'")
    private String buName;

    /**
     * 入职时间
     */
    @Column(name = "enroll_date", columnDefinition = "date comment '入职时间'")
    private LocalDate enrollDate;

    /**
     * 资源类型
     */
    @Column(name = "res_type", columnDefinition = "varchar(50) comment '资源类型'")
    private String resType;

    /**
     * 合作方式
     */
    @Column(name = "coop_type", columnDefinition = "varchar(50) comment '合作方式'")
    private String coopType;

    /**
     * 资源名称
     */
    @Column(name = "res_name", columnDefinition = "varchar(255) comment '资源名称'")
    private String resName;
}

