package com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@Entity
@Table(name = "res_extry_exit_log", indexes = {
        @Index(name = "employee_index", columnList = "employee_id"),
})
@org.hibernate.annotations.Table(appliesTo = "res_extry_exit_log", comment = "资源-入离职记录表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ResEntryExitLogDO extends BaseModel {

    @Comment("员工ID")
    @Column(name = "employee_id", nullable = false)
    private Long employeeId;

    @Comment("编号")
    @Column()
    private Long logNo;

    @Comment("类型1")
    @Column()
    private String reasonType1;

    @Comment("类型2")
    @Column()
    private String reasonType2;

    @Comment("事由ID")
    @Column()
    private Long reasonId;

    @Comment("入职 离职日期")
    @Column()
    private String entryExitDate;

    @Comment("资源状态")
    @Column()
    private String resType;

    @Comment("公司")
    @Column()
    private Long bookId;

    @Comment("组织")
    @Column()
    private Long orgId;

    @Comment("城市")
    @Column()
    private String baseCity;

    @Comment("合作方式")
    @Column()
    private String coopType;

    @Comment("工作")
    @Column()
    private String job;

    @Comment("资源状态")
    @Column()
    private String resClass;

    @Comment("离职原因")
    @Column()
    private String leaveReason;

    @Comment("离职说明")
    @Column()
    private String leaveReasonDesc;


}
