package com.elitesland.tw.tw5.server.prd.humanresources.recommended.dao;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdRecruitPositionPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdRecruitPositionQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdRecruitPositionVO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity.PrdRecruitPositionDO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity.QPrdRecruitPositionDO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.repo.PrdRecruitPositionRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;

/**
 * 内部招聘管理
 *
 * @author zhangxiao
 * @date 2023-12-13
 */
@Repository
@RequiredArgsConstructor
public class PrdRecruitPositionDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PrdRecruitPositionRepo repo;
    private final QPrdRecruitPositionDO qdo = QPrdRecruitPositionDO.prdRecruitPositionDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdRecruitPositionVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdRecruitPositionVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 招聘编号
                qdo.jobNo,
                // 招聘名称
                qdo.jobTitle,
                // 招聘部门 （组织Id）
                qdo.baseBuId,
                // 工作地
                qdo.baseRegion,
                // 工作地说明
                qdo.baseRegionDesc,
                // 招聘人数
                qdo.recruitQty,
                // 工作类型 1、全职2、兼职
                qdo.workType,
                // 服务方式 1、现场 2、远程 3、按需
                qdo.serviceMode,
                // 时间要求 1、常规固定 2、灵活安排
                qdo.timeRequirement,
                // 岗位简介
                qdo.jobProfile,
                // 岗位要求
                qdo.jobRequirement,
                // 是否运行内部推荐(0,1)
                qdo.internalFlag,
                // 外部资源可见 1、可见(选择) 0、不可见
                qdo.externalVisible,
                // 1、招聘中 2、招聘完成 3、招聘取消
                qdo.recruitmentStatus,
                // 招聘负责人
                qdo.managerUserId,
                // 招聘分类一
                qdo.jobType1,
                // 招聘分类二
                qdo.jobType2
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdRecruitPositionVO> getJpaQueryWhere(PrdRecruitPositionQuery query) {
        JPAQuery<PrdRecruitPositionVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PrdRecruitPositionQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PrdRecruitPositionQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 主键id 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 招聘编号 精确 */
        if (!ObjectUtils.isEmpty(query.getJobNo())) {
            list.add(qdo.jobNo.like("%"+query.getJobNo()+"%"));
        }
        /** 招聘名称 精确 */
        if (!ObjectUtils.isEmpty(query.getJobTitle())) {
            list.add(qdo.jobTitle.like("%"+query.getJobTitle()+"%"));
        }
        /** 招聘部门 （组织Id） 精确 */
        if (!ObjectUtils.isEmpty(query.getBaseBuId())) {
            list.add(qdo.baseBuId.eq(query.getBaseBuId()));
        }
        /** 工作地 精确 */
        if (!ObjectUtils.isEmpty(query.getBaseRegion())) {
            list.add(qdo.baseRegion.eq(query.getBaseRegion()));
        }
        /** 工作地说明 精确 */
        if (!ObjectUtils.isEmpty(query.getBaseRegionDesc())) {
            list.add(qdo.baseRegionDesc.eq(query.getBaseRegionDesc()));
        }
        /** 招聘人数 精确 */
        if (!ObjectUtils.isEmpty(query.getRecruitQty())) {
            list.add(qdo.recruitQty.eq(query.getRecruitQty()));
        }
        /** 工作类型 1、全职2、兼职 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkType())) {
            list.add(qdo.workType.eq(query.getWorkType()));
        }
        /** 服务方式 1、现场 2、远程 3、按需 精确 */
        if (!ObjectUtils.isEmpty(query.getServiceMode())) {
            list.add(qdo.serviceMode.eq(query.getServiceMode()));
        }
        /** 时间要求 1、常规固定 2、灵活安排 精确 */
        if (!ObjectUtils.isEmpty(query.getTimeRequirement())) {
            list.add(qdo.timeRequirement.eq(query.getTimeRequirement()));
        }
        /** 岗位简介 精确 */
        if (!ObjectUtils.isEmpty(query.getJobProfile())) {
            list.add(qdo.jobProfile.eq(query.getJobProfile()));
        }
        /** 岗位要求 精确 */
        if (!ObjectUtils.isEmpty(query.getJobRequirement())) {
            list.add(qdo.jobRequirement.eq(query.getJobRequirement()));
        }
        /** 是否运行内部推荐(0,1) 精确 */
        if (!ObjectUtils.isEmpty(query.getInternalFlag())) {
            list.add(qdo.internalFlag.eq(query.getInternalFlag()));
        }
        /** 外部资源可见 1、可见(选择) 0、不可见 精确 */
        if (!ObjectUtils.isEmpty(query.getExternalVisible())) {
            list.add(qdo.externalVisible.eq(query.getExternalVisible()));
        }
        /** 1、招聘中 2、招聘完成 3、招聘取消 精确 */
        if (!ObjectUtils.isEmpty(query.getRecruitmentStatus())) {
            list.add(qdo.recruitmentStatus.eq(query.getRecruitmentStatus()));
        }
        /** 招聘负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getManagerUserId())) {
            list.add(qdo.managerUserId.eq(query.getManagerUserId()));
        }
        /** 招聘分类一 精确 */
        if (!ObjectUtils.isEmpty(query.getJobType1())) {
            list.add(qdo.jobType1.eq(query.getJobType1()));
        }
        /** 招聘分类二 精确 */
        if (!ObjectUtils.isEmpty(query.getJobType2())) {
            list.add(qdo.jobType2.eq(query.getJobType2()));
        }
        /** 招聘分类二 精确 */
        if (query.getInternalFlag() != null && !query.getInternalFlag() ) {
            list.add(qdo.externalVisible.eq(true));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdRecruitPositionVO queryByKey(Long id) {
        JPAQuery<PrdRecruitPositionVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdRecruitPositionVO> queryListDynamic(PrdRecruitPositionQuery query) {
        JPAQuery<PrdRecruitPositionVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdRecruitPositionVO> queryPaging(PrdRecruitPositionQuery query) {
//        long total = count(query);
//        if (total == 0) {
//             return PagingVO.empty();
//        }
        JPAQuery<PrdRecruitPositionVO> jpaQuery = getJpaQueryWhere(query);
        List<PrdRecruitPositionVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdRecruitPositionVO>builder().records(result).total(jpaQuery.fetchCount()).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdRecruitPositionDO save(PrdRecruitPositionDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdRecruitPositionDO> saveAll(List<PrdRecruitPositionDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PrdRecruitPositionPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 主键id
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 招聘编号
        if (payload.getJobNo() != null) {
            update.set(qdo.jobNo, payload.getJobNo());
        }
        // 招聘名称
        if (payload.getJobTitle() != null) {
            update.set(qdo.jobTitle, payload.getJobTitle());
        }
        // 招聘部门 （组织Id）
        if (payload.getBaseBuId() != null) {
            update.set(qdo.baseBuId, payload.getBaseBuId());
        }
        // 工作地
        if (payload.getBaseRegion() != null) {
            update.set(qdo.baseRegion, payload.getBaseRegion());
        }
        // 工作地说明
        if (payload.getBaseRegionDesc() != null) {
            update.set(qdo.baseRegionDesc, payload.getBaseRegionDesc());
        }
        // 招聘人数
        if (payload.getRecruitQty() != null) {
            update.set(qdo.recruitQty, payload.getRecruitQty());
        }
        // 工作类型 1、全职2、兼职
        if (payload.getWorkType() != null) {
            update.set(qdo.workType, payload.getWorkType());
        }
        // 服务方式 1、现场 2、远程 3、按需
        if (payload.getServiceMode() != null) {
            update.set(qdo.serviceMode, payload.getServiceMode());
        }
        // 时间要求 1、常规固定 2、灵活安排
        if (payload.getTimeRequirement() != null) {
            update.set(qdo.timeRequirement, payload.getTimeRequirement());
        }
        // 岗位简介
        if (payload.getJobProfile() != null) {
            update.set(qdo.jobProfile, payload.getJobProfile());
        }
        // 岗位要求
        if (payload.getJobRequirement() != null) {
            update.set(qdo.jobRequirement, payload.getJobRequirement());
        }
        // 是否运行内部推荐(0,1)
        if (payload.getInternalFlag() != null) {
            update.set(qdo.internalFlag, payload.getInternalFlag());
        }
        // 外部资源可见 1、可见(选择) 0、不可见
        if (payload.getExternalVisible() != null) {
            update.set(qdo.externalVisible, payload.getExternalVisible());
        }
        // 1、招聘中 2、招聘完成 3、招聘取消
        if (payload.getRecruitmentStatus() != null) {
            update.set(qdo.recruitmentStatus, payload.getRecruitmentStatus());
        }
        // 招聘负责人
        if (payload.getManagerUserId() != null) {
            update.set(qdo.managerUserId, payload.getManagerUserId());
        }
        // 招聘分类一
        if (payload.getJobType1() != null) {
            update.set(qdo.jobType1, payload.getJobType1());
        }
        // 招聘分类二
        if (payload.getJobType2() != null) {
            update.set(qdo.jobType2, payload.getJobType2());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键id
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 招聘编号
            if (nullFields.contains("jobNo")) {
                update.setNull(qdo.jobNo);
            }
            // 招聘名称
            if (nullFields.contains("jobTitle")) {
                update.setNull(qdo.jobTitle);
            }
            // 招聘部门 （组织Id）
            if (nullFields.contains("baseBuId")) {
                update.setNull(qdo.baseBuId);
            }
            // 工作地
            if (nullFields.contains("baseRegion")) {
                update.setNull(qdo.baseRegion);
            }
            // 工作地说明
            if (nullFields.contains("baseRegionDesc")) {
                update.setNull(qdo.baseRegionDesc);
            }
            // 招聘人数
            if (nullFields.contains("recruitQty")) {
                update.setNull(qdo.recruitQty);
            }
            // 工作类型 1、全职2、兼职
            if (nullFields.contains("workType")) {
                update.setNull(qdo.workType);
            }
            // 服务方式 1、现场 2、远程 3、按需
            if (nullFields.contains("serviceMode")) {
                update.setNull(qdo.serviceMode);
            }
            // 时间要求 1、常规固定 2、灵活安排
            if (nullFields.contains("timeRequirement")) {
                update.setNull(qdo.timeRequirement);
            }
            // 岗位简介
            if (nullFields.contains("jobProfile")) {
                update.setNull(qdo.jobProfile);
            }
            // 岗位要求
            if (nullFields.contains("jobRequirement")) {
                update.setNull(qdo.jobRequirement);
            }
            // 是否运行内部推荐(0,1)
            if (nullFields.contains("internalFlag")) {
                update.setNull(qdo.internalFlag);
            }
            // 外部资源可见 1、可见(选择) 0、不可见
            if (nullFields.contains("externalVisible")) {
                update.setNull(qdo.externalVisible);
            }
            // 1、招聘中 2、招聘完成 3、招聘取消
            if (nullFields.contains("recruitmentStatus")) {
                update.setNull(qdo.recruitmentStatus);
            }
            // 招聘负责人
            if (nullFields.contains("managerUserId")) {
                update.setNull(qdo.managerUserId);
            }
            // 招聘分类一
            if (nullFields.contains("jobType1")) {
                update.setNull(qdo.jobType1);
            }
            // 招聘分类二
            if (nullFields.contains("jobType2")) {
                update.setNull(qdo.jobType2);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

